(import "test")
;;; -*- lisp -*-
;;;
;;; Chapter 7 Object System
;;;

;;;------------------------------------------------------------
;;; [defining oparator]
;;;
;;;  (defclass class-name (sc-name*) (slot-spec*) class-opt*)
;;;    --> <symbol>
;;;------------------------------------------------------------
($ap 1 "defclass")

($argc defclass 3 0 1)
($stype defclass ($symbol $null) :target () ())
;;($stype defclass ($cons $null) foo :target ())
;;($stype defclass ($cons $null) foo () :target)
;;
;;;
($error1 (+ (defclass foo () ())) <error>)

;;;----------  ----------
;;; special operator
($error (defclass if () ()) <program-error>)
;;; keyword 
($error (defclass :a () ()) <program-error>)
($error (defclass &a () ()) <program-error>)
;;;
($error (defclass <object> () ()) <error>)

;;;---------- ----------
;;;
($eval (defclass a () ()))
($error (defclass foo (a a) ()) <error>)
;;;
($error (defclass foo (undef) ()) <undefined-entity>)
;;;
($error (defclass foo (<object>) ()) <error>)

;;;----------  ----------
;;;
($error (defclass foo () (:a)) <program-error>)
($error (defclass foo () (&a)) <program-error>)
;;;
($error (defclass foo () (a a)) <error>)
($error (defclass foo () (a (a :initarg a))) <error>)
;;; :reader
($error (defclass foo () ((a :reader))) <error>)
($error (defclass foo () ((a :reader a-a a-b))) <error>)
($error (defclass foo () ((a :reader :a))) <program-error>)
;;; :writer
($error (defclass foo () ((a :writer))) <error>)
($error (defclass foo () ((a :writer a-a a-b))) <error>)
($error (defclass foo () ((a :writer :a))) <program-error>)
;;; :accessor
($error (defclass foo () ((a :accessor))) <error>)
($error (defclass foo () ((a :accessor a-a a-b))) <error>)
($error (defclass foo () ((a :accessor :a))) <program-error>)
;;; :boundp
($error (defclass foo () ((a :boundp))) <error>)
($error (defclass foo () ((a :boundp a-a a-b))) <error>)
($error (defclass foo () ((a :boundp :a))) <program-error>)
;;; :initarg
($error (defclass foo () ((a :initarg))) <error>)
($error (defclass foo () ((a :initarg a b))) <error>)
($error (defclass foo () ((a :initarg :a))) <program-error>)
;;; :initarg
($error (defclass foo () ((a :initarg a :initarg aa))) <error>)
;;; :initform
($error (defclass foo () ((a :initform))) <error>)
($error (defclass foo () ((a :initform 1 2))) <error>)
;;; :initform
($error (defclass foo () ((a :initform 1 :initform 2))) <error>)
;;; 
($error (defclass foo () ((a 1 2))) <error>)
($error (defclass foo () ((a :foo foo))) <error>)
;;;----------  ----------
;;; 
($error (defclass foo () () ()) <error>)
($error (defclass foo () () :metaclass) <error>)
($error (defclass foo () () :abstractp) <error>)
($error (defclass foo () () ((:metaclss <standard-class>))) <error>)
($error (defclass foo () () ((:abstractp nil))) <error>)
;;; 
($error (defclass foo () () (:foo foo)) <error>)
;;; :metaclass 
($error (defclass foo () () (:metaclass)) <error>)
($error (defclass foo () () 
	  (:metaclass <standard-class> <standard-class>)) <error>)
;;; :metaclass 
($test (defclass foo-1 () () (:metaclass <standard-class>)) foo-1)
($error (defclass foo () () (:metaclass (<standard-class>))) 
	<error>)
($error (defclass foo () () (:metaclass <object>)) <error>)
($error (defclass foo () () (:metaclass foo)) <error>)
;;; :metaclass
($error (defclass foo () () 
	  (:metaclass <standard-class>) (:metaclass <stnadard-class>))
	<error>)
;;; :abstractp
($test (defclass foo-2 () () (:abstractp nil)) foo-2)
($test (defclass bar () () (:abstractp t)) bar)
($error (defclass baz () () (:abstractp foo)) <error>)
;;; :abstractp
($error (defclass foo () () (:abstractp)) <error>)
($error (defclass foo () () (:abstractp t t)) <error>)
;;; :abstractp
($test (defclass foo-3 () () 
   (:abstractp nil) (:abstractp nil)) foo-3)
($test (defclass foo-4 () () 
   (:abstractp t) (:abstractp t)) foo-4)
($error (defclass foo () ()
	  (:abstractp t) (:abstractp nil))
	<error>)
;;
;;
($eval (defclass a-1 () ()))
($eval (defclass b-1 (a-1) ()))
($error (defclass c-1 (b-1 a-1) ()) <error>)
;; 
($eval 
 (defclass foo-5 () 
   ((a :reader read-foo-a
       :writer write-foo-a
       :accessor access-foo-a
       :boundp boundp-foo-a
       :initarg a
       :initform 1))))
;;
($test (generic-function-p #'read-foo-a) t)
($test (generic-function-p #'write-foo-a) t)
($test (generic-function-p #'access-foo-a) t)
($test (generic-function-p #'boundp-foo-a) t)
;;
($argc read-foo-a 1 0 0)
($argc write-foo-a 2 0 0)
($argc access-foo-a 1 0 0)
($argc boundp-foo-a 1 0 0)
;;
($eval (defglobal x (create (class foo-5))))
;;
($test (boundp-foo-a x) t)
($test (read-foo-a x) 1 eql)
($test (access-foo-a x) 1 eql)
;;
($test (write-foo-a 10 x) 10 eql)
($test (boundp-foo-a x) t)
($test (read-foo-a x) 10 eql)
($test (access-foo-a x) 10 eql)
;;
($test (setf (access-foo-a x) 100) 100 eql)
($test (boundp-foo-a x) t)
($test (read-foo-a x) 100 eql)
($test (access-foo-a x) 100 eql)
;;
($eval (defglobal x (create (class foo-5) 'a 10)))
;;
($test (boundp-foo-a x) t)
($test (read-foo-a x) 10 eql)
($test (access-foo-a x) 10 eql)
;;
($eval (defglobal x (create (class foo-5) 'b 99)))
;;
($test (boundp-foo-a x) t)
($test (read-foo-a x) 1 eql)
($test (access-foo-a x) 1 eql)
;;
($eval
 (defclass foo-6 ()
   ((a :reader read-foo-a
       :writer write-foo-a
       :accessor access-foo-a
       :boundp boundp-foo-a))))
;;
($eval (defglobal x (create (class foo-6))))
;;
($test (boundp-foo-a x) nil)
($error (read-foo-a x) <error>)
($error (access-foo-a x) <error>)
;;
($test (write-foo-a 10 x) 10 eql)
($test (boundp-foo-a x) t)
($test (read-foo-a x) 10 eql)
($test (access-foo-a x) 10 eql)

;;;------------------------------------------------------------
;;; [function]
;;;
;;;  (generic-function-p obj) --> boolean
;;;------------------------------------------------------------
($argc generic-function-p 1 0 0)
($predicate generic-function-p $generic)
;;
($eval (defgeneric foo-g-1 (x)))
($test (generic-function-p #'foo-g-1) t)
($eval (defun foo-9 (x)))
($test (generic-function-p #'foo-9) nil)
;;;------------------------------------------------------------
;;; [defining oparator]
;;;
;;;  (defgeneric func-spec lambda-list {option | method-desc}*)
;;;    --> <symbol>
;;;------------------------------------------------------------
($argc defgeneric 2 0 1)
($stype defgeneric ($symbol $null) :target (x))
;;($stype defgeneric ($cons $null) foo :target)
;;;
($error1 (+ (defgeneric foo ())) <error>)
;; :method-combination 
($error (defgeneric foo () (:method-combination undef)) 
	<error>)
;; :generic-function-class
($error (defgeneric foo () (:generic-function-class undef))
	<error>)
;; option
($error (defgeneric foo () (:foo foo)) <error>)
;; special operator
($error (defgeneric if ()) <program-error>)
;; keyword 
($error (defgeneric :a ()) <program-error>)
($error (defgeneric &a ()) <program-error>)
;;;
($error (defgeneric create () ()) <program-error>)

;;;------------------------------------------------------------
;;; [defining oparator]
;;;
;;;  (defmethod func-spec method-qualifier* parameter-profile form*)
;;;    --> <symbol>
;;;------------------------------------------------------------
($argc defmethod 2 0 1)
($stype defmethod ($symbol $null) :target (x))
;;($stype defmethod ($symbol $null $t $cons) $ERR_Syntax foo :target () ())
;;($stype defmethod ($null $cons) foo :target () ())
;;($eval (defgeneric foo ()))
;;($stype defmethod ($cons $null) $ERR_IllegalBind foo :before :target)
;;;
($eval (defgeneric foo-g-2 ()))
($error1 (+ (defmethod foo-g-2 ())) <error>)
;; 
($error (defmethod foo-g-2 :foo ()) <error>)
($error (defgeneric foo-g-2 ()
	  (:method :foo ())) <error>)
;;
($eval (defgeneric bar-g-2 () (:method-combination nil)))
($error (defmethod bar-g-2 :around ()) <error>)
($error (defmethod bar-g-2 :before ()) <error>)
($error (defmethod bar-g-2 :after ()) <error>)
($error (defgeneric bar-g-2 () (:method-combination nil)
	  (:method bar :around ())) 
	<error>)
($error (defgeneric bar-g-2 () (:method-combination nil)
	  (:method bar :before ()))
	<error>)
($error (defgeneric bar-g-2 () (:method-combination nil)
	  (:method bar :after ()))
	<error>)
;;
($error (defmethod undef (x)) <undefined-function>)
;;
($eval (defgeneric foo-g-3 (x)))
($error (defmethod foo-g-3 ((x undef))) <undefined-entity>)
($error (defgeneric foo-g-3 (x)
	  (:method ((x undef))))
	<undefined-entity>)
;;
;;

($eval (defgeneric foo-g-4 (x)))
($eval (defmethod foo-g-4 (x) 'object-1))
($eval (defmethod foo-g-4 :around (x) 'around-object-1))
($eval (defmethod foo-g-4 :before (x) 'before-object-1))
($eval (defmethod foo-g-4 :after (x) 'after-object-1))
;; 
($eval (defclass aa () ()))
($eval (defgeneric foo-g-5 (x)))
($eval (defmethod foo-g-5 ((x aa)) 'aa-1))
($eval (defmethod foo-g-5 :around ((x aa)) 'around-aa-1))
($eval (defmethod foo-g-5 :before ((x aa)) 'before-aa-1))
($eval (defmethod foo-g-5 :after ((x aa)) 'after-aa-1))
;;
($eval (defun foo-10 (x)))
($error (defmethod foo-10 (x)) <error>)
($eval (defmacro m-foo-1 (x)))
($error (defmethod m-foo-1 (x)) <error>)
($error (defmethod if (x)) <program-error>)
($error (defmethod car (x)) <program-error>)
;;
($error (defmethod undef (x)) <undefined-function>)
;;
;;
($eval (defgeneric foo-g-6 (x)))
($test (defmethod foo-g-6 (x)) foo-g-6)
($error (defmethod foo-g-6 ()) <error>)
($error (defgeneric foo-g-7 (x)
	  (:method ()))
	<error>)
($error (defmethod foo-g-7 (x &rest r)) <error>)
($error (defgeneric  foo-g-8 (x)
	  (:method (x &rest r)))
	<error>)
($error (defmethod foo-g-8 (x :rest r)) <error>)
($error (defgeneric foo-g-9 (x)
	  (:method (x :rest r)))
	<error>)
($error (defmethod foo-g-9 (x y)) <error>)
($error (defgeneric foo-g-10 (x)
	  (:method (x y)))
	<error>)


;;
($eval (defgeneric foo-g-11 (x &rest r)))
($test (defmethod foo-g-11 (x &rest r)) foo-g-11)
($error (defmethod foo-g-11 ()) <error>)
($error (defgeneric foo-g-12 (x &rest r)
	  (:method ()))
	<error>)
($error (defmethod foo-g-12 (&rest r)) <error>)
($error (defgeneric foo-g-13 (x &rest r)
	  (:method (&rest r)))
	<error>)
($error (defmethod foo-g-13 (:rest r)) <error>)
($error (defgeneric foo-g-14 (x &rest r)
	  (:method (:rest r)))
	<error>)
($error (defmethod foo-g-14 (x)) <error>)
($error (defgeneric foo-g-15 (x &rest r)
	  (:method (x)))
	<error>)
($error (defmethod foo-g-15 (x y)) <error>)
($error (defgeneric foo-g-16 (x &rest r)
	  (:method (x y)))
	<error>)
($error (defmethod foo-g-16 (x y &rest r)) <error>)
($error (defgeneric foo-g-17 (x &rest r)
	  (:method (x y &rest r)))
	<error>)
($error (defmethod foo-g-17 (x y :rest r)) <error>)
($error (defgeneric foo-g-18 (x &rest r)
	  (:method (x y :rest r)))
	<error>)
;;
($eval (defgeneric foo-g-19 (x :rest r)))
($test (defmethod foo-g-19 (x :rest r)) foo-g-19)
($error (defmethod foo-g-19 ()) <error>)
($error (defgeneric foo-g-20 (x :rest r)
	  (:method ()))
	<error>)
($error (defmethod foo-g-20 (&rest r)) <error>)
($error (defgeneric foo-g-21 (x :rest r)
	  (:method (&rest r)))
	<error>)
($error (defmethod foo-g-21 (:rest r)) <error>)
($error (defgeneric foo-g-22 (x :rest r)
	  (:method (:rest r)))
	<error>)
($error (defmethod foo-g-22 (x)) <error>)
($error (defgeneric foo-g-23 (x :rest r)
	  (:method (x)))
	<error>)
($error (defmethod foo-g-23 (x y)) <error>)
($error (defgeneric foo-g-24 (x :rest r)
	  (:method (x y)))
	<error>)
($error (defmethod foo-g-24 (x y &rest r)) <error>)
($error (defgeneric foo-g-25 (x :rest r)
	  (:method (x y &rest r)))
	<error>)
($error (defmethod foo-g-25 (x y :rest r)) <error>)
($error (defgeneric foo-g-26 (x :rest r)
	  (:method (x y :rest r)))
	<error>)

;;
;($eval (defclass nil () ()))
($eval (defgeneric foo-g-27 (x)))
($eval (defmethod foo-g-27 ((x nil)) 'primary-nil))
;($test (foo-g-27 (create (class nil))) primary-nil)
($eval (defgeneric foo-g-28 (x)
	 (:method ((x nil)) 'primary-nil)))
;($test (foo-g-28 (create (class nil))) primary-nil)
;;
($eval (defgeneric foo-g-29 (x)))
($error (foo-g-29 3) <error>)
;;
($eval (defclass c1 () ()))
($eval (defclass c2 (c1) ()))
($eval (defclass c3 (c2) ()))
($eval (defclass c4 () ()))
($eval (defglobal c1 (create (class c1))))
($eval (defglobal c2 (create (class c2))))
($eval (defglobal c3 (create (class c3))))
($eval (defglobal c4 (create (class c4))))
($eval 
 (defgeneric foo-g-30 (x y)
   (:method (x y)
	    '(<object> <object>))
   (:method (x (y c1))
	    '(<object> c1))
   (:method (x (y c2))
	    '(<object> c2))
   (:method (x (y c3))
	    '(<object> c3))
   (:method ((x c1) y)
	    '(c1 <object>))
   (:method ((x c1) (y c1))
	    '(c1 c1))
   (:method ((x c1) (y c2))
	    '(c1 c2))
   (:method ((x c1) (y c3))
	    '(c1 c3))
   (:method ((x c2) y)
	    '(c2 <object>))
   (:method ((x c2) (y c1))
	    '(c2 c1))
   (:method ((x c2) (y c2))
	    '(c2 c2))
   (:method ((x c2) (y c3))
	    '(c2 c3))
   (:method ((x c3) y)
	    '(c3 <object>))
   (:method ((x c3) (y c1))
	    '(c3 c1))
   (:method ((x c3) (y c2))
	    '(c3 c2))
   (:method ((x c3) (y c3))
	    '(c3 c3))
   ))

($test (foo-g-30 1 1) (<object> <object>) equal)
($test (foo-g-30 1 c1) (<object> c1) equal)
($test (foo-g-30 1 c2) (<object> c2) equal)
($test (foo-g-30 1 c3) (<object> c3) equal)
($test (foo-g-30 1 c4) (<object> <object>) equal)
($test (foo-g-30 c1 1) (c1 <object>) equal)
($test (foo-g-30 c1 c1) (c1 c1) equal)
($test (foo-g-30 c1 c2) (c1 c2) equal)
($test (foo-g-30 c1 c3) (c1 c3) equal)
($test (foo-g-30 c1 c4) (c1 <object>) equal)
($test (foo-g-30 c2 1) (c2 <object>) equal)
($test (foo-g-30 c2 c1) (c2 c1) equal)
($test (foo-g-30 c2 c2) (c2 c2) equal)
($test (foo-g-30 c2 c3) (c2 c3) equal)
($test (foo-g-30 c2 c4) (c2 <object>) equal)
($test (foo-g-30 c3 1) (c3 <object>) equal)
($test (foo-g-30 c3 c1) (c3 c1) equal)
($test (foo-g-30 c3 c2) (c3 c2) equal)
($test (foo-g-30 c3 c3) (c3 c3) equal)
($test (foo-g-30 c3 c4) (c3 <object>) equal)
($test (foo-g-30 c4 1) (<object> <object>) equal)
($test (foo-g-30 c4 c1) (<object> c1) equal)
($test (foo-g-30 c4 c2) (<object> c2) equal)
($test (foo-g-30 c4 c3) (<object> c3) equal)
($test (foo-g-30 c4 c4) (<object> <object>) equal)
;; 

($eval (defglobal *call-tree* nil))
($eval 
 (defun add-call-tree (x)
   (setq *call-tree* (cons x *call-tree*))))
($eval (defgeneric foo-sub-1 (x)))
($eval (defmethod foo-sub-1 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval
 (defun foo-11 (x)
   (setq *call-tree* nil)
   (foo-sub-1 x)
   (reverse *call-tree*)))
($test (foo-11 3) (primary-<integer>) equal)
($error (foo-11 3.3) <error>)
;;
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-2 (x) (:method-combination nil)))
($eval (defmethod foo-sub-2 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval
 (defun foo-12 (x)
   (setq *call-tree* nil)
   (foo-sub-2 x)
   (reverse *call-tree*)))
($test (foo-12 3) (primary-<integer>) equal)
($error (foo-12 3.3) <error>)
;; 
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-3 (x)))
($eval (defmethod foo-sub-3 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval (defmethod foo-sub-3 :around ((x <integer>)) 
	 (add-call-tree 'around-<integer>)))
($eval (defmethod foo-sub-3 :before ((x <integer>)) 
	 (add-call-tree 'before-<integer>)))
($eval (defmethod foo-sub-3 :after ((x <integer>)) 
	 (add-call-tree 'after-<integer>)))
($eval
 (defun foo-13 (x)
   (setq *call-tree* nil)
   (foo-sub-3 x)
   (reverse *call-tree*)))
($test (foo-13 3) (around-<integer>) equal)
($error (foo-13 3.3) <error>)
;; 
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-4 (x)))
($eval (defmethod foo-sub-4 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval (defmethod foo-sub-4 :before ((x <integer>)) 
	 (add-call-tree 'before-<integer>)))
($eval
 (defun foo-14 (x)
   (setq *call-tree* nil)
   (foo-sub-4 x)
   (reverse *call-tree*)))
($test (foo-14 3) (before-<integer>
	  primary-<integer>) 
 equal)
($error (foo-14 3.3) <error>)
;; 
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-5 (x)))
($eval (defmethod foo-sub-5 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval (defmethod foo-sub-5 :after ((x <integer>)) 
	 (add-call-tree 'after-<integer>)))
($eval
 (defun foo-15 (x)
   (setq *call-tree* nil)
   (foo-sub-5 x)
   (reverse *call-tree*)))
($test (foo-15 3) (primary-<integer>
	  after-<integer>)
 equal)
($error (foo-15 3.3) <error>)
;; 
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-6 (x)))
($eval (defmethod foo-sub-6 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval (defmethod foo-sub-6 :before ((x <integer>)) 
	 (add-call-tree 'before-<integer>)))
($eval (defmethod foo-sub-6 :after ((x <integer>)) 
	 (add-call-tree 'after-<integer>)))
($eval
 (defun foo-16 (x)
   (setq *call-tree* nil)
   (foo-sub-6 x)
   (reverse *call-tree*)))
($test (foo-16 3) (before-<integer>
	  primary-<integer>
	  after-<integer>) 
 equal)
($error (foo-16 3.3) <error>)
;; 
($eval (defglobal *call-tree* nil))
($eval (defgeneric foo-sub-7 (x)))
($eval (defmethod foo-sub-7 ((x <integer>)) 
	 (add-call-tree 'primary-<integer>)))
($eval (defmethod foo-sub-7 (x)
	 (add-call-tree 'primary-<object>)))
($eval (defmethod foo-sub-7 :before ((x <integer>)) 
	 (add-call-tree 'before-<integer>)))
($eval (defmethod foo-sub-7 :before (x)
	 (add-call-tree 'before-<object>)))
($eval (defmethod foo-sub-7 :after ((x <integer>)) 
	 (add-call-tree 'after-<integer>)))
($eval (defmethod foo-sub-7 :after (x)
	 (add-call-tree 'after-<object>)))
($eval
 (defun foo-17 (x)
   (setq *call-tree* nil)
   (foo-sub-7 x)
   (reverse *call-tree*)))
($test (foo-17 3) (before-<integer>
	  before-<object>
	  primary-<integer>
	  after-<object>
	  after-<integer>) 
 equal)
($test (foo-17 3.3) (before-<object>
	    primary-<object>
	    after-<object>)
 equal)
;; 
($eval (defgeneric (setf foo-18) (x y z)))
($eval (defmethod (setf foo-18) (x y z) (list x y z)))
($test (setf (foo-18 1 2) 3) (3 1 2) equal)
($error (setf (foo-18 1) 2) <program-error>)
($error (setf (foo-18 1 2 3) 4) <program-error>)
($error (setf (bar 1 2) 3) <error>)
;;
;($eval (defgeneric (setf nil) (x y z)))
;($eval (defmethod (setf nil) (x y z) (list x y z)))
;($test (setf (nil 1 2) 3) (3 1 2) equal)
;($error (setf (nil 1) 2) <program-error>)
;($error (setf (nil 1 2 3) 4) <program-error>)
;;;------------------------------------------------------------
;;; [local function]
;;;
;;;  (call-next-method) --> <object>
;;;------------------------------------------------------------
($argc call-next-method 0 0 0)
;;
($error (call-next-method) <undefined-function>)
($error (call-next-method 1) <undefined-function>)

($eval (defun foo-19 () (call-next-method)))
($error (foo-19) <undefined-function>)
($eval (defun foo-20 () (call-next-method 1)))
($error (foo-20) <undefined-function>)
;; 
($eval (defgeneric foo-21 (x)))
($eval (defmethod foo-21 ((x <integer>)) 'integer))
($eval (defmethod foo-21 :before ((x <integer>)) (call-next-method)))
($error (foo-21 3) <error>)
;; 
($eval (defgeneric foo-22 (x)))
($eval (defmethod foo-22 ((x <integer>)) 'integer))
($eval (defmethod foo-22 :after ((x <integer>)) (call-next-method)))
($error (foo-22 3) <error>)
;;
($eval (defgeneric foo-23 (x)))
($eval (defmethod foo-23 ((x <integer>)) (call-next-method)))
($error (foo-23 3) <error>)
;;
($eval (defgeneric foo-24 (x)))
($eval (defmethod foo-24 (x) '<object>))
($eval (defmethod foo-24 ((x <integer>)) 
	 (call-next-method) ;; 
	 ))
($test (foo-24 3) <object>)
($eval (defgeneric foo-25 (x)))
($eval (defmethod foo-25 (x) '<object>))
($eval (defmethod foo-25 ((x <integer>)) 
	 (call-next-method 1) ;;
	 ))
($error (foo-25 3) <program-error>)
;;;------------------------------------------------------------
;;; [local function]
;;;
;;;  (next-method-p) --> boolean
;;;------------------------------------------------------------
;;($argc next-method-p 0 0 0)
;;
($error (next-method-p) <undefined-function>)
($error (next-method-p 1) <undefined-function>)
($eval (defun foo-26 () (next-method-p)))
($error (foo-26) <undefined-function>)
($eval (defun foo-27 () (next-method-p 1)))
($error (foo-27) <undefined-function>)
;;
($eval (defgeneric foo-28 (x)))
($eval (defmethod foo-28 (x) '<object>))
($eval (defmethod foo-28 ((x <integer>)) 
	 (if (next-method-p) ;;
	     (call-next-method))))
($test (foo-28 3) <object>)
($eval (defgeneric foo-29 (x)))
($eval (defmethod foo-29 (x) '<object>))
($eval (defmethod foo-29 ((x <integer>)) 
	 (if (next-method-p 1)  ;;
	     (call-next-method))))
($error (foo-29 3) <program-error>)
($eval (defglobal *call-tree* nil))
;;
($test (defclass c00 () ()) c00)
($test (defclass c11 () ()) c11)
($test (defclass c22 (c11) ()) c22)
($test (defclass c33 (c22) ()) c33)
;;
($eval (defglobal c00 (create (class c00))))
($eval (defglobal c11 (create (class c11))))
($eval (defglobal c22 (create (class c22))))
($eval (defglobal c33 (create (class c33))))
;;
($eval 
 (defgeneric foo-sub-30 (x)
   ;; <object>
   (:method (x) 
	    (add-call-tree 'primary-<object>))
   ;; <standard-object>
   (:method ((x <standard-object>))
	    (add-call-tree 'primary-<standard-object>-begin)
	    (call-next-method)
	    (add-call-tree 'primary-<standard-object>-end))
   (:method :around ((x <standard-object>))
	    (add-call-tree 'around-<standard-object>-begin)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'around-<standard-object>-end))
   (:method :before ((x <standard-object>))
	    (add-call-tree 'before-<standard-object>))
   (:method :after ((x <standard-object>))
	    (add-call-tree 'after-<standard-object>))
   ;; c11
   (:method ((x c11))
	    (add-call-tree 'primary-c1-begin)
	    (call-next-method)
	    (add-call-tree 'primary-c1-end))
   (:method :around ((x c11))
	    (add-call-tree 'around-c1-begin)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'around-c1-end))
   (:method :before ((x c11))
	    (add-call-tree 'before-c1))
   (:method :after ((x c11))
	    (add-call-tree 'after-c1))
   ;; c22
   (:method ((x c22))
	    (add-call-tree 'primary-c2-begin)
	    (call-next-method)
	    (add-call-tree 'primary-c2-end))
   (:method :around ((x c22))
	    (add-call-tree 'around-c2-begin)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'around-c2-end))
   (:method :before ((x c22))
	    (add-call-tree 'before-c2))
   (:method :after ((x c22))
	    (add-call-tree 'after-c2))
   ;; c33
   (:method ((x c33))
	    (add-call-tree 'primary-c3-begin)
	    (call-next-method)
	    (add-call-tree 'primary-c3-end))
   (:method :around ((x c33))
	    (add-call-tree 'around-c3-begin)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'around-c3-end))
   (:method :before ((x c33))
	    (add-call-tree 'before-c3))
   (:method :after ((x c33))
	    (add-call-tree 'after-c3))
   ))

;;
($eval
 (defun foo-30 (x)
   (setq *call-tree* nil)
   (foo-sub-30 x)
   (reverse *call-tree*)))
;;
($test (foo-30 1) (primary-<object>) equal)
($test (foo-30 c00) (around-<standard-object>-begin
	      before-<standard-object>
	      primary-<standard-object>-begin
	      primary-<object>
	      primary-<standard-object>-end
	      after-<standard-object>
	      around-<standard-object>-end)
 equal)
($test (foo-30 c11) (around-c1-begin
	      around-<standard-object>-begin
	      before-c1
	      before-<standard-object>
	      primary-c1-begin
	      primary-<standard-object>-begin
	      primary-<object>
	      primary-<standard-object>-end
	      primary-c1-end
	      after-<standard-object>
	      after-c1
	      around-<standard-object>-end
	      around-c1-end) 
 equal)

($test (foo-30 c22) (around-c2-begin
	      around-c1-begin
	      around-<standard-object>-begin
	      before-c2
	      before-c1
	      before-<standard-object>
	      primary-c2-begin
	      primary-c1-begin
	      primary-<standard-object>-begin
	      primary-<object>
	      primary-<standard-object>-end
	      primary-c1-end
	      primary-c2-end
	      after-<standard-object>
	      after-c1
	      after-c2
	      around-<standard-object>-end
	      around-c1-end
	      around-c2-end) 
 equal)
($test (foo-30 c33) (around-c3-begin
	      around-c2-begin
	      around-c1-begin
	      around-<standard-object>-begin
	      before-c3
	      before-c2
	      before-c1
	      before-<standard-object>
	      primary-c3-begin
	      primary-c2-begin
	      primary-c1-begin
	      primary-<standard-object>-begin
	      primary-<object>
	      primary-<standard-object>-end
	      primary-c1-end
	      primary-c2-end
	      primary-c3-end
	      after-<standard-object>
	      after-c1
	      after-c2
	      after-c3
	      around-<standard-object>-end
	      around-c1-end
	      around-c2-end 
	      around-c3-end) 
 equal)
;;
($eval 
 (defgeneric foo-31 (x)
   (:method ((x <integer>))
	    (lambda (y) (* y (call-next-method))))
   (:method ((x <number>))
	    (* x x))))
($eval (defglobal x (foo-31 3)))
($test (funcall x 5) 45 eql)
($test (funcall x 5) 45 eql)
;;
($eval
 (defgeneric foo-32 (x)
   (:method ((x <integer>))
	    (list x (call-next-method) (call-next-method)))
   (:method ((x <number>))
	    (* x x))
   (:method (x)
	    'never-called)))
($test (foo-32 3) (3 9 9) equal)
;;
($eval (defglobal *call-tree* '()))
($eval (defglobal *gf1* '()))
($eval (defglobal *gf2* '()))
($eval (defglobal *gf3* '()))
($eval (defglobal *gf4* '()))
($eval 
 (defgeneric foo-33 (x)
   ;;
   (:method ((x <integer>))
	    (add-call-tree 'i-primary-1)
	    (setq *gf1* (lambda (y) (list 'i-primary-1 x y)))
	    (call-next-method)
	    (add-call-tree 'i-primary-2)
	    (setq *gf2* (lambda (y) (list 'i-primary-2 (call-next-method) y)))
	    'i-primary-2)
   (:method :around ((x <integer>))
	    (add-call-tree 'i-around-1)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'i-around-2))
   (:method :before ((x <integer>))
	    (add-call-tree 'i-before))
   (:method :after ((x <integer>))
	    (add-call-tree 'i-after))
   ;;
   (:method ((x <number>))
	    (add-call-tree 'n-primary-1)
	    (setq *gf3* (lambda (y) (list 'n-primary-1 x y)))
	    (call-next-method)
	    (setq *gf4* (lambda (y) (list 'n-primary-2 (call-next-method) y)))
	    (add-call-tree 'n-primary-2))
   (:method :around ((x <number>))
	    (add-call-tree 'n-around-1)
	    (if (next-method-p)
		(call-next-method))
	    (add-call-tree 'n-around-2))
   (:method :before ((x <number>))
	    (add-call-tree 'n-before))
   (:method :after ((x <number>))
	    (add-call-tree 'n-after))
   ;;
   (:method (x)
	    (add-call-tree 'innermost))
   ))
($eval
 (defun cf1 ()
  (setq *call-tree* '())
  (funcall *gf1* 100)))
($eval 
 (defun cf2 ()
   (setq *call-tree* '())
   (funcall *gf2* 100)))
($eval 
 (defun cf3 ()
   (setq *call-tree* '())
   (funcall *gf3* 100)))
($eval
 (defun cf4 ()
   (setq *call-tree* '())
   (funcall *gf4* 100)))
($eval (foo-33 1))
($test (cf1) (i-primary-1 1 100) equal)
($test (cf2) (i-primary-2 (n-primary-2 innermost n-primary-1) 100) equal)
($test (cf3) (n-primary-1 1 100) equal)
;($test (cf4) (n-primary-2 (innermost) 100) equal)
;;
($eval 
 (defgeneric foo-34 (x)
   (:method :around (x) (call-next-method))))
($error (foo-34 3) <error>)
;;
($eval
 (defgeneric foo-35 (x)
   (:method :around (x) (call-next-method))
   (:method ((x <integer>)) 'primary-<integer>)))
($test (foo-35 3) primary-<integer>)
($error (foo-35 3.3) <error>)
;;
;;
($eval
 (defgeneric foo-36 (a b &rest c)
   (:method (a b &rest c)
	    (list 'default a b))
   (:method ((a <string>) (b <string>) &rest c)
	    (list (call-next-method) (string-append a b)))
   (:method ((a <integer>) (b <number>) &rest c)
	    (list (call-next-method) (list 'number a b)))
   (:method ((a <integer>) (b <integer>) &rest c)
	    (let ((x (list (foo-36 "foo" "bar" "yab"))))
	      ;;
	      (setq a (* a 10))
	      (setq b (* b 10))
	      (if (next-method-p)
		  (setq x (cons (call-next-method) x)))
	      (setq x (cons (list a b c) x))
	      x)))
 )

($test (foo-36 4 5 6 7 8)
 ((40 50 (6 7 8))
  ((default 4 5) (number 4 5))
  ((default "foo" "bar") "foobar"))
 equal)
;;
($eval
 (defgeneric foo-37 (a b c)
   (:method (a b c)
	    (list 'default a b))
   (:method ((a <string>) (b <string>) c)
	    (list (call-next-method) (string-append a b)))
   (:method ((a <integer>) (b <number>) c)
	    (list (call-next-method) (list 'number a b)))
   (:method ((a <integer>) (b <integer>) c)
	    (let ((x (list (foo-37 "foo" "bar" "yab"))))
	      ;;
	      (setq a (* a 10))
	      (setq b (* b 10))
	      (if (next-method-p)
		  (setq x (cons (call-next-method) x)))
	      (setq x (cons (list a b c) x))
	      x)))
 )

($test (foo-37 4 5 6)
 ((40 50 6)
  ((default 4 5) (number 4 5))
  ((default "foo" "bar") "foobar"))
 equal)
;;
($eval (defglobal f nil))
($eval (defgeneric foo-38 (x y)))
($eval (defmethod foo-38 (x y) (list x y)))
($eval (defmethod foo-38 ((x <integer>) (y <integer>))
	 (setq x (* x 10))
	 (setq y (* y 10))
	 (setq f (lambda () (if (next-method-p) (call-next-method))))
	 (list x y)))

($test (foo-38 2 3) (20 30) equal)
($test (funcall f) (2 3) equal)
;;
($eval (defglobal f nil))
($eval (defgeneric foo-39 (x y)))
($eval (defmethod foo-39 (x y) (list x y)))
($eval (defmethod foo-39 ((x <integer>) (y <integer>))
	 (setq x (* x 10))
	 (setq y (* y 10))
	 (setq f (lambda () 
		   (if (next-method-p) (list x y (call-next-method)))))
	 (list x y)))

($test (foo-39 2 3) (20 30) equal)
($test (funcall f) (20 30 (2 3)) equal)
;;
($eval (defglobal f nil))
($eval (defgeneric foo-40 (x y)))
($eval (defmethod foo-40 (x y) (list x y)))
($eval (defmethod foo-40 ((x <integer>) (y <integer>))
	 (setq x (* x 10))
	 (setq y (* y 10))
	 (let ((x 5) (y 6))
	   (setq f (lambda () 
		     (if (next-method-p) (list x y (call-next-method))))))
	 (list x y)))
($test (foo-40 2 3) (20 30) equal)
($test (funcall f) (5 6 (2 3)) equal)
;;
($eval (defgeneric foo-41 (a &rest r)))
($eval (defmethod foo-41 ((a <integer>) &rest r)
	 (setf (car r) 9)
	 (call-next-method)))
($eval (defmethod foo-41 ((a <number>) &rest r)
	 (car r)))
($test (foo-41 1 2) 2 eql)
;;;------------------------------------------------------------
;;; [generic function]
;;;
;;;  (create class {initarg initval}*) --> <object>
;;;------------------------------------------------------------
($eval (defclass foo () ((a :initarg a))))
;;
($error (create) <program-error>)
($error (create (class foo) 'a) <program-error>)
($error (create (class foo) 'a 10 'b) <program-error>)
;;
($error (create (class <object>)) <error>)
($error (create (class <basic-array>)) <error>)
($error (create (class <basic-array*>)) <error>)
($error (create (class <general-array*>)) <error>)
($error (create (class <basic-vector>)) <error>)
($error (create (class <general-vector>)) <error>)
($error (create (class <string>)) <error>)
($error (create (class <built-in-class>)) <error>)
($error (create (class <character>)) <error>)
($error (create (class <function>)) <error>)
($error (create (class <generic-function>)) <error>)
($error (create (class <standard-generic-function>)) <error>)
($error (create (class <list>)) <error>)
($error (create (class <cons>)) <error>)
($error (create (class <null>)) <error>)
($error (create (class <symbol>)) <error>)
($error (create (class <number>)) <error>)
($error (create (class <float>)) <error>)
($error (create (class <integer>)) <error>)
($error (create (class <serious-condition>)) <error>)
($error (create (class <error>)) <error>)
($error (create (class <arithmetic-error>)) <error>)
($error (create (class <division-by-zero>)) <error>)
($error (create (class <floating-point-overflow>)) <error>)
($error (create (class <floating-point-underflow>)) <error>)
($error (create (class <control-error>)) <error>)
($error (create (class <parse-error>)) <error>)
($error (create (class <program-error>)) <error>)
($error (create (class <domain-error>)) <error>)
($error (create (class <undefined-entity>)) <error>)
($error (create (class <unbound-variable>)) <error>)
($error (create (class <undefined-function>)) <error>)
($error (create (class <simple-error>)) <error>)
($error (create (class <stream-error>)) <error>)
($error (create (class <end-of-stream>)) <error>)
($error (create (class <storage-exhausted>)) <error>)
($error (create (class <standard-class>)) <error>)
($error (create (class <standard-object>)) <error>)
($error (create (class <stream>)) <error>)
($error (create (class <invalid>)) <error>)
;;
($eval (defclass foo () () (:abstractp t)))
($error (create (class foo)) <error>)
;;;------------------------------------------------------------
;;; [generic function]
;;;
;;;  (initialize-object instance initialization-list) --> <object>
;;;------------------------------------------------------------
($argc initialize-object 2 0 0)
;;($type initialize-object ($instance) :target nil)
;;
($test (defclass c0 ()
   ((x :initform 0 :accessor c0-x :initarg x)
    (y :initform 1 :accessor c0-y :initarg y)))
 c0)
($test (defmethod initialize-object ((instance c0) init-list)
   (if (next-method-p)
       (call-next-method))
   (if (= (c0-x instance) 0)
       (setf (c0-x instance) t))
   instance) 
 initialize-object)
;;
;($eval (defglobal c0 (create (class c0))))
;($test (c0-x c0) t)
;;;------------------------------------------------------------
;;; [function]
;;;
;;;  (class-of obj) --> <class>
;;;------------------------------------------------------------
($argc class-of 1 0 0)
;; <general-array*>
($test (eq (class-of (create-array '())) (class <general-array*>)) t)
($test (eq (class-of #2a((a b) (c d))) (class <general-array*>)) t)
;; <general-vector>
($test (eq (class-of (create-vector 3)) (class <general-vector>)) t)
($test (eq (class-of #(a b c)) (class <general-vector>)) t)
;; <string>
($test (eq (class-of (create-string 3 #\a)) (class <string>)) t)
($test (eq (class-of "foo") (class <string>)) t)


;; <built-in-class>
($test (eq (class-of (class <object>)) (class <built-in-class>)) t)
($test (eq (class-of (class <basic-array>)) (class <built-in-class>)) t)
($test (eq (class-of (class <basic-array*>)) (class <built-in-class>)) t)
($test (eq (class-of (class <general-array*>)) (class <built-in-class>)) t)
($test (eq (class-of (class <basic-vector>)) (class <built-in-class>)) t)
($test (eq (class-of (class <general-vector>)) (class <built-in-class>)) t)
($test (eq (class-of (class <string>)) (class <built-in-class>)) t)
($test (eq (class-of (class <built-in-class>)) (class <built-in-class>)) t)
($test (eq (class-of (class <character>)) (class <built-in-class>)) t)
($test (eq (class-of (class <function>)) (class <built-in-class>)) t)
($test (eq (class-of (class <generic-function>)) (class <built-in-class>)) t)
($test (eq (class-of (class <standard-generic-function>)) (class <built-in-class>)) t)
($test (eq (class-of (class <list>)) (class <built-in-class>)) t)
($test (eq (class-of (class <cons>)) (class <built-in-class>)) t)
($test (eq (class-of (class <null>)) (class <built-in-class>)) t)
($test (eq (class-of (class <symbol>)) (class <built-in-class>)) t)
($test (eq (class-of (class <number>)) (class <built-in-class>)) t)
($test (eq (class-of (class <float>)) (class <built-in-class>)) t)
($test (eq (class-of (class <integer>)) (class <built-in-class>)) t)
($test (eq (class-of (class <serious-condition>)) (class <built-in-class>)) t)
($test (eq (class-of (class <error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <arithmetic-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <division-by-zero>)) (class <built-in-class>)) t)
($test (eq (class-of (class <floating-point-overflow>)) (class <built-in-class>)) t)
($test (eq (class-of (class <floating-point-underflow>)) (class <built-in-class>)) t)
($test (eq (class-of (class <control-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <parse-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <program-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <domain-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <undefined-entity>)) (class <built-in-class>)) t)
($test (eq (class-of (class <unbound-variable>)) (class <built-in-class>)) t)
($test (eq (class-of (class <undefined-function>)) (class <built-in-class>)) t)
($test (eq (class-of (class <simple-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <stream-error>)) (class <built-in-class>)) t)
($test (eq (class-of (class <end-of-stream>)) (class <built-in-class>)) t)
($test (eq (class-of (class <storage-exhausted>)) (class <built-in-class>)) t)
($test (eq (class-of (class <standard-class>)) (class <built-in-class>)) t)
($test (eq (class-of (class <standard-object>)) (class <built-in-class>)) t)
($test (eq (class-of (class <stream>)) (class <built-in-class>)) t)
($test (eq (class-of (class <invalid>)) (class <built-in-class>)) t)
;; <character>
($test (eq (class-of #\a) (class <character>)) t)
;; <function>
($test (eq (class-of (lambda (x) x)) (class <function>)) t)
($test (eq (class-of #'+) (class <function>)) t)
;; <standard-generic-function>
($eval (defgeneric foo (x)))
($test (eq (class-of #'foo) (class <standard-generic-function>)) t)
($test (eq (class-of #'create) (class <standard-generic-function>)) t)
;; <cons>
($test (eq (class-of '(1 . 2)) (class <cons>)) t)
($test (eq (class-of '(1 2)) (class <cons>)) t)
;; <null>
($test (eq (class-of nil) (class <null>)) t)
($test (eq (class-of ()) (class <null>)) t)
($test (eq (class-of '()) (class <null>)) t)
;; <symbol>
($test (eq (class-of 'a) (class <symbol>)) t)
;; <integer>
;; in Easy-ISLisp extened sub class of <integer>
;; <fixnum> <longnum> <bignum>
($test (eq (class-of 1) (class <fixnum>)) t)
($test (eq (class-of +1) (class <fixnum>)) t)
($test (eq (class-of -1) (class <fixnum>)) t)
($test (eq (class-of 1234567890) (class <longnum>)) t)
($test (eq (class-of +1234567890) (class <longnum>)) t)
($test (eq (class-of -1234567890) (class <longnum>)) t)
;; <float>
($test (eq (class-of 1.234) (class <float>)) t)
($test (eq (class-of +1.234) (class <float>)) t)
($test (eq (class-of -1.234) (class <float>)) t)
($test (eq (class-of 1.234e56) (class <float>)) t)
($test (eq (class-of +1.234e56) (class <float>)) t)
($test (eq (class-of -1.234e56) (class <float>)) t)
($test (eq (class-of 1.234e+56) (class <float>)) t)
($test (eq (class-of +1.234e+56) (class <float>)) t)
($test (eq (class-of -1.234e+56) (class <float>)) t)
($test (eq (class-of 1.234e-56) (class <float>)) t)
($test (eq (class-of +1.234e-56) (class <float>)) t)
($test (eq (class-of -1.234e-56) (class <float>)) t)
($test (eq (class-of *pi*) (class <float>)) t)
($test (eq (class-of *most-positive-float*) (class <float>)) t)
($test (eq (class-of *most-negative-float*) (class <float>)) t)
;;
($eval (defglobal cc nil))
($eval (defmacro catch-condition (&rest form)
	 `(catch 'c
	    (with-handler 
	     (lambda (c) 
	       (setq cc c) 
	       (throw 'c cc))
	     ,@form))))
;; <division-by-zero>
($eval (catch-condition (div 3 0)))
($test (eq (class-of cc) (class <division-by-zero>)) t)
;; <floating-point-overflow>
($eval (catch-condition (* 1e300 1e300)))
($test (eq (class-of cc) (class <floating-point-overflow>)) t)
;; <floating-point-underflow>
($eval (catch-condition (* 1e-300 1e-300)))
($test (eq (class-of cc) (class <floating-point-underflow>)) t)
;; <control-error>
($eval (catch-condition (block b (return-from bb nil))))
($test (eq (class-of cc) (class <control-error>)) t)
;; <parse-error>
($eval (catch-condition (parse-number "foo")))
($test (eq (class-of cc) (class <parse-error>)) t)
;; <program-error>
($eval (catch-condition (cons 'a)))
($test (eq (class-of cc) (class <program-error>)) t)
;; <domain-error>
($eval (catch-condition (car 3)))
($test (eq (class-of cc) (class <domain-error>)) t)
;; <undefined-entity>
($eval (catch-condition (class undef)))
($test (eq (class-of cc) (class <undefined-entity>)) t)
;; <unbound-variable>
($eval (catch-condition undef))
($test (eq (class-of cc) (class <unbound-variable>)) t)
;; <undefined-function>
($eval (catch-condition #'undef))
($test (eq (class-of cc) (class <undefined-function>)) t)
;; <simple-error>
($eval (catch-condition (error "err")))
($test (eq (class-of cc) (class <simple-error>)) t)
;; <end-of-stream>
($eval (catch-condition (let ((str (create-string-input-stream "hi")))
	      (read-char str)
	      (read-char str)
	      (read-char str))))
($test (eq (class-of cc) (class <end-of-stream>)) t)
;; <storage-exhausted>
($eval (catch-condition (create-list 1000000000)))
($test (eq (class-of cc) (class <storage-exhausted>)) t)
;; <standard-class>
($eval (defclass foo () ()))
($test (eq (class-of (class foo)) (class <standard-class>)) t)
;; <stream>
($test (eq (class-of (standard-input)) (class <stream>)) t)
($test (eq (class-of (standard-output)) (class <stream>)) t)
($test (eq (class-of (error-output)) (class <stream>)) t)
;;
;; c111 --+
;; c222 --+-- c555 --+
;; c333 -------------+
;; c444 -------------+-- c666
;;
($eval (defclass c111 () ()))
($eval (defclass c222 () ()))
($eval (defclass c333 () ()))
($eval (defclass c444 () ()))
($eval (defclass c555 (c111 c222) ()))
($eval (defclass c666 (c555 c333 c444) ()))
($eval (defglobal c111 (create (class c111))))
($eval (defglobal c222 (create (class c222))))
($eval (defglobal c333 (create (class c333))))
($eval (defglobal c444 (create (class c444))))
($eval (defglobal c555 (create (class c555))))
($eval (defglobal c666 (create (class c666))))
;;
($test (eq (class-of (class c111)) (class <standard-class>)) t)
($test (eq (class-of (class c222)) (class <standard-class>)) t)
($test (eq (class-of (class c333)) (class <standard-class>)) t)
($test (eq (class-of (class c444)) (class <standard-class>)) t)
($test (eq (class-of (class c555)) (class <standard-class>)) t)
($test (eq (class-of (class c666)) (class <standard-class>)) t)
($test (eq (class-of c111) (class c111)) t)
($test (eq (class-of c222) (class c222)) t)
($test (eq (class-of c333) (class c333)) t)
($test (eq (class-of c444) (class c444)) t)
($test (eq (class-of c555) (class c555)) t)
($test (eq (class-of c666) (class c666)) t)
;; 
($eval (defclass a-3 () ()))
($eval (defglobal a-3 (create (class a-3))))
($test (eq (class-of a-3) (class a-3)) t)
($eval (defclass a-3 () ()))
($test (eq (class-of a-3) (class <invalid>)) t)
;;;($error (class-of a-3) <error>)

;;;------------------------------------------------------------
;;; [function]
;;;
;;;  (instancep obj class) --> boolean
;;;------------------------------------------------------------
($argc instancep 2 0 0)
($type instancep ($class) nil :target)
;;
($eval (defglobal cc nil))
;; <division-by-zero>
($eval (catch-condition (div 3 0)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) t)
($test (instancep cc (class <division-by-zero>)) t)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <floating-point-overflow>
($eval (catch-condition (* 1e300 1e300)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) t)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) t)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <floating-point-underflow>
($eval (catch-condition (* 1e-300 1e-300)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) t)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) t)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <control-error>
($eval (catch-condition (block b (return-from bb nil))))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) t)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <parse-error>
($eval (catch-condition (parse-number "foo")))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) t)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <program-error>
($eval (catch-condition (cons 'a)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) t)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <domain-error>
($eval (catch-condition (car 3)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) t)
($test (instancep cc (class <domain-error>)) t)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <undefined-entity>
($eval (catch-condition (class undef)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) t)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) t)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <unbound-variable>
($eval (catch-condition undef))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) t)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) t)
($test (instancep cc (class <unbound-variable>)) t)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <undefined-function>
($eval (catch-condition #'undef))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) t)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) t)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) t)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <simple-error>
($eval (catch-condition (error "err")))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) t)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <end-of-stream>
($eval (catch-condition (let ((str (create-string-input-stream "hi")))
	      (read-char str)
	      (read-char str)
	      (read-char str))))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) t)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) t)
($test (instancep cc (class <end-of-stream>)) t)
($test (instancep cc (class <storage-exhausted>)) nil)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
($test (instancep cc (class <invalid>)) nil)
;; <storage-exhausted>
($eval (catch-condition (create-list 1000000000)))
($test (instancep cc (class <object>)) t)
($test (instancep cc (class <basic-array>)) nil)
($test (instancep cc (class <basic-array*>)) nil)
($test (instancep cc (class <general-array*>)) nil)
($test (instancep cc (class <basic-vector>)) nil)
($test (instancep cc (class <general-vector>)) nil)
($test (instancep cc (class <string>)) nil)
($test (instancep cc  (class <built-in-class>)) nil)
($test (instancep cc (class <character>)) nil)
($test (instancep cc (class <function>)) nil)
($test (instancep cc (class <generic-function>)) nil)
($test (instancep cc (class <standard-generic-function>)) nil)
($test (instancep cc (class <list>)) nil)
($test (instancep cc (class <cons>)) nil)
($test (instancep cc (class <null>)) nil)
($test (instancep cc (class <symbol>)) nil)
($test (instancep cc (class <number>)) nil)
($test (instancep cc (class <float>)) nil)
($test (instancep cc (class <integer>)) nil)
($test (instancep cc (class <serious-condition>)) t)
($test (instancep cc (class <error>)) nil)
($test (instancep cc (class <arithmetic-error>)) nil)
($test (instancep cc (class <division-by-zero>)) nil)
($test (instancep cc (class <floating-point-overflow>)) nil)
($test (instancep cc (class <floating-point-underflow>)) nil)
($test (instancep cc (class <control-error>)) nil)
($test (instancep cc (class <parse-error>)) nil)
($test (instancep cc (class <program-error>)) nil)
($test (instancep cc (class <domain-error>)) nil)
($test (instancep cc (class <undefined-entity>)) nil)
($test (instancep cc (class <unbound-variable>)) nil)
($test (instancep cc (class <undefined-function>)) nil)
($test (instancep cc (class <simple-error>)) nil)
($test (instancep cc (class <stream-error>)) nil)
($test (instancep cc (class <end-of-stream>)) nil)
($test (instancep cc (class <storage-exhausted>)) t)
($test (instancep cc (class <standard-class>)) nil)
($test (instancep cc (class <standard-object>)) nil)
($test (instancep cc (class <stream>)) nil)
;($test (instancep cc (class <invalid>)) nil)
;; <general-array*>
($test (instancep #2a((a b) (c d)) (class <object>)) t)
($test (instancep #2a((a b) (c d)) (class <basic-array>)) t)
($test (instancep #2a((a b) (c d)) (class <basic-array*>)) t)
($test (instancep #2a((a b) (c d)) (class <general-array*>)) t)
($test (instancep #2a((a b) (c d)) (class <basic-vector>)) nil)
($test (instancep #2a((a b) (c d)) (class <general-vector>)) nil)
($test (instancep #2a((a b) (c d)) (class <string>)) nil)
($test (instancep #2a((a b) (c d)) (class <built-in-class>)) nil)
($test (instancep #2a((a b) (c d)) (class <character>)) nil)
($test (instancep #2a((a b) (c d)) (class <function>)) nil)
($test (instancep #2a((a b) (c d)) (class <generic-function>)) nil)
($test (instancep #2a((a b) (c d)) (class <standard-generic-function>)) nil)
($test (instancep #2a((a b) (c d)) (class <list>)) nil)
($test (instancep #2a((a b) (c d)) (class <cons>)) nil)
($test (instancep #2a((a b) (c d)) (class <null>)) nil)
($test (instancep #2a((a b) (c d)) (class <symbol>)) nil)
($test (instancep #2a((a b) (c d)) (class <number>)) nil)
($test (instancep #2a((a b) (c d)) (class <float>)) nil)
($test (instancep #2a((a b) (c d)) (class <integer>)) nil)
($test (instancep #2a((a b) (c d)) (class <serious-condition>)) nil)
($test (instancep #2a((a b) (c d)) (class <error>)) nil)
($test (instancep #2a((a b) (c d)) (class <arithmetic-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <division-by-zero>)) nil)
($test (instancep #2a((a b) (c d)) (class <floating-point-overflow>)) nil)
($test (instancep #2a((a b) (c d)) (class <floating-point-underflow>)) nil)
($test (instancep #2a((a b) (c d)) (class <control-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <parse-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <program-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <domain-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <undefined-entity>)) nil)
($test (instancep #2a((a b) (c d)) (class <unbound-variable>)) nil)
($test (instancep #2a((a b) (c d)) (class <undefined-function>)) nil)
($test (instancep #2a((a b) (c d)) (class <simple-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <stream-error>)) nil)
($test (instancep #2a((a b) (c d)) (class <end-of-stream>)) nil)
($test (instancep #2a((a b) (c d)) (class <storage-exhausted>)) nil)
($test (instancep #2a((a b) (c d)) (class <standard-class>)) nil)
($test (instancep #2a((a b) (c d)) (class <standard-object>)) nil)
($test (instancep #2a((a b) (c d)) (class <stream>)) nil)
($test (instancep #2a((a b) (c d)) (class <invalid>)) nil)
;; <general-vector>
($test (instancep #(a b) (class <object>)) t)
($test (instancep #(a b) (class <basic-array>)) t)
($test (instancep #(a b) (class <basic-array*>)) nil)
($test (instancep #(a b) (class <general-array*>)) nil)
($test (instancep #(a b) (class <basic-vector>)) t)
($test (instancep #(a b) (class <general-vector>)) t)
($test (instancep #(a b) (class <string>)) nil)
($test (instancep #(a b) (class <built-in-class>)) nil)
($test (instancep #(a b) (class <character>)) nil)
($test (instancep #(a b) (class <function>)) nil)
($test (instancep #(a b) (class <generic-function>)) nil)
($test (instancep #(a b) (class <standard-generic-function>)) nil)
($test (instancep #(a b) (class <list>)) nil)
($test (instancep #(a b) (class <cons>)) nil)
($test (instancep #(a b) (class <null>)) nil)
($test (instancep #(a b) (class <symbol>)) nil)
($test (instancep #(a b) (class <number>)) nil)
($test (instancep #(a b) (class <float>)) nil)
($test (instancep #(a b) (class <integer>)) nil)
($test (instancep #(a b) (class <serious-condition>)) nil)
($test (instancep #(a b) (class <error>)) nil)
($test (instancep #(a b) (class <arithmetic-error>)) nil)
($test (instancep #(a b) (class <division-by-zero>)) nil)
($test (instancep #(a b) (class <floating-point-overflow>)) nil)
($test (instancep #(a b) (class <floating-point-underflow>)) nil)
($test (instancep #(a b) (class <control-error>)) nil)
($test (instancep #(a b) (class <parse-error>)) nil)
($test (instancep #(a b) (class <program-error>)) nil)
($test (instancep #(a b) (class <domain-error>)) nil)
($test (instancep #(a b) (class <undefined-entity>)) nil)
($test (instancep #(a b) (class <unbound-variable>)) nil)
($test (instancep #(a b) (class <undefined-function>)) nil)
($test (instancep #(a b) (class <simple-error>)) nil)
($test (instancep #(a b) (class <stream-error>)) nil)
($test (instancep #(a b) (class <end-of-stream>)) nil)
($test (instancep #(a b) (class <storage-exhausted>)) nil)
($test (instancep #(a b) (class <standard-class>)) nil)
($test (instancep #(a b) (class <standard-object>)) nil)
($test (instancep #(a b) (class <stream>)) nil)
($test (instancep #(a b) (class <invalid>)) nil)
;; <string>
($test (instancep "foo" (class <object>)) t)
($test (instancep "foo" (class <basic-array>)) t)
($test (instancep "foo" (class <basic-array*>)) nil)
($test (instancep "foo" (class <general-array*>)) nil)
($test (instancep "foo" (class <basic-vector>)) t)
($test (instancep "foo" (class <general-vector>)) nil)
($test (instancep "foo" (class <string>)) t)
($test (instancep "foo" (class <built-in-class>)) nil)
($test (instancep "foo" (class <character>)) nil)
($test (instancep "foo" (class <function>)) nil)
($test (instancep "foo" (class <generic-function>)) nil)
($test (instancep "foo" (class <standard-generic-function>)) nil)
($test (instancep "foo" (class <list>)) nil)
($test (instancep "foo" (class <cons>)) nil)
($test (instancep "foo" (class <null>)) nil)
($test (instancep "foo" (class <symbol>)) nil)
($test (instancep "foo" (class <number>)) nil)
($test (instancep "foo" (class <float>)) nil)
($test (instancep "foo" (class <integer>)) nil)
($test (instancep "foo" (class <serious-condition>)) nil)
($test (instancep "foo" (class <error>)) nil)
($test (instancep "foo" (class <arithmetic-error>)) nil)
($test (instancep "foo" (class <division-by-zero>)) nil)
($test (instancep "foo" (class <floating-point-overflow>)) nil)
($test (instancep "foo" (class <floating-point-underflow>)) nil)
($test (instancep "foo" (class <control-error>)) nil)
($test (instancep "foo" (class <parse-error>)) nil)
($test (instancep "foo" (class <program-error>)) nil)
($test (instancep "foo" (class <domain-error>)) nil)
($test (instancep "foo" (class <undefined-entity>)) nil)
($test (instancep "foo" (class <unbound-variable>)) nil)
($test (instancep "foo" (class <undefined-function>)) nil)
($test (instancep "foo" (class <simple-error>)) nil)
($test (instancep "foo" (class <stream-error>)) nil)
($test (instancep "foo" (class <end-of-stream>)) nil)
($test (instancep "foo" (class <storage-exhausted>)) nil)
($test (instancep "foo" (class <standard-class>)) nil)
($test (instancep "foo" (class <standard-object>)) nil)
($test (instancep "foo" (class <stream>)) nil)
($test (instancep "foo" (class <invalid>)) nil)
;; <character>
($test (instancep #\a (class <object>)) t)
($test (instancep #\a (class <basic-array>)) nil)
($test (instancep #\a (class <basic-array*>)) nil)
($test (instancep #\a (class <general-array*>)) nil)
($test (instancep #\a (class <basic-vector>)) nil)
($test (instancep #\a (class <general-vector>)) nil)
($test (instancep #\a (class <string>)) nil)
($test (instancep #\a (class <built-in-class>)) nil)
($test (instancep #\a (class <character>)) t)
($test (instancep #\a (class <function>)) nil)
($test (instancep #\a (class <generic-function>)) nil)
($test (instancep #\a (class <standard-generic-function>)) nil)
($test (instancep #\a (class <list>)) nil)
($test (instancep #\a (class <cons>)) nil)
($test (instancep #\a (class <null>)) nil)
($test (instancep #\a (class <symbol>)) nil)
($test (instancep #\a (class <number>)) nil)
($test (instancep #\a (class <float>)) nil)
($test (instancep #\a (class <integer>)) nil)
($test (instancep #\a (class <serious-condition>)) nil)
($test (instancep #\a (class <error>)) nil)
($test (instancep #\a (class <arithmetic-error>)) nil)
($test (instancep #\a (class <division-by-zero>)) nil)
($test (instancep #\a (class <floating-point-overflow>)) nil)
($test (instancep #\a (class <floating-point-underflow>)) nil)
($test (instancep #\a (class <control-error>)) nil)
($test (instancep #\a (class <parse-error>)) nil)
($test (instancep #\a (class <program-error>)) nil)
($test (instancep #\a (class <domain-error>)) nil)
($test (instancep #\a (class <undefined-entity>)) nil)
($test (instancep #\a (class <unbound-variable>)) nil)
($test (instancep #\a (class <undefined-function>)) nil)
($test (instancep #\a (class <simple-error>)) nil)
($test (instancep #\a (class <stream-error>)) nil)
($test (instancep #\a (class <end-of-stream>)) nil)
($test (instancep #\a (class <storage-exhausted>)) nil)
($test (instancep #\a (class <standard-class>)) nil)
($test (instancep #\a (class <standard-object>)) nil)
($test (instancep #\a (class <stream>)) nil)
($test (instancep #\a (class <invalid>)) nil)
;; <function>
($test (instancep #'+ (class <object>)) t)
($test (instancep #'+ (class <basic-array>)) nil)
($test (instancep #'+ (class <basic-array*>)) nil)
($test (instancep #'+ (class <general-array*>)) nil)
($test (instancep #'+ (class <basic-vector>)) nil)
($test (instancep #'+ (class <general-vector>)) nil)
($test (instancep #'+ (class <string>)) nil)
($test (instancep #'+ (class <built-in-class>)) nil)
($test (instancep #'+ (class <character>)) nil)
($test (instancep #'+ (class <function>)) t)
($test (instancep #'+ (class <generic-function>)) nil)
($test (instancep #'+ (class <standard-generic-function>)) nil)
($test (instancep #'+ (class <list>)) nil)
($test (instancep #'+ (class <cons>)) nil)
($test (instancep #'+ (class <null>)) nil)
($test (instancep #'+ (class <symbol>)) nil)
($test (instancep #'+ (class <number>)) nil)
($test (instancep #'+ (class <float>)) nil)
($test (instancep #'+ (class <integer>)) nil)
($test (instancep #'+ (class <serious-condition>)) nil)
($test (instancep #'+ (class <error>)) nil)
($test (instancep #'+ (class <arithmetic-error>)) nil)
($test (instancep #'+ (class <division-by-zero>)) nil)
($test (instancep #'+ (class <floating-point-overflow>)) nil)
($test (instancep #'+ (class <floating-point-underflow>)) nil)
($test (instancep #'+ (class <control-error>)) nil)
($test (instancep #'+ (class <parse-error>)) nil)
($test (instancep #'+ (class <program-error>)) nil)
($test (instancep #'+ (class <domain-error>)) nil)
($test (instancep #'+ (class <undefined-entity>)) nil)
($test (instancep #'+ (class <unbound-variable>)) nil)
($test (instancep #'+ (class <undefined-function>)) nil)
($test (instancep #'+ (class <simple-error>)) nil)
($test (instancep #'+ (class <stream-error>)) nil)
($test (instancep #'+ (class <end-of-stream>)) nil)
($test (instancep #'+ (class <storage-exhausted>)) nil)
($test (instancep #'+ (class <standard-class>)) nil)
($test (instancep #'+ (class <standard-object>)) nil)
($test (instancep #'+ (class <stream>)) nil)
($test (instancep #'+ (class <invalid>)) nil)
;; <generic-function>
($test (instancep #'create (class <object>)) t)
($test (instancep #'create (class <basic-array>)) nil)
($test (instancep #'create (class <basic-array*>)) nil)
($test (instancep #'create (class <general-array*>)) nil)
($test (instancep #'create (class <basic-vector>)) nil)
($test (instancep #'create (class <general-vector>)) nil)
($test (instancep #'create (class <string>)) nil)
($test (instancep #'create (class <built-in-class>)) nil)
($test (instancep #'create (class <character>)) nil)
($test (instancep #'create (class <function>)) t)
($test (instancep #'create (class <generic-function>)) t)
($test (instancep #'create (class <standard-generic-function>)) nil)
($test (instancep #'create (class <list>)) nil)
($test (instancep #'create (class <cons>)) nil)
($test (instancep #'create (class <null>)) nil)
($test (instancep #'create (class <symbol>)) nil)
($test (instancep #'create (class <number>)) nil)
($test (instancep #'create (class <float>)) nil)
($test (instancep #'create (class <integer>)) nil)
($test (instancep #'create (class <serious-condition>)) nil)
($test (instancep #'create (class <error>)) nil)
($test (instancep #'create (class <arithmetic-error>)) nil)
($test (instancep #'create (class <division-by-zero>)) nil)
($test (instancep #'create (class <floating-point-overflow>)) nil)
($test (instancep #'create (class <floating-point-underflow>)) nil)
($test (instancep #'create (class <control-error>)) nil)
($test (instancep #'create (class <parse-error>)) nil)
($test (instancep #'create (class <program-error>)) nil)
($test (instancep #'create (class <domain-error>)) nil)
($test (instancep #'create (class <undefined-entity>)) nil)
($test (instancep #'create (class <unbound-variable>)) nil)
($test (instancep #'create (class <undefined-function>)) nil)
($test (instancep #'create (class <simple-error>)) nil)
($test (instancep #'create (class <stream-error>)) nil)
($test (instancep #'create (class <end-of-stream>)) nil)
($test (instancep #'create (class <storage-exhausted>)) nil)
($test (instancep #'create (class <standard-class>)) nil)
($test (instancep #'create (class <standard-object>)) nil)
($test (instancep #'create (class <stream>)) nil)
($test (instancep #'create (class <invalid>)) nil)
;; <standard-generic-function>
($eval (defgeneric foo (x)))
($test (instancep #'foo (class <object>)) t)
($test (instancep #'foo (class <basic-array>)) nil)
($test (instancep #'foo (class <basic-array*>)) nil)
($test (instancep #'foo (class <general-array*>)) nil)
($test (instancep #'foo (class <basic-vector>)) nil)
($test (instancep #'foo (class <general-vector>)) nil)
($test (instancep #'foo (class <string>)) nil)
($test (instancep #'foo (class <built-in-class>)) nil)
($test (instancep #'foo (class <character>)) nil)
($test (instancep #'foo (class <function>)) t)
($test (instancep #'foo (class <generic-function>)) t)
($test (instancep #'foo (class <standard-generic-function>)) t)
($test (instancep #'foo (class <list>)) nil)
($test (instancep #'foo (class <cons>)) nil)
($test (instancep #'foo (class <null>)) nil)
($test (instancep #'foo (class <symbol>)) nil)
($test (instancep #'foo (class <number>)) nil)
($test (instancep #'foo (class <float>)) nil)
($test (instancep #'foo (class <integer>)) nil)
($test (instancep #'foo (class <serious-condition>)) nil)
($test (instancep #'foo (class <error>)) nil)
($test (instancep #'foo (class <arithmetic-error>)) nil)
($test (instancep #'foo (class <division-by-zero>)) nil)
($test (instancep #'foo (class <floating-point-overflow>)) nil)
($test (instancep #'foo (class <floating-point-underflow>)) nil)
($test (instancep #'foo (class <control-error>)) nil)
($test (instancep #'foo (class <parse-error>)) nil)
($test (instancep #'foo (class <program-error>)) nil)
($test (instancep #'foo (class <domain-error>)) nil)
($test (instancep #'foo (class <undefined-entity>)) nil)
($test (instancep #'foo (class <unbound-variable>)) nil)
($test (instancep #'foo (class <undefined-function>)) nil)
($test (instancep #'foo (class <simple-error>)) nil)
($test (instancep #'foo (class <stream-error>)) nil)
($test (instancep #'foo (class <end-of-stream>)) nil)
($test (instancep #'foo (class <storage-exhausted>)) nil)
($test (instancep #'foo (class <standard-class>)) nil)
($test (instancep #'foo (class <standard-object>)) nil)
($test (instancep #'foo (class <stream>)) nil)
($test (instancep #'foo (class <invalid>)) nil)
;; <cons>
($test (instancep '(1 . 2) (class <object>)) t)
($test (instancep '(1 . 2) (class <basic-array>)) nil)
($test (instancep '(1 . 2) (class <basic-array*>)) nil)
($test (instancep '(1 . 2) (class <general-array*>)) nil)
($test (instancep '(1 . 2) (class <basic-vector>)) nil)
($test (instancep '(1 . 2) (class <general-vector>)) nil)
($test (instancep '(1 . 2) (class <string>)) nil)
($test (instancep '(1 . 2) (class <built-in-class>)) nil)
($test (instancep '(1 . 2) (class <character>)) nil)
($test (instancep '(1 . 2) (class <function>)) nil)
($test (instancep '(1 . 2) (class <generic-function>)) nil)
($test (instancep '(1 . 2) (class <standard-generic-function>)) nil)
($test (instancep '(1 . 2) (class <list>)) t)
($test (instancep '(1 . 2) (class <cons>)) t)
($test (instancep '(1 . 2) (class <null>)) nil)
($test (instancep '(1 . 2) (class <symbol>)) nil)
($test (instancep '(1 . 2) (class <number>)) nil)
($test (instancep '(1 . 2) (class <float>)) nil)
($test (instancep '(1 . 2) (class <integer>)) nil)
($test (instancep '(1 . 2) (class <serious-condition>)) nil)
($test (instancep '(1 . 2) (class <error>)) nil)
($test (instancep '(1 . 2) (class <arithmetic-error>)) nil)
($test (instancep '(1 . 2) (class <division-by-zero>)) nil)
($test (instancep '(1 . 2) (class <floating-point-overflow>)) nil)
($test (instancep '(1 . 2) (class <floating-point-underflow>)) nil)
($test (instancep '(1 . 2) (class <control-error>)) nil)
($test (instancep '(1 . 2) (class <parse-error>)) nil)
($test (instancep '(1 . 2) (class <program-error>)) nil)
($test (instancep '(1 . 2) (class <domain-error>)) nil)
($test (instancep '(1 . 2) (class <undefined-entity>)) nil)
($test (instancep '(1 . 2) (class <unbound-variable>)) nil)
($test (instancep '(1 . 2) (class <undefined-function>)) nil)
($test (instancep '(1 . 2) (class <simple-error>)) nil)
($test (instancep '(1 . 2) (class <stream-error>)) nil)
($test (instancep '(1 . 2) (class <end-of-stream>)) nil)
($test (instancep '(1 . 2) (class <storage-exhausted>)) nil)
($test (instancep '(1 . 2) (class <standard-class>)) nil)
($test (instancep '(1 . 2) (class <standard-object>)) nil)
($test (instancep '(1 . 2) (class <stream>)) nil)
($test (instancep '(1 . 2) (class <invalid>)) nil)
;; <null>
($test (instancep nil (class <object>)) t)
($test (instancep nil (class <basic-array>)) nil)
($test (instancep nil (class <basic-array*>)) nil)
($test (instancep nil (class <general-array*>)) nil)
($test (instancep nil (class <basic-vector>)) nil)
($test (instancep nil (class <general-vector>)) nil)
($test (instancep nil (class <string>)) nil)
($test (instancep nil (class <built-in-class>)) nil)
($test (instancep nil (class <character>)) nil)
($test (instancep nil (class <function>)) nil)
($test (instancep nil (class <generic-function>)) nil)
($test (instancep nil (class <standard-generic-function>)) nil)
($test (instancep nil (class <list>)) t)
($test (instancep nil (class <cons>)) nil)
($test (instancep nil (class <null>)) t)
($test (instancep nil (class <symbol>)) t)
($test (instancep nil (class <number>)) nil)
($test (instancep nil (class <float>)) nil)
($test (instancep nil (class <integer>)) nil)
($test (instancep nil (class <serious-condition>)) nil)
($test (instancep nil (class <error>)) nil)
($test (instancep nil (class <arithmetic-error>)) nil)
($test (instancep nil (class <division-by-zero>)) nil)
($test (instancep nil (class <floating-point-overflow>)) nil)
($test (instancep nil (class <floating-point-underflow>)) nil)
($test (instancep nil (class <control-error>)) nil)
($test (instancep nil (class <parse-error>)) nil)
($test (instancep nil (class <program-error>)) nil)
($test (instancep nil (class <domain-error>)) nil)
($test (instancep nil (class <undefined-entity>)) nil)
($test (instancep nil (class <unbound-variable>)) nil)
($test (instancep nil (class <undefined-function>)) nil)
($test (instancep nil (class <simple-error>)) nil)
($test (instancep nil (class <stream-error>)) nil)
($test (instancep nil (class <end-of-stream>)) nil)
($test (instancep nil (class <storage-exhausted>)) nil)
($test (instancep nil (class <standard-class>)) nil)
($test (instancep nil (class <standard-object>)) nil)
($test (instancep nil (class <stream>)) nil)
($test (instancep nil (class <invalid>)) nil)
;; <symbol>
($test (instancep 'a (class <object>)) t)
($test (instancep 'a (class <basic-array>)) nil)
($test (instancep 'a (class <basic-array*>)) nil)
($test (instancep 'a (class <general-array*>)) nil)
($test (instancep 'a (class <basic-vector>)) nil)
($test (instancep 'a (class <general-vector>)) nil)
($test (instancep 'a (class <string>)) nil)
($test (instancep 'a (class <built-in-class>)) nil)
($test (instancep 'a (class <character>)) nil)
($test (instancep 'a (class <function>)) nil)
($test (instancep 'a (class <generic-function>)) nil)
($test (instancep 'a (class <standard-generic-function>)) nil)
($test (instancep 'a (class <list>)) nil)
($test (instancep 'a (class <cons>)) nil)
($test (instancep 'a (class <null>)) nil)
($test (instancep 'a (class <symbol>)) t)
($test (instancep 'a (class <number>)) nil)
($test (instancep 'a (class <float>)) nil)
($test (instancep 'a (class <integer>)) nil)
($test (instancep 'a (class <serious-condition>)) nil)
($test (instancep 'a (class <error>)) nil)
($test (instancep 'a (class <arithmetic-error>)) nil)
($test (instancep 'a (class <division-by-zero>)) nil)
($test (instancep 'a (class <floating-point-overflow>)) nil)
($test (instancep 'a (class <floating-point-underflow>)) nil)
($test (instancep 'a (class <control-error>)) nil)
($test (instancep 'a (class <parse-error>)) nil)
($test (instancep 'a (class <program-error>)) nil)
($test (instancep 'a (class <domain-error>)) nil)
($test (instancep 'a (class <undefined-entity>)) nil)
($test (instancep 'a (class <unbound-variable>)) nil)
($test (instancep 'a (class <undefined-function>)) nil)
($test (instancep 'a (class <simple-error>)) nil)
($test (instancep 'a (class <stream-error>)) nil)
($test (instancep 'a (class <end-of-stream>)) nil)
($test (instancep 'a (class <storage-exhausted>)) nil)
($test (instancep 'a (class <standard-class>)) nil)
($test (instancep 'a (class <standard-object>)) nil)
($test (instancep 'a (class <stream>)) nil)
($test (instancep 'a (class <invalid>)) nil)
;; <integer> (fixnum)
($test (instancep 123 (class <object>)) t)
($test (instancep 123 (class <basic-array>)) nil)
($test (instancep 123 (class <basic-array*>)) nil)
($test (instancep 123 (class <general-array*>)) nil)
($test (instancep 123 (class <basic-vector>)) nil)
($test (instancep 123 (class <general-vector>)) nil)
($test (instancep 123 (class <string>)) nil)
($test (instancep 123 (class <built-in-class>)) nil)
($test (instancep 123 (class <character>)) nil)
($test (instancep 123 (class <function>)) nil)
($test (instancep 123 (class <generic-function>)) nil)
($test (instancep 123 (class <standard-generic-function>)) nil)
($test (instancep 123 (class <list>)) nil)
($test (instancep 123 (class <cons>)) nil)
($test (instancep 123 (class <null>)) nil)
($test (instancep 123 (class <symbol>)) nil)
($test (instancep 123 (class <number>)) t)
($test (instancep 123 (class <float>)) nil)
($test (instancep 123 (class <integer>)) t)
($test (instancep 123 (class <serious-condition>)) nil)
($test (instancep 123 (class <error>)) nil)
($test (instancep 123 (class <arithmetic-error>)) nil)
($test (instancep 123 (class <division-by-zero>)) nil)
($test (instancep 123 (class <floating-point-overflow>)) nil)
($test (instancep 123 (class <floating-point-underflow>)) nil)
($test (instancep 123 (class <control-error>)) nil)
($test (instancep 123 (class <parse-error>)) nil)
($test (instancep 123 (class <program-error>)) nil)
($test (instancep 123 (class <domain-error>)) nil)
($test (instancep 123 (class <undefined-entity>)) nil)
($test (instancep 123 (class <unbound-variable>)) nil)
($test (instancep 123 (class <undefined-function>)) nil)
($test (instancep 123 (class <simple-error>)) nil)
($test (instancep 123 (class <stream-error>)) nil)
($test (instancep 123 (class <end-of-stream>)) nil)
($test (instancep 123 (class <storage-exhausted>)) nil)
($test (instancep 123 (class <standard-class>)) nil)
($test (instancep 123 (class <standard-object>)) nil)
($test (instancep 123 (class <stream>)) nil)
($test (instancep 123 (class <invalid>)) nil)
;; <integer> (bignum)
($test (instancep 1234567890 (class <object>)) t)
($test (instancep 1234567890 (class <basic-array>)) nil)
($test (instancep 1234567890 (class <basic-array*>)) nil)
($test (instancep 1234567890 (class <general-array*>)) nil)
($test (instancep 1234567890 (class <basic-vector>)) nil)
($test (instancep 1234567890 (class <general-vector>)) nil)
($test (instancep 1234567890 (class <string>)) nil)
($test (instancep 1234567890 (class <built-in-class>)) nil)
($test (instancep 1234567890 (class <character>)) nil)
($test (instancep 1234567890 (class <function>)) nil)
($test (instancep 1234567890 (class <generic-function>)) nil)
($test (instancep 1234567890 (class <standard-generic-function>)) nil)
($test (instancep 1234567890 (class <list>)) nil)
($test (instancep 1234567890 (class <cons>)) nil)
($test (instancep 1234567890 (class <null>)) nil)
($test (instancep 1234567890 (class <symbol>)) nil)
($test (instancep 1234567890 (class <number>)) t)
($test (instancep 1234567890 (class <float>)) nil)
($test (instancep 1234567890 (class <integer>)) t)
($test (instancep 1234567890 (class <serious-condition>)) nil)
($test (instancep 1234567890 (class <error>)) nil)
($test (instancep 1234567890 (class <arithmetic-error>)) nil)
($test (instancep 1234567890 (class <division-by-zero>)) nil)
($test (instancep 1234567890 (class <floating-point-overflow>)) nil)
($test (instancep 1234567890 (class <floating-point-underflow>)) nil)
($test (instancep 1234567890 (class <control-error>)) nil)
($test (instancep 1234567890 (class <parse-error>)) nil)
($test (instancep 1234567890 (class <program-error>)) nil)
($test (instancep 1234567890 (class <domain-error>)) nil)
($test (instancep 1234567890 (class <undefined-entity>)) nil)
($test (instancep 1234567890 (class <unbound-variable>)) nil)
($test (instancep 1234567890 (class <undefined-function>)) nil)
($test (instancep 1234567890 (class <simple-error>)) nil)
($test (instancep 1234567890 (class <stream-error>)) nil)
($test (instancep 1234567890 (class <end-of-stream>)) nil)
($test (instancep 1234567890 (class <storage-exhausted>)) nil)
($test (instancep 1234567890 (class <standard-class>)) nil)
($test (instancep 1234567890 (class <standard-object>)) nil)
($test (instancep 1234567890 (class <stream>)) nil)
($test (instancep 1234567890 (class <invalid>)) nil)
;; <float>
($test (instancep 1.23 (class <object>)) t)
($test (instancep 1.23 (class <basic-array>)) nil)
($test (instancep 1.23 (class <basic-array*>)) nil)
($test (instancep 1.23 (class <general-array*>)) nil)
($test (instancep 1.23 (class <basic-vector>)) nil)
($test (instancep 1.23 (class <general-vector>)) nil)
($test (instancep 1.23 (class <string>)) nil)
($test (instancep 1.23 (class <built-in-class>)) nil)
($test (instancep 1.23 (class <character>)) nil)
($test (instancep 1.23 (class <function>)) nil)
($test (instancep 1.23 (class <generic-function>)) nil)
($test (instancep 1.23 (class <standard-generic-function>)) nil)
($test (instancep 1.23 (class <list>)) nil)
($test (instancep 1.23 (class <cons>)) nil)
($test (instancep 1.23 (class <null>)) nil)
($test (instancep 1.23 (class <symbol>)) nil)
($test (instancep 1.23 (class <number>)) t)
($test (instancep 1.23 (class <float>)) t)
($test (instancep 1.23 (class <integer>)) nil)
($test (instancep 1.23 (class <serious-condition>)) nil)
($test (instancep 1.23 (class <error>)) nil)
($test (instancep 1.23 (class <arithmetic-error>)) nil)
($test (instancep 1.23 (class <division-by-zero>)) nil)
($test (instancep 1.23 (class <floating-point-overflow>)) nil)
($test (instancep 1.23 (class <floating-point-underflow>)) nil)
($test (instancep 1.23 (class <control-error>)) nil)
($test (instancep 1.23 (class <parse-error>)) nil)
($test (instancep 1.23 (class <program-error>)) nil)
($test (instancep 1.23 (class <domain-error>)) nil)
($test (instancep 1.23 (class <undefined-entity>)) nil)
($test (instancep 1.23 (class <unbound-variable>)) nil)
($test (instancep 1.23 (class <undefined-function>)) nil)
($test (instancep 1.23 (class <simple-error>)) nil)
($test (instancep 1.23 (class <stream-error>)) nil)
($test (instancep 1.23 (class <end-of-stream>)) nil)
($test (instancep 1.23 (class <storage-exhausted>)) nil)
($test (instancep 1.23 (class <standard-class>)) nil)
($test (instancep 1.23 (class <standard-object>)) nil)
($test (instancep 1.23 (class <stream>)) nil)
($test (instancep 1.23 (class <invalid>)) nil)
;; <stream>
($test (instancep (standard-output) (class <object>)) t)
($test (instancep (standard-output) (class <basic-array>)) nil)
($test (instancep (standard-output) (class <basic-array*>)) nil)
($test (instancep (standard-output) (class <general-array*>)) nil)
($test (instancep (standard-output) (class <basic-vector>)) nil)
($test (instancep (standard-output) (class <general-vector>)) nil)
($test (instancep (standard-output) (class <string>)) nil)
($test (instancep (standard-output) (class <built-in-class>)) nil)
($test (instancep (standard-output) (class <character>)) nil)
($test (instancep (standard-output) (class <function>)) nil)
($test (instancep (standard-output) (class <generic-function>)) nil)
($test (instancep (standard-output) (class <standard-generic-function>)) nil)
($test (instancep (standard-output) (class <list>)) nil)
($test (instancep (standard-output) (class <cons>)) nil)
($test (instancep (standard-output) (class <null>)) nil)
($test (instancep (standard-output) (class <symbol>)) nil)
($test (instancep (standard-output) (class <number>)) nil)
($test (instancep (standard-output) (class <float>)) nil)
($test (instancep (standard-output) (class <integer>)) nil)
($test (instancep (standard-output) (class <serious-condition>)) nil)
($test (instancep (standard-output) (class <error>)) nil)
($test (instancep (standard-output) (class <arithmetic-error>)) nil)
($test (instancep (standard-output) (class <division-by-zero>)) nil)
($test (instancep (standard-output) (class <floating-point-overflow>)) nil)
($test (instancep (standard-output) (class <floating-point-underflow>)) nil)
($test (instancep (standard-output) (class <control-error>)) nil)
($test (instancep (standard-output) (class <parse-error>)) nil)
($test (instancep (standard-output) (class <program-error>)) nil)
($test (instancep (standard-output) (class <domain-error>)) nil)
($test (instancep (standard-output) (class <undefined-entity>)) nil)
($test (instancep (standard-output) (class <unbound-variable>)) nil)
($test (instancep (standard-output) (class <undefined-function>)) nil)
($test (instancep (standard-output) (class <simple-error>)) nil)
($test (instancep (standard-output) (class <stream-error>)) nil)
($test (instancep (standard-output) (class <end-of-stream>)) nil)
($test (instancep (standard-output) (class <storage-exhausted>)) nil)
($test (instancep (standard-output) (class <standard-class>)) nil)
($test (instancep (standard-output) (class <standard-object>)) nil)
($test (instancep (standard-output) (class <stream>)) t)
($test (instancep (standard-output) (class <invalid>)) nil)
;; <built-in-class>
($test (instancep (class <object>) (class <built-in-class>)) t)
($test (instancep (class <basic-array>) (class <built-in-class>)) t)
($test (instancep (class <basic-array*>) (class <built-in-class>)) t)
($test (instancep (class <general-array*>) (class <built-in-class>)) t)
($test (instancep (class <basic-vector>) (class <built-in-class>)) t)
($test (instancep (class <general-vector>) (class <built-in-class>)) t)
($test (instancep (class <string>) (class <built-in-class>)) t)
($test (instancep (class <built-in-class>) (class <built-in-class>)) t)
($test (instancep (class <character>) (class <built-in-class>)) t)
($test (instancep (class <function>) (class <built-in-class>)) t)
($test (instancep (class <generic-function>) (class <built-in-class>)) t)
($test (instancep (class <standard-generic-function>) (class <built-in-class>)) t)
($test (instancep (class <list>) (class <built-in-class>)) t)
($test (instancep (class <cons>) (class <built-in-class>)) t)
($test (instancep (class <null>) (class <built-in-class>)) t)
($test (instancep (class <symbol>) (class <built-in-class>)) t)
($test (instancep (class <number>) (class <built-in-class>)) t)
($test (instancep (class <float>) (class <built-in-class>)) t)
($test (instancep (class <integer>) (class <built-in-class>)) t)
($test (instancep (class <serious-condition>) (class <built-in-class>)) t)
($test (instancep (class <error>) (class <built-in-class>)) t)
($test (instancep (class <arithmetic-error>) (class <built-in-class>)) t)
($test (instancep (class <division-by-zero>) (class <built-in-class>)) t)
($test (instancep (class <floating-point-overflow>) (class <built-in-class>)) t)
($test (instancep (class <floating-point-underflow>) (class <built-in-class>)) t)
($test (instancep (class <control-error>) (class <built-in-class>)) t)
($test (instancep (class <parse-error>) (class <built-in-class>)) t)
($test (instancep (class <program-error>) (class <built-in-class>)) t)
($test (instancep (class <domain-error>) (class <built-in-class>)) t)
($test (instancep (class <undefined-entity>) (class <built-in-class>)) t)
($test (instancep (class <unbound-variable>) (class <built-in-class>)) t)
($test (instancep (class <undefined-function>) (class <built-in-class>)) t)
($test (instancep (class <simple-error>) (class <built-in-class>)) t)
($test (instancep (class <stream-error>) (class <built-in-class>)) t)
($test (instancep (class <end-of-stream>) (class <built-in-class>)) t)
($test (instancep (class <storage-exhausted>) (class <built-in-class>)) t)
($test (instancep (class <standard-class>) (class <built-in-class>)) t)
($test (instancep (class <standard-object>) (class <built-in-class>)) t)
($test (instancep (class <stream>) (class <built-in-class>)) t)
($test (instancep (class <invalid>) (class <built-in-class>)) t)
;;
;; c1111 --+
;; c2222 --+-- c5555 --+
;; c3333 --------------+
;; c4444 --------------+-- c6666
;;
($eval (defclass c1111 () ()))
($eval (defclass c2222 () ()))
($eval (defclass c3333 () ()))
($eval (defclass c4444 () ()))
($eval (defclass c5555 (c1111 c2222) ()))
($eval (defclass c6666 (c5555 c3333 c4444) ()))
($eval (defglobal c1111 (create (class c1111))))
($eval (defglobal c2222 (create (class c2222))))
($eval (defglobal c3333 (create (class c3333))))
($eval (defglobal c4444 (create (class c4444))))
($eval (defglobal c5555 (create (class c5555))))
($eval (defglobal c6666 (create (class c6666))))
;;
;; <standard-class>
($test (instancep (class c1111) (class <object>)) t)
($test (instancep (class c1111) (class <basic-array>)) nil)
($test (instancep (class c1111) (class <basic-array*>)) nil)
($test (instancep (class c1111) (class <general-array*>)) nil)
($test (instancep (class c1111) (class <basic-vector>)) nil)
($test (instancep (class c1111) (class <general-vector>)) nil)
($test (instancep (class c1111) (class <string>)) nil)
($test (instancep (class c1111) (class <built-in-class>)) nil)
($test (instancep (class c1111) (class <character>)) nil)
($test (instancep (class c1111) (class <function>)) nil)
($test (instancep (class c1111) (class <generic-function>)) nil)
($test (instancep (class c1111) (class <standard-generic-function>)) nil)
($test (instancep (class c1111) (class <list>)) nil)
($test (instancep (class c1111) (class <cons>)) nil)
($test (instancep (class c1111) (class <null>)) nil)
($test (instancep (class c1111) (class <symbol>)) nil)
($test (instancep (class c1111) (class <number>)) nil)
($test (instancep (class c1111) (class <float>)) nil)
($test (instancep (class c1111) (class <integer>)) nil)
($test (instancep (class c1111) (class <serious-condition>)) nil)
($test (instancep (class c1111) (class <error>)) nil)
($test (instancep (class c1111) (class <arithmetic-error>)) nil)
($test (instancep (class c1111) (class <division-by-zero>)) nil)
($test (instancep (class c1111) (class <floating-point-overflow>)) nil)
($test (instancep (class c1111) (class <floating-point-underflow>)) nil)
($test (instancep (class c1111) (class <control-error>)) nil)
($test (instancep (class c1111) (class <parse-error>)) nil)
($test (instancep (class c1111) (class <program-error>)) nil)
($test (instancep (class c1111) (class <domain-error>)) nil)
($test (instancep (class c1111) (class <undefined-entity>)) nil)
($test (instancep (class c1111) (class <unbound-variable>)) nil)
($test (instancep (class c1111) (class <undefined-function>)) nil)
($test (instancep (class c1111) (class <simple-error>)) nil)
($test (instancep (class c1111) (class <stream-error>)) nil)
($test (instancep (class c1111) (class <end-of-stream>)) nil)
($test (instancep (class c1111) (class <storage-exhausted>)) nil)
($test (instancep (class c1111) (class <standard-class>)) t)
($test (instancep (class c1111) (class <standard-object>)) nil)
($test (instancep (class c1111) (class <stream>)) nil)
($test (instancep (class c1111) (class <invalid>)) nil)
;;
($test (instancep c1111 (class <object>)) t)
($test (instancep c1111 (class <standard-object>)) t)
($test (instancep c1111 (class c1111)) t)
($test (instancep c1111 (class c2222)) nil)
($test (instancep c1111 (class c3333)) nil)
($test (instancep c1111 (class c4444)) nil)
($test (instancep c1111 (class c5555)) nil)
($test (instancep c1111 (class c6666)) nil)
;;
($test (instancep c2222 (class <object>)) t)
($test (instancep c2222 (class <standard-object>)) t)
($test (instancep c2222 (class c1111)) nil)
($test (instancep c2222 (class c2222)) t)
($test (instancep c2222 (class c3333)) nil)
($test (instancep c2222 (class c4444)) nil)
($test (instancep c2222 (class c5555)) nil)
($test (instancep c2222 (class c6666)) nil)
;;
($test (instancep c3333 (class <object>)) t)
($test (instancep c3333 (class <standard-object>)) t)
($test (instancep c3333 (class c1111)) nil)
($test (instancep c3333 (class c2222)) nil)
($test (instancep c3333 (class c3333)) t)
($test (instancep c3333 (class c4444)) nil)
($test (instancep c3333 (class c5555)) nil)
($test (instancep c3333 (class c6666)) nil)
;;
($test (instancep c4444 (class <object>)) t)
($test (instancep c4444 (class <standard-object>)) t)
($test (instancep c4444 (class c1111)) nil)
($test (instancep c4444 (class c2222)) nil)
($test (instancep c4444 (class c3333)) nil)
($test (instancep c4444 (class c4444)) t)
($test (instancep c4444 (class c5555)) nil)
($test (instancep c4444 (class c6666)) nil)
;;
($test (instancep c5555 (class <object>)) t)
($test (instancep c5555 (class <standard-object>)) t)
($test (instancep c5555 (class c1111)) t)
($test (instancep c5555 (class c2222)) t)
($test (instancep c5555 (class c3333)) nil)
($test (instancep c5555 (class c4444)) nil)
($test (instancep c5555 (class c5555)) t)
($test (instancep c5555 (class c6666)) nil)
;;
($test (instancep c6666 (class <object>)) t)
($test (instancep c6666 (class <standard-object>)) t)
($test (instancep c6666 (class c1111)) t)
($test (instancep c6666 (class c2222)) t)
($test (instancep c6666 (class c3333)) t)
($test (instancep c6666 (class c4444)) t)
($test (instancep c6666 (class c5555)) t)
($test (instancep c6666 (class c6666)) t)
;; �Ē�`
($eval (defclass a () ()))
($eval (defglobal a (create (class a))))
($test (instancep a (class a)) t)
;($test (instancep a (class <invalid>)) nil)
($eval (defclass a () ())) ;;; �����ōĒ�`
($test (instancep a (class a)) nil)
;($test (instancep a (class <invalid>)) t)
;;;($error (instancep a (class a)) <error>)
;;;($error (instancep a (class <invalid>)) <error>)

;;;------------------------------------------------------------
;;; [function]
;;;
;;;  (subclassp class1 class2) --> boolean
;;;------------------------------------------------------------
($argc subclassp 2 0 0)
($type subclassp ($class) :target (class <object>))
($type subclassp ($class) (class <object>) :target)
;; <object>
($test (subclassp (class <object>) (class <object>)) nil)
($test (subclassp (class <object>) (class <basic-array>)) nil)
($test (subclassp (class <object>) (class <basic-array*>)) nil)
($test (subclassp (class <object>) (class <general-array*>)) nil)
($test (subclassp (class <object>) (class <basic-vector>)) nil)
($test (subclassp (class <object>) (class <general-vector>)) nil)
($test (subclassp (class <object>) (class <string>)) nil)
($test (subclassp (class <object>) (class <built-in-class>)) nil)
($test (subclassp (class <object>) (class <character>)) nil)
($test (subclassp (class <object>) (class <function>)) nil)
($test (subclassp (class <object>) (class <generic-function>)) nil)
($test (subclassp (class <object>) (class <standard-generic-function>)) nil)
($test (subclassp (class <object>) (class <list>)) nil)
($test (subclassp (class <object>) (class <cons>)) nil)
($test (subclassp (class <object>) (class <null>)) nil)
($test (subclassp (class <object>) (class <symbol>)) nil)
($test (subclassp (class <object>) (class <number>)) nil)
($test (subclassp (class <object>) (class <float>)) nil)
($test (subclassp (class <object>) (class <integer>)) nil)
($test (subclassp (class <object>) (class <serious-condition>)) nil)
($test (subclassp (class <object>) (class <error>)) nil)
($test (subclassp (class <object>) (class <arithmetic-error>)) nil)
($test (subclassp (class <object>) (class <division-by-zero>)) nil)
($test (subclassp (class <object>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <object>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <object>) (class <control-error>)) nil)
($test (subclassp (class <object>) (class <parse-error>)) nil)
($test (subclassp (class <object>) (class <program-error>)) nil)
($test (subclassp (class <object>) (class <domain-error>)) nil)
($test (subclassp (class <object>) (class <undefined-entity>)) nil)
($test (subclassp (class <object>) (class <unbound-variable>)) nil)
($test (subclassp (class <object>) (class <undefined-function>)) nil)
($test (subclassp (class <object>) (class <simple-error>)) nil)
($test (subclassp (class <object>) (class <stream-error>)) nil)
($test (subclassp (class <object>) (class <end-of-stream>)) nil)
($test (subclassp (class <object>) (class <storage-exhausted>)) nil)
($test (subclassp (class <object>) (class <standard-class>)) nil)
($test (subclassp (class <object>) (class <standard-object>)) nil)
($test (subclassp (class <object>) (class <stream>)) nil)
;; <basic-array>
($test (subclassp (class <basic-array>) (class <object>)) t)
($test (subclassp (class <basic-array>) (class <basic-array>)) nil)
($test (subclassp (class <basic-array>) (class <basic-array*>)) nil)
($test (subclassp (class <basic-array>) (class <general-array*>)) nil)
($test (subclassp (class <basic-array>) (class <basic-vector>)) nil)
($test (subclassp (class <basic-array>) (class <general-vector>)) nil)
($test (subclassp (class <basic-array>) (class <string>)) nil)
($test (subclassp (class <basic-array>) (class <built-in-class>)) nil)
($test (subclassp (class <basic-array>) (class <character>)) nil)
($test (subclassp (class <basic-array>) (class <function>)) nil)
($test (subclassp (class <basic-array>) (class <generic-function>)) nil)
($test (subclassp (class <basic-array>) (class <standard-generic-function>)) nil)
($test (subclassp (class <basic-array>) (class <list>)) nil)
($test (subclassp (class <basic-array>) (class <cons>)) nil)
($test (subclassp (class <basic-array>) (class <null>)) nil)
($test (subclassp (class <basic-array>) (class <symbol>)) nil)
($test (subclassp (class <basic-array>) (class <number>)) nil)
($test (subclassp (class <basic-array>) (class <float>)) nil)
($test (subclassp (class <basic-array>) (class <integer>)) nil)
($test (subclassp (class <basic-array>) (class <serious-condition>)) nil)
($test (subclassp (class <basic-array>) (class <error>)) nil)
($test (subclassp (class <basic-array>) (class <arithmetic-error>)) nil)
($test (subclassp (class <basic-array>) (class <division-by-zero>)) nil)
($test (subclassp (class <basic-array>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <basic-array>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <basic-array>) (class <control-error>)) nil)
($test (subclassp (class <basic-array>) (class <parse-error>)) nil)
($test (subclassp (class <basic-array>) (class <program-error>)) nil)
($test (subclassp (class <basic-array>) (class <domain-error>)) nil)
($test (subclassp (class <basic-array>) (class <undefined-entity>)) nil)
($test (subclassp (class <basic-array>) (class <unbound-variable>)) nil)
($test (subclassp (class <basic-array>) (class <undefined-function>)) nil)
($test (subclassp (class <basic-array>) (class <simple-error>)) nil)
($test (subclassp (class <basic-array>) (class <stream-error>)) nil)
($test (subclassp (class <basic-array>) (class <end-of-stream>)) nil)
($test (subclassp (class <basic-array>) (class <storage-exhausted>)) nil)
($test (subclassp (class <basic-array>) (class <standard-class>)) nil)
($test (subclassp (class <basic-array>) (class <standard-object>)) nil)
($test (subclassp (class <basic-array>) (class <stream>)) nil)
;; <basic-array*>
($test (subclassp (class <basic-array*>) (class <object>)) t)
($test (subclassp (class <basic-array*>) (class <basic-array>)) t)
($test (subclassp (class <basic-array*>) (class <basic-array*>)) nil)
($test (subclassp (class <basic-array*>) (class <general-array*>)) nil)
($test (subclassp (class <basic-array*>) (class <basic-vector>)) nil)
($test (subclassp (class <basic-array*>) (class <general-vector>)) nil)
($test (subclassp (class <basic-array*>) (class <string>)) nil)
($test (subclassp (class <basic-array*>) (class <built-in-class>)) nil)
($test (subclassp (class <basic-array*>) (class <character>)) nil)
($test (subclassp (class <basic-array*>) (class <function>)) nil)
($test (subclassp (class <basic-array*>) (class <generic-function>)) nil)
($test (subclassp (class <basic-array*>) (class <standard-generic-function>)) nil)
($test (subclassp (class <basic-array*>) (class <list>)) nil)
($test (subclassp (class <basic-array*>) (class <cons>)) nil)
($test (subclassp (class <basic-array*>) (class <null>)) nil)
($test (subclassp (class <basic-array*>) (class <symbol>)) nil)
($test (subclassp (class <basic-array*>) (class <number>)) nil)
($test (subclassp (class <basic-array*>) (class <float>)) nil)
($test (subclassp (class <basic-array*>) (class <integer>)) nil)
($test (subclassp (class <basic-array*>) (class <serious-condition>)) nil)
($test (subclassp (class <basic-array*>) (class <error>)) nil)
($test (subclassp (class <basic-array*>) (class <arithmetic-error>)) nil)
($test (subclassp (class <basic-array*>) (class <division-by-zero>)) nil)
($test (subclassp (class <basic-array*>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <basic-array*>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <basic-array*>) (class <control-error>)) nil)
($test (subclassp (class <basic-array*>) (class <parse-error>)) nil)
($test (subclassp (class <basic-array*>) (class <program-error>)) nil)
($test (subclassp (class <basic-array*>) (class <domain-error>)) nil)
($test (subclassp (class <basic-array*>) (class <undefined-entity>)) nil)
($test (subclassp (class <basic-array*>) (class <unbound-variable>)) nil)
($test (subclassp (class <basic-array*>) (class <undefined-function>)) nil)
($test (subclassp (class <basic-array*>) (class <simple-error>)) nil)
($test (subclassp (class <basic-array*>) (class <stream-error>)) nil)
($test (subclassp (class <basic-array*>) (class <end-of-stream>)) nil)
($test (subclassp (class <basic-array*>) (class <storage-exhausted>)) nil)
($test (subclassp (class <basic-array*>) (class <standard-class>)) nil)
($test (subclassp (class <basic-array*>) (class <standard-object>)) nil)
($test (subclassp (class <basic-array*>) (class <stream>)) nil)
;; <general-array*>
($test (subclassp (class <general-array*>) (class <object>)) t)
($test (subclassp (class <general-array*>) (class <basic-array>)) t)
($test (subclassp (class <general-array*>) (class <basic-array*>)) t)
($test (subclassp (class <general-array*>) (class <general-array*>)) nil)
($test (subclassp (class <general-array*>) (class <basic-vector>)) nil)
($test (subclassp (class <general-array*>) (class <general-vector>)) nil)
($test (subclassp (class <general-array*>) (class <string>)) nil)
($test (subclassp (class <general-array*>) (class <built-in-class>)) nil)
($test (subclassp (class <general-array*>) (class <character>)) nil)
($test (subclassp (class <general-array*>) (class <function>)) nil)
($test (subclassp (class <general-array*>) (class <generic-function>)) nil)
($test (subclassp (class <general-array*>) (class <standard-generic-function>)) nil)
($test (subclassp (class <general-array*>) (class <list>)) nil)
($test (subclassp (class <general-array*>) (class <cons>)) nil)
($test (subclassp (class <general-array*>) (class <null>)) nil)
($test (subclassp (class <general-array*>) (class <symbol>)) nil)
($test (subclassp (class <general-array*>) (class <number>)) nil)
($test (subclassp (class <general-array*>) (class <float>)) nil)
($test (subclassp (class <general-array*>) (class <integer>)) nil)
($test (subclassp (class <general-array*>) (class <serious-condition>)) nil)
($test (subclassp (class <general-array*>) (class <error>)) nil)
($test (subclassp (class <general-array*>) (class <arithmetic-error>)) nil)
($test (subclassp (class <general-array*>) (class <division-by-zero>)) nil)
($test (subclassp (class <general-array*>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <general-array*>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <general-array*>) (class <control-error>)) nil)
($test (subclassp (class <general-array*>) (class <parse-error>)) nil)
($test (subclassp (class <general-array*>) (class <program-error>)) nil)
($test (subclassp (class <general-array*>) (class <domain-error>)) nil)
($test (subclassp (class <general-array*>) (class <undefined-entity>)) nil)
($test (subclassp (class <general-array*>) (class <unbound-variable>)) nil)
($test (subclassp (class <general-array*>) (class <undefined-function>)) nil)
($test (subclassp (class <general-array*>) (class <simple-error>)) nil)
($test (subclassp (class <general-array*>) (class <stream-error>)) nil)
($test (subclassp (class <general-array*>) (class <end-of-stream>)) nil)
($test (subclassp (class <general-array*>) (class <storage-exhausted>)) nil)
($test (subclassp (class <general-array*>) (class <standard-class>)) nil)
($test (subclassp (class <general-array*>) (class <standard-object>)) nil)
($test (subclassp (class <general-array*>) (class <stream>)) nil)
;; <basic-vector>
($test (subclassp (class <basic-vector>) (class <object>)) t)
($test (subclassp (class <basic-vector>) (class <basic-array>)) t)
($test (subclassp (class <basic-vector>) (class <basic-array*>)) nil)
($test (subclassp (class <basic-vector>) (class <general-array*>)) nil)
($test (subclassp (class <basic-vector>) (class <basic-vector>)) nil)
($test (subclassp (class <basic-vector>) (class <general-vector>)) nil)
($test (subclassp (class <basic-vector>) (class <string>)) nil)
($test (subclassp (class <basic-vector>) (class <built-in-class>)) nil)
($test (subclassp (class <basic-vector>) (class <character>)) nil)
($test (subclassp (class <basic-vector>) (class <function>)) nil)
($test (subclassp (class <basic-vector>) (class <generic-function>)) nil)
($test (subclassp (class <basic-vector>) (class <standard-generic-function>)) nil)
($test (subclassp (class <basic-vector>) (class <list>)) nil)
($test (subclassp (class <basic-vector>) (class <cons>)) nil)
($test (subclassp (class <basic-vector>) (class <null>)) nil)
($test (subclassp (class <basic-vector>) (class <symbol>)) nil)
($test (subclassp (class <basic-vector>) (class <number>)) nil)
($test (subclassp (class <basic-vector>) (class <float>)) nil)
($test (subclassp (class <basic-vector>) (class <integer>)) nil)
($test (subclassp (class <basic-vector>) (class <serious-condition>)) nil)
($test (subclassp (class <basic-vector>) (class <error>)) nil)
($test (subclassp (class <basic-vector>) (class <arithmetic-error>)) nil)
($test (subclassp (class <basic-vector>) (class <division-by-zero>)) nil)
($test (subclassp (class <basic-vector>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <basic-vector>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <basic-vector>) (class <control-error>)) nil)
($test (subclassp (class <basic-vector>) (class <parse-error>)) nil)
($test (subclassp (class <basic-vector>) (class <program-error>)) nil)
($test (subclassp (class <basic-vector>) (class <domain-error>)) nil)
($test (subclassp (class <basic-vector>) (class <undefined-entity>)) nil)
($test (subclassp (class <basic-vector>) (class <unbound-variable>)) nil)
($test (subclassp (class <basic-vector>) (class <undefined-function>)) nil)
($test (subclassp (class <basic-vector>) (class <simple-error>)) nil)
($test (subclassp (class <basic-vector>) (class <stream-error>)) nil)
($test (subclassp (class <basic-vector>) (class <end-of-stream>)) nil)
($test (subclassp (class <basic-vector>) (class <storage-exhausted>)) nil)
($test (subclassp (class <basic-vector>) (class <standard-class>)) nil)
($test (subclassp (class <basic-vector>) (class <standard-object>)) nil)
($test (subclassp (class <basic-vector>) (class <stream>)) nil)
;; <general-vector>
($test (subclassp (class <general-vector>) (class <object>)) t)
($test (subclassp (class <general-vector>) (class <basic-array>)) t)
($test (subclassp (class <general-vector>) (class <basic-array*>)) nil)
($test (subclassp (class <general-vector>) (class <general-array*>)) nil)
($test (subclassp (class <general-vector>) (class <basic-vector>)) t)
($test (subclassp (class <general-vector>) (class <general-vector>)) nil)
($test (subclassp (class <general-vector>) (class <string>)) nil)
($test (subclassp (class <general-vector>) (class <built-in-class>)) nil)
($test (subclassp (class <general-vector>) (class <character>)) nil)
($test (subclassp (class <general-vector>) (class <function>)) nil)
($test (subclassp (class <general-vector>) (class <generic-function>)) nil)
($test (subclassp (class <general-vector>) (class <standard-generic-function>)) nil)
($test (subclassp (class <general-vector>) (class <list>)) nil)
($test (subclassp (class <general-vector>) (class <cons>)) nil)
($test (subclassp (class <general-vector>) (class <null>)) nil)
($test (subclassp (class <general-vector>) (class <symbol>)) nil)
($test (subclassp (class <general-vector>) (class <number>)) nil)
($test (subclassp (class <general-vector>) (class <float>)) nil)
($test (subclassp (class <general-vector>) (class <integer>)) nil)
($test (subclassp (class <general-vector>) (class <serious-condition>)) nil)
($test (subclassp (class <general-vector>) (class <error>)) nil)
($test (subclassp (class <general-vector>) (class <arithmetic-error>)) nil)
($test (subclassp (class <general-vector>) (class <division-by-zero>)) nil)
($test (subclassp (class <general-vector>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <general-vector>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <general-vector>) (class <control-error>)) nil)
($test (subclassp (class <general-vector>) (class <parse-error>)) nil)
($test (subclassp (class <general-vector>) (class <program-error>)) nil)
($test (subclassp (class <general-vector>) (class <domain-error>)) nil)
($test (subclassp (class <general-vector>) (class <undefined-entity>)) nil)
($test (subclassp (class <general-vector>) (class <unbound-variable>)) nil)
($test (subclassp (class <general-vector>) (class <undefined-function>)) nil)
($test (subclassp (class <general-vector>) (class <simple-error>)) nil)
($test (subclassp (class <general-vector>) (class <stream-error>)) nil)
($test (subclassp (class <general-vector>) (class <end-of-stream>)) nil)
($test (subclassp (class <general-vector>) (class <storage-exhausted>)) nil)
($test (subclassp (class <general-vector>) (class <standard-class>)) nil)
($test (subclassp (class <general-vector>) (class <standard-object>)) nil)
($test (subclassp (class <general-vector>) (class <stream>)) nil)
;; <string>
($test (subclassp (class <string>) (class <object>)) t)
($test (subclassp (class <string>) (class <basic-array>)) t)
($test (subclassp (class <string>) (class <basic-array*>)) nil)
($test (subclassp (class <string>) (class <general-array*>)) nil)
($test (subclassp (class <string>) (class <basic-vector>)) t)
($test (subclassp (class <string>) (class <general-vector>)) nil)
($test (subclassp (class <string>) (class <string>)) nil)
($test (subclassp (class <string>) (class <built-in-class>)) nil)
($test (subclassp (class <string>) (class <character>)) nil)
($test (subclassp (class <string>) (class <function>)) nil)
($test (subclassp (class <string>) (class <generic-function>)) nil)
($test (subclassp (class <string>) (class <standard-generic-function>)) nil)
($test (subclassp (class <string>) (class <list>)) nil)
($test (subclassp (class <string>) (class <cons>)) nil)
($test (subclassp (class <string>) (class <null>)) nil)
($test (subclassp (class <string>) (class <symbol>)) nil)
($test (subclassp (class <string>) (class <number>)) nil)
($test (subclassp (class <string>) (class <float>)) nil)
($test (subclassp (class <string>) (class <integer>)) nil)
($test (subclassp (class <string>) (class <serious-condition>)) nil)
($test (subclassp (class <string>) (class <error>)) nil)
($test (subclassp (class <string>) (class <arithmetic-error>)) nil)
($test (subclassp (class <string>) (class <division-by-zero>)) nil)
($test (subclassp (class <string>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <string>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <string>) (class <control-error>)) nil)
($test (subclassp (class <string>) (class <parse-error>)) nil)
($test (subclassp (class <string>) (class <program-error>)) nil)
($test (subclassp (class <string>) (class <domain-error>)) nil)
($test (subclassp (class <string>) (class <undefined-entity>)) nil)
($test (subclassp (class <string>) (class <unbound-variable>)) nil)
($test (subclassp (class <string>) (class <undefined-function>)) nil)
($test (subclassp (class <string>) (class <simple-error>)) nil)
($test (subclassp (class <string>) (class <stream-error>)) nil)
($test (subclassp (class <string>) (class <end-of-stream>)) nil)
($test (subclassp (class <string>) (class <storage-exhausted>)) nil)
($test (subclassp (class <string>) (class <standard-class>)) nil)
($test (subclassp (class <string>) (class <standard-object>)) nil)
($test (subclassp (class <string>) (class <stream>)) nil)
;; <built-in-class>
($test (subclassp (class <built-in-class>) (class <object>)) t)
($test (subclassp (class <built-in-class>) (class <basic-array>)) nil)
($test (subclassp (class <built-in-class>) (class <basic-array*>)) nil)
($test (subclassp (class <built-in-class>) (class <general-array*>)) nil)
($test (subclassp (class <built-in-class>) (class <basic-vector>)) nil)
($test (subclassp (class <built-in-class>) (class <general-vector>)) nil)
($test (subclassp (class <built-in-class>) (class <string>)) nil)
($test (subclassp (class <built-in-class>) (class <built-in-class>)) nil)
($test (subclassp (class <built-in-class>) (class <character>)) nil)
($test (subclassp (class <built-in-class>) (class <function>)) nil)
($test (subclassp (class <built-in-class>) (class <generic-function>)) nil)
($test (subclassp (class <built-in-class>) (class <standard-generic-function>)) nil)
($test (subclassp (class <built-in-class>) (class <list>)) nil)
($test (subclassp (class <built-in-class>) (class <cons>)) nil)
($test (subclassp (class <built-in-class>) (class <null>)) nil)
($test (subclassp (class <built-in-class>) (class <symbol>)) nil)
($test (subclassp (class <built-in-class>) (class <number>)) nil)
($test (subclassp (class <built-in-class>) (class <float>)) nil)
($test (subclassp (class <built-in-class>) (class <integer>)) nil)
($test (subclassp (class <built-in-class>) (class <serious-condition>)) nil)
($test (subclassp (class <built-in-class>) (class <error>)) nil)
($test (subclassp (class <built-in-class>) (class <arithmetic-error>)) nil)
($test (subclassp (class <built-in-class>) (class <division-by-zero>)) nil)
($test (subclassp (class <built-in-class>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <built-in-class>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <built-in-class>) (class <control-error>)) nil)
($test (subclassp (class <built-in-class>) (class <parse-error>)) nil)
($test (subclassp (class <built-in-class>) (class <program-error>)) nil)
($test (subclassp (class <built-in-class>) (class <domain-error>)) nil)
($test (subclassp (class <built-in-class>) (class <undefined-entity>)) nil)
($test (subclassp (class <built-in-class>) (class <unbound-variable>)) nil)
($test (subclassp (class <built-in-class>) (class <undefined-function>)) nil)
($test (subclassp (class <built-in-class>) (class <simple-error>)) nil)
($test (subclassp (class <built-in-class>) (class <stream-error>)) nil)
($test (subclassp (class <built-in-class>) (class <end-of-stream>)) nil)
($test (subclassp (class <built-in-class>) (class <storage-exhausted>)) nil)
($test (subclassp (class <built-in-class>) (class <standard-class>)) nil)
($test (subclassp (class <built-in-class>) (class <standard-object>)) nil)
($test (subclassp (class <built-in-class>) (class <stream>)) nil)
;; <character>
($test (subclassp (class <character>) (class <object>)) t)
($test (subclassp (class <character>) (class <basic-array>)) nil)
($test (subclassp (class <character>) (class <basic-array*>)) nil)
($test (subclassp (class <character>) (class <general-array*>)) nil)
($test (subclassp (class <character>) (class <basic-vector>)) nil)
($test (subclassp (class <character>) (class <general-vector>)) nil)
($test (subclassp (class <character>) (class <string>)) nil)
($test (subclassp (class <character>) (class <built-in-class>)) nil)
($test (subclassp (class <character>) (class <character>)) nil)
($test (subclassp (class <character>) (class <function>)) nil)
($test (subclassp (class <character>) (class <generic-function>)) nil)
($test (subclassp (class <character>) (class <standard-generic-function>)) nil)
($test (subclassp (class <character>) (class <list>)) nil)
($test (subclassp (class <character>) (class <cons>)) nil)
($test (subclassp (class <character>) (class <null>)) nil)
($test (subclassp (class <character>) (class <symbol>)) nil)
($test (subclassp (class <character>) (class <number>)) nil)
($test (subclassp (class <character>) (class <float>)) nil)
($test (subclassp (class <character>) (class <integer>)) nil)
($test (subclassp (class <character>) (class <serious-condition>)) nil)
($test (subclassp (class <character>) (class <error>)) nil)
($test (subclassp (class <character>) (class <arithmetic-error>)) nil)
($test (subclassp (class <character>) (class <division-by-zero>)) nil)
($test (subclassp (class <character>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <character>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <character>) (class <control-error>)) nil)
($test (subclassp (class <character>) (class <parse-error>)) nil)
($test (subclassp (class <character>) (class <program-error>)) nil)
($test (subclassp (class <character>) (class <domain-error>)) nil)
($test (subclassp (class <character>) (class <undefined-entity>)) nil)
($test (subclassp (class <character>) (class <unbound-variable>)) nil)
($test (subclassp (class <character>) (class <undefined-function>)) nil)
($test (subclassp (class <character>) (class <simple-error>)) nil)
($test (subclassp (class <character>) (class <stream-error>)) nil)
($test (subclassp (class <character>) (class <end-of-stream>)) nil)
($test (subclassp (class <character>) (class <storage-exhausted>)) nil)
($test (subclassp (class <character>) (class <standard-class>)) nil)
($test (subclassp (class <character>) (class <standard-object>)) nil)
($test (subclassp (class <character>) (class <stream>)) nil)
;; <function>
($test (subclassp (class <function>) (class <object>)) t)
($test (subclassp (class <function>) (class <basic-array>)) nil)
($test (subclassp (class <function>) (class <basic-array*>)) nil)
($test (subclassp (class <function>) (class <general-array*>)) nil)
($test (subclassp (class <function>) (class <basic-vector>)) nil)
($test (subclassp (class <function>) (class <general-vector>)) nil)
($test (subclassp (class <function>) (class <string>)) nil)
($test (subclassp (class <function>) (class <built-in-class>)) nil)
($test (subclassp (class <function>) (class <character>)) nil)
($test (subclassp (class <function>) (class <function>)) nil)
($test (subclassp (class <function>) (class <generic-function>)) nil)
($test (subclassp (class <function>) (class <standard-generic-function>)) nil)
($test (subclassp (class <function>) (class <list>)) nil)
($test (subclassp (class <function>) (class <cons>)) nil)
($test (subclassp (class <function>) (class <null>)) nil)
($test (subclassp (class <function>) (class <symbol>)) nil)
($test (subclassp (class <function>) (class <number>)) nil)
($test (subclassp (class <function>) (class <float>)) nil)
($test (subclassp (class <function>) (class <integer>)) nil)
($test (subclassp (class <function>) (class <serious-condition>)) nil)
($test (subclassp (class <function>) (class <error>)) nil)
($test (subclassp (class <function>) (class <arithmetic-error>)) nil)
($test (subclassp (class <function>) (class <division-by-zero>)) nil)
($test (subclassp (class <function>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <function>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <function>) (class <control-error>)) nil)
($test (subclassp (class <function>) (class <parse-error>)) nil)
($test (subclassp (class <function>) (class <program-error>)) nil)
($test (subclassp (class <function>) (class <domain-error>)) nil)
($test (subclassp (class <function>) (class <undefined-entity>)) nil)
($test (subclassp (class <function>) (class <unbound-variable>)) nil)
($test (subclassp (class <function>) (class <undefined-function>)) nil)
($test (subclassp (class <function>) (class <simple-error>)) nil)
($test (subclassp (class <function>) (class <stream-error>)) nil)
($test (subclassp (class <function>) (class <end-of-stream>)) nil)
($test (subclassp (class <function>) (class <storage-exhausted>)) nil)
($test (subclassp (class <function>) (class <standard-class>)) nil)
($test (subclassp (class <function>) (class <standard-object>)) nil)
($test (subclassp (class <function>) (class <stream>)) nil)
;; <generic-function>
($test (subclassp (class <generic-function>) (class <object>)) t)
($test (subclassp (class <generic-function>) (class <basic-array>)) nil)
($test (subclassp (class <generic-function>) (class <basic-array*>)) nil)
($test (subclassp (class <generic-function>) (class <general-array*>)) nil)
($test (subclassp (class <generic-function>) (class <basic-vector>)) nil)
($test (subclassp (class <generic-function>) (class <general-vector>)) nil)
($test (subclassp (class <generic-function>) (class <string>)) nil)
($test (subclassp (class <generic-function>) (class <built-in-class>)) nil)
($test (subclassp (class <generic-function>) (class <character>)) nil)
($test (subclassp (class <generic-function>) (class <function>)) t)
($test (subclassp (class <generic-function>) (class <generic-function>)) nil)
($test (subclassp (class <generic-function>) (class <standard-generic-function>)) nil)
($test (subclassp (class <generic-function>) (class <list>)) nil)
($test (subclassp (class <generic-function>) (class <cons>)) nil)
($test (subclassp (class <generic-function>) (class <null>)) nil)
($test (subclassp (class <generic-function>) (class <symbol>)) nil)
($test (subclassp (class <generic-function>) (class <number>)) nil)
($test (subclassp (class <generic-function>) (class <float>)) nil)
($test (subclassp (class <generic-function>) (class <integer>)) nil)
($test (subclassp (class <generic-function>) (class <serious-condition>)) nil)
($test (subclassp (class <generic-function>) (class <error>)) nil)
($test (subclassp (class <generic-function>) (class <arithmetic-error>)) nil)
($test (subclassp (class <generic-function>) (class <division-by-zero>)) nil)
($test (subclassp (class <generic-function>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <generic-function>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <generic-function>) (class <control-error>)) nil)
($test (subclassp (class <generic-function>) (class <parse-error>)) nil)
($test (subclassp (class <generic-function>) (class <program-error>)) nil)
($test (subclassp (class <generic-function>) (class <domain-error>)) nil)
($test (subclassp (class <generic-function>) (class <undefined-entity>)) nil)
($test (subclassp (class <generic-function>) (class <unbound-variable>)) nil)
($test (subclassp (class <generic-function>) (class <undefined-function>)) nil)
($test (subclassp (class <generic-function>) (class <simple-error>)) nil)
($test (subclassp (class <generic-function>) (class <stream-error>)) nil)
($test (subclassp (class <generic-function>) (class <end-of-stream>)) nil)
($test (subclassp (class <generic-function>) (class <storage-exhausted>)) nil)
($test (subclassp (class <generic-function>) (class <standard-class>)) nil)
($test (subclassp (class <generic-function>) (class <standard-object>)) nil)
($test (subclassp (class <generic-function>) (class <stream>)) nil)
;; <standard-generic-function>
($test (subclassp (class <standard-generic-function>) (class <object>)) t)
($test (subclassp (class <standard-generic-function>) (class <basic-array>)) nil)
($test (subclassp (class <standard-generic-function>) (class <basic-array*>)) nil)
($test (subclassp (class <standard-generic-function>) (class <general-array*>)) nil)
($test (subclassp (class <standard-generic-function>) (class <basic-vector>)) nil)
($test (subclassp (class <standard-generic-function>) (class <general-vector>)) nil)
($test (subclassp (class <standard-generic-function>) (class <string>)) nil)
($test (subclassp (class <standard-generic-function>) (class <built-in-class>)) nil)
($test (subclassp (class <standard-generic-function>) (class <character>)) nil)
($test (subclassp (class <standard-generic-function>) (class <function>)) t)
($test (subclassp (class <standard-generic-function>) (class <generic-function>)) t)
($test (subclassp (class <standard-generic-function>) (class <standard-generic-function>)) nil)
($test (subclassp (class <standard-generic-function>) (class <list>)) nil)
($test (subclassp (class <standard-generic-function>) (class <cons>)) nil)
($test (subclassp (class <standard-generic-function>) (class <null>)) nil)
($test (subclassp (class <standard-generic-function>) (class <symbol>)) nil)
($test (subclassp (class <standard-generic-function>) (class <number>)) nil)
($test (subclassp (class <standard-generic-function>) (class <float>)) nil)
($test (subclassp (class <standard-generic-function>) (class <integer>)) nil)
($test (subclassp (class <standard-generic-function>) (class <serious-condition>)) nil)
($test (subclassp (class <standard-generic-function>) (class <error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <arithmetic-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <division-by-zero>)) nil)
($test (subclassp (class <standard-generic-function>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <standard-generic-function>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <standard-generic-function>) (class <control-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <parse-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <program-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <domain-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <undefined-entity>)) nil)
($test (subclassp (class <standard-generic-function>) (class <unbound-variable>)) nil)
($test (subclassp (class <standard-generic-function>) (class <undefined-function>)) nil)
($test (subclassp (class <standard-generic-function>) (class <simple-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <stream-error>)) nil)
($test (subclassp (class <standard-generic-function>) (class <end-of-stream>)) nil)
($test (subclassp (class <standard-generic-function>) (class <storage-exhausted>)) nil)
($test (subclassp (class <standard-generic-function>) (class <standard-class>)) nil)
($test (subclassp (class <standard-generic-function>) (class <standard-object>)) nil)
($test (subclassp (class <standard-generic-function>) (class <stream>)) nil)
;; <list>
($test (subclassp (class <list>) (class <object>)) t)
($test (subclassp (class <list>) (class <basic-array>)) nil)
($test (subclassp (class <list>) (class <basic-array*>)) nil)
($test (subclassp (class <list>) (class <general-array*>)) nil)
($test (subclassp (class <list>) (class <basic-vector>)) nil)
($test (subclassp (class <list>) (class <general-vector>)) nil)
($test (subclassp (class <list>) (class <string>)) nil)
($test (subclassp (class <list>) (class <built-in-class>)) nil)
($test (subclassp (class <list>) (class <character>)) nil)
($test (subclassp (class <list>) (class <function>)) nil)
($test (subclassp (class <list>) (class <generic-function>)) nil)
($test (subclassp (class <list>) (class <standard-generic-function>)) nil)
($test (subclassp (class <list>) (class <list>)) nil)
($test (subclassp (class <list>) (class <cons>)) nil)
($test (subclassp (class <list>) (class <null>)) nil)
($test (subclassp (class <list>) (class <symbol>)) nil)
($test (subclassp (class <list>) (class <number>)) nil)
($test (subclassp (class <list>) (class <float>)) nil)
($test (subclassp (class <list>) (class <integer>)) nil)
($test (subclassp (class <list>) (class <serious-condition>)) nil)
($test (subclassp (class <list>) (class <error>)) nil)
($test (subclassp (class <list>) (class <arithmetic-error>)) nil)
($test (subclassp (class <list>) (class <division-by-zero>)) nil)
($test (subclassp (class <list>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <list>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <list>) (class <control-error>)) nil)
($test (subclassp (class <list>) (class <parse-error>)) nil)
($test (subclassp (class <list>) (class <program-error>)) nil)
($test (subclassp (class <list>) (class <domain-error>)) nil)
($test (subclassp (class <list>) (class <undefined-entity>)) nil)
($test (subclassp (class <list>) (class <unbound-variable>)) nil)
($test (subclassp (class <list>) (class <undefined-function>)) nil)
($test (subclassp (class <list>) (class <simple-error>)) nil)
($test (subclassp (class <list>) (class <stream-error>)) nil)
($test (subclassp (class <list>) (class <end-of-stream>)) nil)
($test (subclassp (class <list>) (class <storage-exhausted>)) nil)
($test (subclassp (class <list>) (class <standard-class>)) nil)
($test (subclassp (class <list>) (class <standard-object>)) nil)
($test (subclassp (class <list>) (class <stream>)) nil)
;; <cons>
($test (subclassp (class <cons>) (class <object>)) t)
($test (subclassp (class <cons>) (class <basic-array>)) nil)
($test (subclassp (class <cons>) (class <basic-array*>)) nil)
($test (subclassp (class <cons>) (class <general-array*>)) nil)
($test (subclassp (class <cons>) (class <basic-vector>)) nil)
($test (subclassp (class <cons>) (class <general-vector>)) nil)
($test (subclassp (class <cons>) (class <string>)) nil)
($test (subclassp (class <cons>) (class <built-in-class>)) nil)
($test (subclassp (class <cons>) (class <character>)) nil)
($test (subclassp (class <cons>) (class <function>)) nil)
($test (subclassp (class <cons>) (class <generic-function>)) nil)
($test (subclassp (class <cons>) (class <standard-generic-function>)) nil)
($test (subclassp (class <cons>) (class <list>)) t)
($test (subclassp (class <cons>) (class <cons>)) nil)
($test (subclassp (class <cons>) (class <null>)) nil)
($test (subclassp (class <cons>) (class <symbol>)) nil)
($test (subclassp (class <cons>) (class <number>)) nil)
($test (subclassp (class <cons>) (class <float>)) nil)
($test (subclassp (class <cons>) (class <integer>)) nil)
($test (subclassp (class <cons>) (class <serious-condition>)) nil)
($test (subclassp (class <cons>) (class <error>)) nil)
($test (subclassp (class <cons>) (class <arithmetic-error>)) nil)
($test (subclassp (class <cons>) (class <division-by-zero>)) nil)
($test (subclassp (class <cons>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <cons>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <cons>) (class <control-error>)) nil)
($test (subclassp (class <cons>) (class <parse-error>)) nil)
($test (subclassp (class <cons>) (class <program-error>)) nil)
($test (subclassp (class <cons>) (class <domain-error>)) nil)
($test (subclassp (class <cons>) (class <undefined-entity>)) nil)
($test (subclassp (class <cons>) (class <unbound-variable>)) nil)
($test (subclassp (class <cons>) (class <undefined-function>)) nil)
($test (subclassp (class <cons>) (class <simple-error>)) nil)
($test (subclassp (class <cons>) (class <stream-error>)) nil)
($test (subclassp (class <cons>) (class <end-of-stream>)) nil)
($test (subclassp (class <cons>) (class <storage-exhausted>)) nil)
($test (subclassp (class <cons>) (class <standard-class>)) nil)
($test (subclassp (class <cons>) (class <standard-object>)) nil)
($test (subclassp (class <cons>) (class <stream>)) nil)
;; <null>
($test (subclassp (class <null>) (class <object>)) t)
($test (subclassp (class <null>) (class <basic-array>)) nil)
($test (subclassp (class <null>) (class <basic-array*>)) nil)
($test (subclassp (class <null>) (class <general-array*>)) nil)
($test (subclassp (class <null>) (class <basic-vector>)) nil)
($test (subclassp (class <null>) (class <general-vector>)) nil)
($test (subclassp (class <null>) (class <string>)) nil)
($test (subclassp (class <null>) (class <built-in-class>)) nil)
($test (subclassp (class <null>) (class <character>)) nil)
($test (subclassp (class <null>) (class <function>)) nil)
($test (subclassp (class <null>) (class <generic-function>)) nil)
($test (subclassp (class <null>) (class <standard-generic-function>)) nil)
($test (subclassp (class <null>) (class <list>)) t)
($test (subclassp (class <null>) (class <cons>)) nil)
($test (subclassp (class <null>) (class <null>)) nil)
($test (subclassp (class <null>) (class <symbol>)) t)
($test (subclassp (class <null>) (class <number>)) nil)
($test (subclassp (class <null>) (class <float>)) nil)
($test (subclassp (class <null>) (class <integer>)) nil)
($test (subclassp (class <null>) (class <serious-condition>)) nil)
($test (subclassp (class <null>) (class <error>)) nil)
($test (subclassp (class <null>) (class <arithmetic-error>)) nil)
($test (subclassp (class <null>) (class <division-by-zero>)) nil)
($test (subclassp (class <null>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <null>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <null>) (class <control-error>)) nil)
($test (subclassp (class <null>) (class <parse-error>)) nil)
($test (subclassp (class <null>) (class <program-error>)) nil)
($test (subclassp (class <null>) (class <domain-error>)) nil)
($test (subclassp (class <null>) (class <undefined-entity>)) nil)
($test (subclassp (class <null>) (class <unbound-variable>)) nil)
($test (subclassp (class <null>) (class <undefined-function>)) nil)
($test (subclassp (class <null>) (class <simple-error>)) nil)
($test (subclassp (class <null>) (class <stream-error>)) nil)
($test (subclassp (class <null>) (class <end-of-stream>)) nil)
($test (subclassp (class <null>) (class <storage-exhausted>)) nil)
($test (subclassp (class <null>) (class <standard-class>)) nil)
($test (subclassp (class <null>) (class <standard-object>)) nil)
($test (subclassp (class <null>) (class <stream>)) nil)
;; <symbol>
($test (subclassp (class <symbol>) (class <object>)) t)
($test (subclassp (class <symbol>) (class <basic-array>)) nil)
($test (subclassp (class <symbol>) (class <basic-array*>)) nil)
($test (subclassp (class <symbol>) (class <general-array*>)) nil)
($test (subclassp (class <symbol>) (class <basic-vector>)) nil)
($test (subclassp (class <symbol>) (class <general-vector>)) nil)
($test (subclassp (class <symbol>) (class <string>)) nil)
($test (subclassp (class <symbol>) (class <built-in-class>)) nil)
($test (subclassp (class <symbol>) (class <character>)) nil)
($test (subclassp (class <symbol>) (class <function>)) nil)
($test (subclassp (class <symbol>) (class <generic-function>)) nil)
($test (subclassp (class <symbol>) (class <standard-generic-function>)) nil)
($test (subclassp (class <symbol>) (class <list>)) nil)
($test (subclassp (class <symbol>) (class <cons>)) nil)
($test (subclassp (class <symbol>) (class <null>)) nil)
($test (subclassp (class <symbol>) (class <symbol>)) nil)
($test (subclassp (class <symbol>) (class <number>)) nil)
($test (subclassp (class <symbol>) (class <float>)) nil)
($test (subclassp (class <symbol>) (class <integer>)) nil)
($test (subclassp (class <symbol>) (class <serious-condition>)) nil)
($test (subclassp (class <symbol>) (class <error>)) nil)
($test (subclassp (class <symbol>) (class <arithmetic-error>)) nil)
($test (subclassp (class <symbol>) (class <division-by-zero>)) nil)
($test (subclassp (class <symbol>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <symbol>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <symbol>) (class <control-error>)) nil)
($test (subclassp (class <symbol>) (class <parse-error>)) nil)
($test (subclassp (class <symbol>) (class <program-error>)) nil)
($test (subclassp (class <symbol>) (class <domain-error>)) nil)
($test (subclassp (class <symbol>) (class <undefined-entity>)) nil)
($test (subclassp (class <symbol>) (class <unbound-variable>)) nil)
($test (subclassp (class <symbol>) (class <undefined-function>)) nil)
($test (subclassp (class <symbol>) (class <simple-error>)) nil)
($test (subclassp (class <symbol>) (class <stream-error>)) nil)
($test (subclassp (class <symbol>) (class <end-of-stream>)) nil)
($test (subclassp (class <symbol>) (class <storage-exhausted>)) nil)
($test (subclassp (class <symbol>) (class <standard-class>)) nil)
($test (subclassp (class <symbol>) (class <standard-object>)) nil)
($test (subclassp (class <symbol>) (class <stream>)) nil)
;; <number>
($test (subclassp (class <number>) (class <object>)) t)
($test (subclassp (class <number>) (class <basic-array>)) nil)
($test (subclassp (class <number>) (class <basic-array*>)) nil)
($test (subclassp (class <number>) (class <general-array*>)) nil)
($test (subclassp (class <number>) (class <basic-vector>)) nil)
($test (subclassp (class <number>) (class <general-vector>)) nil)
($test (subclassp (class <number>) (class <string>)) nil)
($test (subclassp (class <number>) (class <built-in-class>)) nil)
($test (subclassp (class <number>) (class <character>)) nil)
($test (subclassp (class <number>) (class <function>)) nil)
($test (subclassp (class <number>) (class <generic-function>)) nil)
($test (subclassp (class <number>) (class <standard-generic-function>)) nil)
($test (subclassp (class <number>) (class <list>)) nil)
($test (subclassp (class <number>) (class <cons>)) nil)
($test (subclassp (class <number>) (class <null>)) nil)
($test (subclassp (class <number>) (class <symbol>)) nil)
($test (subclassp (class <number>) (class <number>)) nil)
($test (subclassp (class <number>) (class <float>)) nil)
($test (subclassp (class <number>) (class <integer>)) nil)
($test (subclassp (class <number>) (class <serious-condition>)) nil)
($test (subclassp (class <number>) (class <error>)) nil)
($test (subclassp (class <number>) (class <arithmetic-error>)) nil)
($test (subclassp (class <number>) (class <division-by-zero>)) nil)
($test (subclassp (class <number>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <number>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <number>) (class <control-error>)) nil)
($test (subclassp (class <number>) (class <parse-error>)) nil)
($test (subclassp (class <number>) (class <program-error>)) nil)
($test (subclassp (class <number>) (class <domain-error>)) nil)
($test (subclassp (class <number>) (class <undefined-entity>)) nil)
($test (subclassp (class <number>) (class <unbound-variable>)) nil)
($test (subclassp (class <number>) (class <undefined-function>)) nil)
($test (subclassp (class <number>) (class <simple-error>)) nil)
($test (subclassp (class <number>) (class <stream-error>)) nil)
($test (subclassp (class <number>) (class <end-of-stream>)) nil)
($test (subclassp (class <number>) (class <storage-exhausted>)) nil)
($test (subclassp (class <number>) (class <standard-class>)) nil)
($test (subclassp (class <number>) (class <standard-object>)) nil)
($test (subclassp (class <number>) (class <stream>)) nil)
;; <float>
($test (subclassp (class <float>) (class <object>)) t)
($test (subclassp (class <float>) (class <basic-array>)) nil)
($test (subclassp (class <float>) (class <basic-array*>)) nil)
($test (subclassp (class <float>) (class <general-array*>)) nil)
($test (subclassp (class <float>) (class <basic-vector>)) nil)
($test (subclassp (class <float>) (class <general-vector>)) nil)
($test (subclassp (class <float>) (class <string>)) nil)
($test (subclassp (class <float>) (class <built-in-class>)) nil)
($test (subclassp (class <float>) (class <character>)) nil)
($test (subclassp (class <float>) (class <function>)) nil)
($test (subclassp (class <float>) (class <generic-function>)) nil)
($test (subclassp (class <float>) (class <standard-generic-function>)) nil)
($test (subclassp (class <float>) (class <list>)) nil)
($test (subclassp (class <float>) (class <cons>)) nil)
($test (subclassp (class <float>) (class <null>)) nil)
($test (subclassp (class <float>) (class <symbol>)) nil)
($test (subclassp (class <float>) (class <number>)) t)
($test (subclassp (class <float>) (class <float>)) nil)
($test (subclassp (class <float>) (class <integer>)) nil)
($test (subclassp (class <float>) (class <serious-condition>)) nil)
($test (subclassp (class <float>) (class <error>)) nil)
($test (subclassp (class <float>) (class <arithmetic-error>)) nil)
($test (subclassp (class <float>) (class <division-by-zero>)) nil)
($test (subclassp (class <float>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <float>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <float>) (class <control-error>)) nil)
($test (subclassp (class <float>) (class <parse-error>)) nil)
($test (subclassp (class <float>) (class <program-error>)) nil)
($test (subclassp (class <float>) (class <domain-error>)) nil)
($test (subclassp (class <float>) (class <undefined-entity>)) nil)
($test (subclassp (class <float>) (class <unbound-variable>)) nil)
($test (subclassp (class <float>) (class <undefined-function>)) nil)
($test (subclassp (class <float>) (class <simple-error>)) nil)
($test (subclassp (class <float>) (class <stream-error>)) nil)
($test (subclassp (class <float>) (class <end-of-stream>)) nil)
($test (subclassp (class <float>) (class <storage-exhausted>)) nil)
($test (subclassp (class <float>) (class <standard-class>)) nil)
($test (subclassp (class <float>) (class <standard-object>)) nil)
($test (subclassp (class <float>) (class <stream>)) nil)
;; <integer>
($test (subclassp (class <integer>) (class <object>)) t)
($test (subclassp (class <integer>) (class <basic-array>)) nil)
($test (subclassp (class <integer>) (class <basic-array*>)) nil)
($test (subclassp (class <integer>) (class <general-array*>)) nil)
($test (subclassp (class <integer>) (class <basic-vector>)) nil)
($test (subclassp (class <integer>) (class <general-vector>)) nil)
($test (subclassp (class <integer>) (class <string>)) nil)
($test (subclassp (class <integer>) (class <built-in-class>)) nil)
($test (subclassp (class <integer>) (class <character>)) nil)
($test (subclassp (class <integer>) (class <function>)) nil)
($test (subclassp (class <integer>) (class <generic-function>)) nil)
($test (subclassp (class <integer>) (class <standard-generic-function>)) nil)
($test (subclassp (class <integer>) (class <list>)) nil)
($test (subclassp (class <integer>) (class <cons>)) nil)
($test (subclassp (class <integer>) (class <null>)) nil)
($test (subclassp (class <integer>) (class <symbol>)) nil)
($test (subclassp (class <integer>) (class <number>)) t)
($test (subclassp (class <integer>) (class <float>)) nil)
($test (subclassp (class <integer>) (class <integer>)) nil)
($test (subclassp (class <integer>) (class <serious-condition>)) nil)
($test (subclassp (class <integer>) (class <error>)) nil)
($test (subclassp (class <integer>) (class <arithmetic-error>)) nil)
($test (subclassp (class <integer>) (class <division-by-zero>)) nil)
($test (subclassp (class <integer>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <integer>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <integer>) (class <control-error>)) nil)
($test (subclassp (class <integer>) (class <parse-error>)) nil)
($test (subclassp (class <integer>) (class <program-error>)) nil)
($test (subclassp (class <integer>) (class <domain-error>)) nil)
($test (subclassp (class <integer>) (class <undefined-entity>)) nil)
($test (subclassp (class <integer>) (class <unbound-variable>)) nil)
($test (subclassp (class <integer>) (class <undefined-function>)) nil)
($test (subclassp (class <integer>) (class <simple-error>)) nil)
($test (subclassp (class <integer>) (class <stream-error>)) nil)
($test (subclassp (class <integer>) (class <end-of-stream>)) nil)
($test (subclassp (class <integer>) (class <storage-exhausted>)) nil)
($test (subclassp (class <integer>) (class <standard-class>)) nil)
($test (subclassp (class <integer>) (class <standard-object>)) nil)
($test (subclassp (class <integer>) (class <stream>)) nil)
;; <serious-condition>
($test (subclassp (class <serious-condition>) (class <object>)) t)
($test (subclassp (class <serious-condition>) (class <basic-array>)) nil)
($test (subclassp (class <serious-condition>) (class <basic-array*>)) nil)
($test (subclassp (class <serious-condition>) (class <general-array*>)) nil)
($test (subclassp (class <serious-condition>) (class <basic-vector>)) nil)
($test (subclassp (class <serious-condition>) (class <general-vector>)) nil)
($test (subclassp (class <serious-condition>) (class <string>)) nil)
($test (subclassp (class <serious-condition>) (class <built-in-class>)) nil)
($test (subclassp (class <serious-condition>) (class <character>)) nil)
($test (subclassp (class <serious-condition>) (class <function>)) nil)
($test (subclassp (class <serious-condition>) (class <generic-function>)) nil)
($test (subclassp (class <serious-condition>) (class <standard-generic-function>)) nil)
($test (subclassp (class <serious-condition>) (class <list>)) nil)
($test (subclassp (class <serious-condition>) (class <cons>)) nil)
($test (subclassp (class <serious-condition>) (class <null>)) nil)
($test (subclassp (class <serious-condition>) (class <symbol>)) nil)
($test (subclassp (class <serious-condition>) (class <number>)) nil)
($test (subclassp (class <serious-condition>) (class <float>)) nil)
($test (subclassp (class <serious-condition>) (class <integer>)) nil)
($test (subclassp (class <serious-condition>) (class <serious-condition>)) nil)
($test (subclassp (class <serious-condition>) (class <error>)) nil)
($test (subclassp (class <serious-condition>) (class <arithmetic-error>)) nil)
($test (subclassp (class <serious-condition>) (class <division-by-zero>)) nil)
($test (subclassp (class <serious-condition>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <serious-condition>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <serious-condition>) (class <control-error>)) nil)
($test (subclassp (class <serious-condition>) (class <parse-error>)) nil)
($test (subclassp (class <serious-condition>) (class <program-error>)) nil)
($test (subclassp (class <serious-condition>) (class <domain-error>)) nil)
($test (subclassp (class <serious-condition>) (class <undefined-entity>)) nil)
($test (subclassp (class <serious-condition>) (class <unbound-variable>)) nil)
($test (subclassp (class <serious-condition>) (class <undefined-function>)) nil)
($test (subclassp (class <serious-condition>) (class <simple-error>)) nil)
($test (subclassp (class <serious-condition>) (class <stream-error>)) nil)
($test (subclassp (class <serious-condition>) (class <end-of-stream>)) nil)
($test (subclassp (class <serious-condition>) (class <storage-exhausted>)) nil)
($test (subclassp (class <serious-condition>) (class <standard-class>)) nil)
($test (subclassp (class <serious-condition>) (class <standard-object>)) nil)
($test (subclassp (class <serious-condition>) (class <stream>)) nil)
;; <error>
($test (subclassp (class <error>) (class <object>)) t)
($test (subclassp (class <error>) (class <basic-array>)) nil)
($test (subclassp (class <error>) (class <basic-array*>)) nil)
($test (subclassp (class <error>) (class <general-array*>)) nil)
($test (subclassp (class <error>) (class <basic-vector>)) nil)
($test (subclassp (class <error>) (class <general-vector>)) nil)
($test (subclassp (class <error>) (class <string>)) nil)
($test (subclassp (class <error>) (class <built-in-class>)) nil)
($test (subclassp (class <error>) (class <character>)) nil)
($test (subclassp (class <error>) (class <function>)) nil)
($test (subclassp (class <error>) (class <generic-function>)) nil)
($test (subclassp (class <error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <error>) (class <list>)) nil)
($test (subclassp (class <error>) (class <cons>)) nil)
($test (subclassp (class <error>) (class <null>)) nil)
($test (subclassp (class <error>) (class <symbol>)) nil)
($test (subclassp (class <error>) (class <number>)) nil)
($test (subclassp (class <error>) (class <float>)) nil)
($test (subclassp (class <error>) (class <integer>)) nil)
($test (subclassp (class <error>) (class <serious-condition>)) t)
($test (subclassp (class <error>) (class <error>)) nil)
($test (subclassp (class <error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <error>) (class <division-by-zero>)) nil)
($test (subclassp (class <error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <error>) (class <control-error>)) nil)
($test (subclassp (class <error>) (class <parse-error>)) nil)
($test (subclassp (class <error>) (class <program-error>)) nil)
($test (subclassp (class <error>) (class <domain-error>)) nil)
($test (subclassp (class <error>) (class <undefined-entity>)) nil)
($test (subclassp (class <error>) (class <unbound-variable>)) nil)
($test (subclassp (class <error>) (class <undefined-function>)) nil)
($test (subclassp (class <error>) (class <simple-error>)) nil)
($test (subclassp (class <error>) (class <stream-error>)) nil)
($test (subclassp (class <error>) (class <end-of-stream>)) nil)
($test (subclassp (class <error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <error>) (class <standard-class>)) nil)
($test (subclassp (class <error>) (class <standard-object>)) nil)
($test (subclassp (class <error>) (class <stream>)) nil)
;; <arithmetic-error>
($test (subclassp (class <arithmetic-error>) (class <object>)) t)
($test (subclassp (class <arithmetic-error>) (class <basic-array>)) nil)
($test (subclassp (class <arithmetic-error>) (class <basic-array*>)) nil)
($test (subclassp (class <arithmetic-error>) (class <general-array*>)) nil)
($test (subclassp (class <arithmetic-error>) (class <basic-vector>)) nil)
($test (subclassp (class <arithmetic-error>) (class <general-vector>)) nil)
($test (subclassp (class <arithmetic-error>) (class <string>)) nil)
($test (subclassp (class <arithmetic-error>) (class <built-in-class>)) nil)
($test (subclassp (class <arithmetic-error>) (class <character>)) nil)
($test (subclassp (class <arithmetic-error>) (class <function>)) nil)
($test (subclassp (class <arithmetic-error>) (class <generic-function>)) nil)
($test (subclassp (class <arithmetic-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <arithmetic-error>) (class <list>)) nil)
($test (subclassp (class <arithmetic-error>) (class <cons>)) nil)
($test (subclassp (class <arithmetic-error>) (class <null>)) nil)
($test (subclassp (class <arithmetic-error>) (class <symbol>)) nil)
($test (subclassp (class <arithmetic-error>) (class <number>)) nil)
($test (subclassp (class <arithmetic-error>) (class <float>)) nil)
($test (subclassp (class <arithmetic-error>) (class <integer>)) nil)
($test (subclassp (class <arithmetic-error>) (class <serious-condition>)) t)
($test (subclassp (class <arithmetic-error>) (class <error>)) t)
($test (subclassp (class <arithmetic-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <arithmetic-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <arithmetic-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <arithmetic-error>) (class <control-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <parse-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <program-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <domain-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <arithmetic-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <arithmetic-error>) (class <undefined-function>)) nil)
($test (subclassp (class <arithmetic-error>) (class <simple-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <stream-error>)) nil)
($test (subclassp (class <arithmetic-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <arithmetic-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <arithmetic-error>) (class <standard-class>)) nil)
($test (subclassp (class <arithmetic-error>) (class <standard-object>)) nil)
($test (subclassp (class <arithmetic-error>) (class <stream>)) nil)
;; <division-by-zero>
($test (subclassp (class <division-by-zero>) (class <object>)) t)
($test (subclassp (class <division-by-zero>) (class <basic-array>)) nil)
($test (subclassp (class <division-by-zero>) (class <basic-array*>)) nil)
($test (subclassp (class <division-by-zero>) (class <general-array*>)) nil)
($test (subclassp (class <division-by-zero>) (class <basic-vector>)) nil)
($test (subclassp (class <division-by-zero>) (class <general-vector>)) nil)
($test (subclassp (class <division-by-zero>) (class <string>)) nil)
($test (subclassp (class <division-by-zero>) (class <built-in-class>)) nil)
($test (subclassp (class <division-by-zero>) (class <character>)) nil)
($test (subclassp (class <division-by-zero>) (class <function>)) nil)
($test (subclassp (class <division-by-zero>) (class <generic-function>)) nil)
($test (subclassp (class <division-by-zero>) (class <standard-generic-function>)) nil)
($test (subclassp (class <division-by-zero>) (class <list>)) nil)
($test (subclassp (class <division-by-zero>) (class <cons>)) nil)
($test (subclassp (class <division-by-zero>) (class <null>)) nil)
($test (subclassp (class <division-by-zero>) (class <symbol>)) nil)
($test (subclassp (class <division-by-zero>) (class <number>)) nil)
($test (subclassp (class <division-by-zero>) (class <float>)) nil)
($test (subclassp (class <division-by-zero>) (class <integer>)) nil)
($test (subclassp (class <division-by-zero>) (class <serious-condition>)) t)
($test (subclassp (class <division-by-zero>) (class <error>)) t)
($test (subclassp (class <division-by-zero>) (class <arithmetic-error>)) t)
($test (subclassp (class <division-by-zero>) (class <division-by-zero>)) nil)
($test (subclassp (class <division-by-zero>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <division-by-zero>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <division-by-zero>) (class <control-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <parse-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <program-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <domain-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <undefined-entity>)) nil)
($test (subclassp (class <division-by-zero>) (class <unbound-variable>)) nil)
($test (subclassp (class <division-by-zero>) (class <undefined-function>)) nil)
($test (subclassp (class <division-by-zero>) (class <simple-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <stream-error>)) nil)
($test (subclassp (class <division-by-zero>) (class <end-of-stream>)) nil)
($test (subclassp (class <division-by-zero>) (class <storage-exhausted>)) nil)
($test (subclassp (class <division-by-zero>) (class <standard-class>)) nil)
($test (subclassp (class <division-by-zero>) (class <standard-object>)) nil)
($test (subclassp (class <division-by-zero>) (class <stream>)) nil)
;; <floating-point-overflow>
($test (subclassp (class <floating-point-overflow>) (class <object>)) t)
($test (subclassp (class <floating-point-overflow>) (class <basic-array>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <basic-array*>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <general-array*>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <basic-vector>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <general-vector>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <string>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <built-in-class>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <character>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <function>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <generic-function>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <standard-generic-function>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <list>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <cons>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <null>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <symbol>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <number>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <float>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <integer>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <serious-condition>)) t)
($test (subclassp (class <floating-point-overflow>) (class <error>)) t)
($test (subclassp (class <floating-point-overflow>) (class <arithmetic-error>)) t)
($test (subclassp (class <floating-point-overflow>) (class <division-by-zero>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <control-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <parse-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <program-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <domain-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <undefined-entity>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <unbound-variable>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <undefined-function>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <simple-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <stream-error>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <end-of-stream>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <storage-exhausted>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <standard-class>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <standard-object>)) nil)
($test (subclassp (class <floating-point-overflow>) (class <stream>)) nil)
;; <floating-point-underflow>
($test (subclassp (class <floating-point-underflow>) (class <object>)) t)
($test (subclassp (class <floating-point-underflow>) (class <basic-array>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <basic-array*>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <general-array*>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <basic-vector>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <general-vector>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <string>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <built-in-class>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <character>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <function>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <generic-function>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <standard-generic-function>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <list>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <cons>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <null>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <symbol>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <number>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <float>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <integer>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <serious-condition>)) t)
($test (subclassp (class <floating-point-underflow>) (class <error>)) t)
($test (subclassp (class <floating-point-underflow>) (class <arithmetic-error>)) t)
($test (subclassp (class <floating-point-underflow>) (class <division-by-zero>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <control-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <parse-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <program-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <domain-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <undefined-entity>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <unbound-variable>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <undefined-function>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <simple-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <stream-error>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <end-of-stream>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <storage-exhausted>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <standard-class>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <standard-object>)) nil)
($test (subclassp (class <floating-point-underflow>) (class <stream>)) nil)
;; <control-error>
($test (subclassp (class <control-error>) (class <object>)) t)
($test (subclassp (class <control-error>) (class <basic-array>)) nil)
($test (subclassp (class <control-error>) (class <basic-array*>)) nil)
($test (subclassp (class <control-error>) (class <general-array*>)) nil)
($test (subclassp (class <control-error>) (class <basic-vector>)) nil)
($test (subclassp (class <control-error>) (class <general-vector>)) nil)
($test (subclassp (class <control-error>) (class <string>)) nil)
($test (subclassp (class <control-error>) (class <built-in-class>)) nil)
($test (subclassp (class <control-error>) (class <character>)) nil)
($test (subclassp (class <control-error>) (class <function>)) nil)
($test (subclassp (class <control-error>) (class <generic-function>)) nil)
($test (subclassp (class <control-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <control-error>) (class <list>)) nil)
($test (subclassp (class <control-error>) (class <cons>)) nil)
($test (subclassp (class <control-error>) (class <null>)) nil)
($test (subclassp (class <control-error>) (class <symbol>)) nil)
($test (subclassp (class <control-error>) (class <number>)) nil)
($test (subclassp (class <control-error>) (class <float>)) nil)
($test (subclassp (class <control-error>) (class <integer>)) nil)
($test (subclassp (class <control-error>) (class <serious-condition>)) t)
($test (subclassp (class <control-error>) (class <error>)) t)
($test (subclassp (class <control-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <control-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <control-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <control-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <control-error>) (class <control-error>)) nil)
($test (subclassp (class <control-error>) (class <parse-error>)) nil)
($test (subclassp (class <control-error>) (class <program-error>)) nil)
($test (subclassp (class <control-error>) (class <domain-error>)) nil)
($test (subclassp (class <control-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <control-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <control-error>) (class <undefined-function>)) nil)
($test (subclassp (class <control-error>) (class <simple-error>)) nil)
($test (subclassp (class <control-error>) (class <stream-error>)) nil)
($test (subclassp (class <control-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <control-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <control-error>) (class <standard-class>)) nil)
($test (subclassp (class <control-error>) (class <standard-object>)) nil)
($test (subclassp (class <control-error>) (class <stream>)) nil)
;; <parse-error>
($test (subclassp (class <parse-error>) (class <object>)) t)
($test (subclassp (class <parse-error>) (class <basic-array>)) nil)
($test (subclassp (class <parse-error>) (class <basic-array*>)) nil)
($test (subclassp (class <parse-error>) (class <general-array*>)) nil)
($test (subclassp (class <parse-error>) (class <basic-vector>)) nil)
($test (subclassp (class <parse-error>) (class <general-vector>)) nil)
($test (subclassp (class <parse-error>) (class <string>)) nil)
($test (subclassp (class <parse-error>) (class <built-in-class>)) nil)
($test (subclassp (class <parse-error>) (class <character>)) nil)
($test (subclassp (class <parse-error>) (class <function>)) nil)
($test (subclassp (class <parse-error>) (class <generic-function>)) nil)
($test (subclassp (class <parse-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <parse-error>) (class <list>)) nil)
($test (subclassp (class <parse-error>) (class <cons>)) nil)
($test (subclassp (class <parse-error>) (class <null>)) nil)
($test (subclassp (class <parse-error>) (class <symbol>)) nil)
($test (subclassp (class <parse-error>) (class <number>)) nil)
($test (subclassp (class <parse-error>) (class <float>)) nil)
($test (subclassp (class <parse-error>) (class <integer>)) nil)
($test (subclassp (class <parse-error>) (class <serious-condition>)) t)
($test (subclassp (class <parse-error>) (class <error>)) t)
($test (subclassp (class <parse-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <parse-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <parse-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <parse-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <parse-error>) (class <control-error>)) nil)
($test (subclassp (class <parse-error>) (class <parse-error>)) nil)
($test (subclassp (class <parse-error>) (class <program-error>)) nil)
($test (subclassp (class <parse-error>) (class <domain-error>)) nil)
($test (subclassp (class <parse-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <parse-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <parse-error>) (class <undefined-function>)) nil)
($test (subclassp (class <parse-error>) (class <simple-error>)) nil)
($test (subclassp (class <parse-error>) (class <stream-error>)) nil)
($test (subclassp (class <parse-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <parse-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <parse-error>) (class <standard-class>)) nil)
($test (subclassp (class <parse-error>) (class <standard-object>)) nil)
($test (subclassp (class <parse-error>) (class <stream>)) nil)
;; <program-error>
($test (subclassp (class <program-error>) (class <object>)) t)
($test (subclassp (class <program-error>) (class <basic-array>)) nil)
($test (subclassp (class <program-error>) (class <basic-array*>)) nil)
($test (subclassp (class <program-error>) (class <general-array*>)) nil)
($test (subclassp (class <program-error>) (class <basic-vector>)) nil)
($test (subclassp (class <program-error>) (class <general-vector>)) nil)
($test (subclassp (class <program-error>) (class <string>)) nil)
($test (subclassp (class <program-error>) (class <built-in-class>)) nil)
($test (subclassp (class <program-error>) (class <character>)) nil)
($test (subclassp (class <program-error>) (class <function>)) nil)
($test (subclassp (class <program-error>) (class <generic-function>)) nil)
($test (subclassp (class <program-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <program-error>) (class <list>)) nil)
($test (subclassp (class <program-error>) (class <cons>)) nil)
($test (subclassp (class <program-error>) (class <null>)) nil)
($test (subclassp (class <program-error>) (class <symbol>)) nil)
($test (subclassp (class <program-error>) (class <number>)) nil)
($test (subclassp (class <program-error>) (class <float>)) nil)
($test (subclassp (class <program-error>) (class <integer>)) nil)
($test (subclassp (class <program-error>) (class <serious-condition>)) t)
($test (subclassp (class <program-error>) (class <error>)) t)
($test (subclassp (class <program-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <program-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <program-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <program-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <program-error>) (class <control-error>)) nil)
($test (subclassp (class <program-error>) (class <parse-error>)) nil)
($test (subclassp (class <program-error>) (class <program-error>)) nil)
($test (subclassp (class <program-error>) (class <domain-error>)) nil)
($test (subclassp (class <program-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <program-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <program-error>) (class <undefined-function>)) nil)
($test (subclassp (class <program-error>) (class <simple-error>)) nil)
($test (subclassp (class <program-error>) (class <stream-error>)) nil)
($test (subclassp (class <program-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <program-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <program-error>) (class <standard-class>)) nil)
($test (subclassp (class <program-error>) (class <standard-object>)) nil)
($test (subclassp (class <program-error>) (class <stream>)) nil)
;; <domain-error>
($test (subclassp (class <domain-error>) (class <object>)) t)
($test (subclassp (class <domain-error>) (class <basic-array>)) nil)
($test (subclassp (class <domain-error>) (class <basic-array*>)) nil)
($test (subclassp (class <domain-error>) (class <general-array*>)) nil)
($test (subclassp (class <domain-error>) (class <basic-vector>)) nil)
($test (subclassp (class <domain-error>) (class <general-vector>)) nil)
($test (subclassp (class <domain-error>) (class <string>)) nil)
($test (subclassp (class <domain-error>) (class <built-in-class>)) nil)
($test (subclassp (class <domain-error>) (class <character>)) nil)
($test (subclassp (class <domain-error>) (class <function>)) nil)
($test (subclassp (class <domain-error>) (class <generic-function>)) nil)
($test (subclassp (class <domain-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <domain-error>) (class <list>)) nil)
($test (subclassp (class <domain-error>) (class <cons>)) nil)
($test (subclassp (class <domain-error>) (class <null>)) nil)
($test (subclassp (class <domain-error>) (class <symbol>)) nil)
($test (subclassp (class <domain-error>) (class <number>)) nil)
($test (subclassp (class <domain-error>) (class <float>)) nil)
($test (subclassp (class <domain-error>) (class <integer>)) nil)
($test (subclassp (class <domain-error>) (class <serious-condition>)) t)
($test (subclassp (class <domain-error>) (class <error>)) t)
($test (subclassp (class <domain-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <domain-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <domain-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <domain-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <domain-error>) (class <control-error>)) nil)
($test (subclassp (class <domain-error>) (class <parse-error>)) nil)
($test (subclassp (class <domain-error>) (class <program-error>)) t)
($test (subclassp (class <domain-error>) (class <domain-error>)) nil)
($test (subclassp (class <domain-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <domain-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <domain-error>) (class <undefined-function>)) nil)
($test (subclassp (class <domain-error>) (class <simple-error>)) nil)
($test (subclassp (class <domain-error>) (class <stream-error>)) nil)
($test (subclassp (class <domain-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <domain-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <domain-error>) (class <standard-class>)) nil)
($test (subclassp (class <domain-error>) (class <standard-object>)) nil)
($test (subclassp (class <domain-error>) (class <stream>)) nil)
;; <undefined-entity>
($test (subclassp (class <undefined-entity>) (class <object>)) t)
($test (subclassp (class <undefined-entity>) (class <basic-array>)) nil)
($test (subclassp (class <undefined-entity>) (class <basic-array*>)) nil)
($test (subclassp (class <undefined-entity>) (class <general-array*>)) nil)
($test (subclassp (class <undefined-entity>) (class <basic-vector>)) nil)
($test (subclassp (class <undefined-entity>) (class <general-vector>)) nil)
($test (subclassp (class <undefined-entity>) (class <string>)) nil)
($test (subclassp (class <undefined-entity>) (class <built-in-class>)) nil)
($test (subclassp (class <undefined-entity>) (class <character>)) nil)
($test (subclassp (class <undefined-entity>) (class <function>)) nil)
($test (subclassp (class <undefined-entity>) (class <generic-function>)) nil)
($test (subclassp (class <undefined-entity>) (class <standard-generic-function>)) nil)
($test (subclassp (class <undefined-entity>) (class <list>)) nil)
($test (subclassp (class <undefined-entity>) (class <cons>)) nil)
($test (subclassp (class <undefined-entity>) (class <null>)) nil)
($test (subclassp (class <undefined-entity>) (class <symbol>)) nil)
($test (subclassp (class <undefined-entity>) (class <number>)) nil)
($test (subclassp (class <undefined-entity>) (class <float>)) nil)
($test (subclassp (class <undefined-entity>) (class <integer>)) nil)
($test (subclassp (class <undefined-entity>) (class <serious-condition>)) t)
($test (subclassp (class <undefined-entity>) (class <error>)) t)
($test (subclassp (class <undefined-entity>) (class <arithmetic-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <division-by-zero>)) nil)
($test (subclassp (class <undefined-entity>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <undefined-entity>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <undefined-entity>) (class <control-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <parse-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <program-error>)) t)
($test (subclassp (class <undefined-entity>) (class <domain-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <undefined-entity>)) nil)
($test (subclassp (class <undefined-entity>) (class <unbound-variable>)) nil)
($test (subclassp (class <undefined-entity>) (class <undefined-function>)) nil)
($test (subclassp (class <undefined-entity>) (class <simple-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <stream-error>)) nil)
($test (subclassp (class <undefined-entity>) (class <end-of-stream>)) nil)
($test (subclassp (class <undefined-entity>) (class <storage-exhausted>)) nil)
($test (subclassp (class <undefined-entity>) (class <standard-class>)) nil)
($test (subclassp (class <undefined-entity>) (class <standard-object>)) nil)
($test (subclassp (class <undefined-entity>) (class <stream>)) nil)
;; <unbound-variable>
($test (subclassp (class <unbound-variable>) (class <object>)) t)
($test (subclassp (class <unbound-variable>) (class <basic-array>)) nil)
($test (subclassp (class <unbound-variable>) (class <basic-array*>)) nil)
($test (subclassp (class <unbound-variable>) (class <general-array*>)) nil)
($test (subclassp (class <unbound-variable>) (class <basic-vector>)) nil)
($test (subclassp (class <unbound-variable>) (class <general-vector>)) nil)
($test (subclassp (class <unbound-variable>) (class <string>)) nil)
($test (subclassp (class <unbound-variable>) (class <built-in-class>)) nil)
($test (subclassp (class <unbound-variable>) (class <character>)) nil)
($test (subclassp (class <unbound-variable>) (class <function>)) nil)
($test (subclassp (class <unbound-variable>) (class <generic-function>)) nil)
($test (subclassp (class <unbound-variable>) (class <standard-generic-function>)) nil)
($test (subclassp (class <unbound-variable>) (class <list>)) nil)
($test (subclassp (class <unbound-variable>) (class <cons>)) nil)
($test (subclassp (class <unbound-variable>) (class <null>)) nil)
($test (subclassp (class <unbound-variable>) (class <symbol>)) nil)
($test (subclassp (class <unbound-variable>) (class <number>)) nil)
($test (subclassp (class <unbound-variable>) (class <float>)) nil)
($test (subclassp (class <unbound-variable>) (class <integer>)) nil)
($test (subclassp (class <unbound-variable>) (class <serious-condition>)) t)
($test (subclassp (class <unbound-variable>) (class <error>)) t)
($test (subclassp (class <unbound-variable>) (class <arithmetic-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <division-by-zero>)) nil)
($test (subclassp (class <unbound-variable>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <unbound-variable>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <unbound-variable>) (class <control-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <parse-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <program-error>)) t)
($test (subclassp (class <unbound-variable>) (class <domain-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <undefined-entity>)) t)
($test (subclassp (class <unbound-variable>) (class <unbound-variable>)) nil)
($test (subclassp (class <unbound-variable>) (class <undefined-function>)) nil)
($test (subclassp (class <unbound-variable>) (class <simple-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <stream-error>)) nil)
($test (subclassp (class <unbound-variable>) (class <end-of-stream>)) nil)
($test (subclassp (class <unbound-variable>) (class <storage-exhausted>)) nil)
($test (subclassp (class <unbound-variable>) (class <standard-class>)) nil)
($test (subclassp (class <unbound-variable>) (class <standard-object>)) nil)
($test (subclassp (class <unbound-variable>) (class <stream>)) nil)
;; <undefined-function>
($test (subclassp (class <undefined-function>) (class <object>)) t)
($test (subclassp (class <undefined-function>) (class <basic-array>)) nil)
($test (subclassp (class <undefined-function>) (class <basic-array*>)) nil)
($test (subclassp (class <undefined-function>) (class <general-array*>)) nil)
($test (subclassp (class <undefined-function>) (class <basic-vector>)) nil)
($test (subclassp (class <undefined-function>) (class <general-vector>)) nil)
($test (subclassp (class <undefined-function>) (class <string>)) nil)
($test (subclassp (class <undefined-function>) (class <built-in-class>)) nil)
($test (subclassp (class <undefined-function>) (class <character>)) nil)
($test (subclassp (class <undefined-function>) (class <function>)) nil)
($test (subclassp (class <undefined-function>) (class <generic-function>)) nil)
($test (subclassp (class <undefined-function>) (class <standard-generic-function>)) nil)
($test (subclassp (class <undefined-function>) (class <list>)) nil)
($test (subclassp (class <undefined-function>) (class <cons>)) nil)
($test (subclassp (class <undefined-function>) (class <null>)) nil)
($test (subclassp (class <undefined-function>) (class <symbol>)) nil)
($test (subclassp (class <undefined-function>) (class <number>)) nil)
($test (subclassp (class <undefined-function>) (class <float>)) nil)
($test (subclassp (class <undefined-function>) (class <integer>)) nil)
($test (subclassp (class <undefined-function>) (class <serious-condition>)) t)
($test (subclassp (class <undefined-function>) (class <error>)) t)
($test (subclassp (class <undefined-function>) (class <arithmetic-error>)) nil)
($test (subclassp (class <undefined-function>) (class <division-by-zero>)) nil)
($test (subclassp (class <undefined-function>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <undefined-function>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <undefined-function>) (class <control-error>)) nil)
($test (subclassp (class <undefined-function>) (class <parse-error>)) nil)
($test (subclassp (class <undefined-function>) (class <program-error>)) t)
($test (subclassp (class <undefined-function>) (class <domain-error>)) nil)
($test (subclassp (class <undefined-function>) (class <undefined-entity>)) t)
($test (subclassp (class <undefined-function>) (class <unbound-variable>)) nil)
($test (subclassp (class <undefined-function>) (class <undefined-function>)) nil)
($test (subclassp (class <undefined-function>) (class <simple-error>)) nil)
($test (subclassp (class <undefined-function>) (class <stream-error>)) nil)
($test (subclassp (class <undefined-function>) (class <end-of-stream>)) nil)
($test (subclassp (class <undefined-function>) (class <storage-exhausted>)) nil)
($test (subclassp (class <undefined-function>) (class <standard-class>)) nil)
($test (subclassp (class <undefined-function>) (class <standard-object>)) nil)
($test (subclassp (class <undefined-function>) (class <stream>)) nil)
;; <simple-error>
($test (subclassp (class <simple-error>) (class <object>)) t)
($test (subclassp (class <simple-error>) (class <basic-array>)) nil)
($test (subclassp (class <simple-error>) (class <basic-array*>)) nil)
($test (subclassp (class <simple-error>) (class <general-array*>)) nil)
($test (subclassp (class <simple-error>) (class <basic-vector>)) nil)
($test (subclassp (class <simple-error>) (class <general-vector>)) nil)
($test (subclassp (class <simple-error>) (class <string>)) nil)
($test (subclassp (class <simple-error>) (class <built-in-class>)) nil)
($test (subclassp (class <simple-error>) (class <character>)) nil)
($test (subclassp (class <simple-error>) (class <function>)) nil)
($test (subclassp (class <simple-error>) (class <generic-function>)) nil)
($test (subclassp (class <simple-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <simple-error>) (class <list>)) nil)
($test (subclassp (class <simple-error>) (class <cons>)) nil)
($test (subclassp (class <simple-error>) (class <null>)) nil)
($test (subclassp (class <simple-error>) (class <symbol>)) nil)
($test (subclassp (class <simple-error>) (class <number>)) nil)
($test (subclassp (class <simple-error>) (class <float>)) nil)
($test (subclassp (class <simple-error>) (class <integer>)) nil)
($test (subclassp (class <simple-error>) (class <serious-condition>)) t)
($test (subclassp (class <simple-error>) (class <error>)) t)
($test (subclassp (class <simple-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <simple-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <simple-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <simple-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <simple-error>) (class <control-error>)) nil)
($test (subclassp (class <simple-error>) (class <parse-error>)) nil)
($test (subclassp (class <simple-error>) (class <program-error>)) nil)
($test (subclassp (class <simple-error>) (class <domain-error>)) nil)
($test (subclassp (class <simple-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <simple-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <simple-error>) (class <undefined-function>)) nil)
($test (subclassp (class <simple-error>) (class <simple-error>)) nil)
($test (subclassp (class <simple-error>) (class <stream-error>)) nil)
($test (subclassp (class <simple-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <simple-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <simple-error>) (class <standard-class>)) nil)
($test (subclassp (class <simple-error>) (class <standard-object>)) nil)
($test (subclassp (class <simple-error>) (class <stream>)) nil)
;; <stream-error>
($test (subclassp (class <stream-error>) (class <object>)) t)
($test (subclassp (class <stream-error>) (class <basic-array>)) nil)
($test (subclassp (class <stream-error>) (class <basic-array*>)) nil)
($test (subclassp (class <stream-error>) (class <general-array*>)) nil)
($test (subclassp (class <stream-error>) (class <basic-vector>)) nil)
($test (subclassp (class <stream-error>) (class <general-vector>)) nil)
($test (subclassp (class <stream-error>) (class <string>)) nil)
($test (subclassp (class <stream-error>) (class <built-in-class>)) nil)
($test (subclassp (class <stream-error>) (class <character>)) nil)
($test (subclassp (class <stream-error>) (class <function>)) nil)
($test (subclassp (class <stream-error>) (class <generic-function>)) nil)
($test (subclassp (class <stream-error>) (class <standard-generic-function>)) nil)
($test (subclassp (class <stream-error>) (class <list>)) nil)
($test (subclassp (class <stream-error>) (class <cons>)) nil)
($test (subclassp (class <stream-error>) (class <null>)) nil)
($test (subclassp (class <stream-error>) (class <symbol>)) nil)
($test (subclassp (class <stream-error>) (class <number>)) nil)
($test (subclassp (class <stream-error>) (class <float>)) nil)
($test (subclassp (class <stream-error>) (class <integer>)) nil)
($test (subclassp (class <stream-error>) (class <serious-condition>)) t)
($test (subclassp (class <stream-error>) (class <error>)) t)
($test (subclassp (class <stream-error>) (class <arithmetic-error>)) nil)
($test (subclassp (class <stream-error>) (class <division-by-zero>)) nil)
($test (subclassp (class <stream-error>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <stream-error>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <stream-error>) (class <control-error>)) nil)
($test (subclassp (class <stream-error>) (class <parse-error>)) nil)
($test (subclassp (class <stream-error>) (class <program-error>)) nil)
($test (subclassp (class <stream-error>) (class <domain-error>)) nil)
($test (subclassp (class <stream-error>) (class <undefined-entity>)) nil)
($test (subclassp (class <stream-error>) (class <unbound-variable>)) nil)
($test (subclassp (class <stream-error>) (class <undefined-function>)) nil)
($test (subclassp (class <stream-error>) (class <simple-error>)) nil)
($test (subclassp (class <stream-error>) (class <stream-error>)) nil)
($test (subclassp (class <stream-error>) (class <end-of-stream>)) nil)
($test (subclassp (class <stream-error>) (class <storage-exhausted>)) nil)
($test (subclassp (class <stream-error>) (class <standard-class>)) nil)
($test (subclassp (class <stream-error>) (class <standard-object>)) nil)
($test (subclassp (class <stream-error>) (class <stream>)) nil)
;; <end-of-stream>
($test (subclassp (class <end-of-stream>) (class <object>)) t)
($test (subclassp (class <end-of-stream>) (class <basic-array>)) nil)
($test (subclassp (class <end-of-stream>) (class <basic-array*>)) nil)
($test (subclassp (class <end-of-stream>) (class <general-array*>)) nil)
($test (subclassp (class <end-of-stream>) (class <basic-vector>)) nil)
($test (subclassp (class <end-of-stream>) (class <general-vector>)) nil)
($test (subclassp (class <end-of-stream>) (class <string>)) nil)
($test (subclassp (class <end-of-stream>) (class <built-in-class>)) nil)
($test (subclassp (class <end-of-stream>) (class <character>)) nil)
($test (subclassp (class <end-of-stream>) (class <function>)) nil)
($test (subclassp (class <end-of-stream>) (class <generic-function>)) nil)
($test (subclassp (class <end-of-stream>) (class <standard-generic-function>)) nil)
($test (subclassp (class <end-of-stream>) (class <list>)) nil)
($test (subclassp (class <end-of-stream>) (class <cons>)) nil)
($test (subclassp (class <end-of-stream>) (class <null>)) nil)
($test (subclassp (class <end-of-stream>) (class <symbol>)) nil)
($test (subclassp (class <end-of-stream>) (class <number>)) nil)
($test (subclassp (class <end-of-stream>) (class <float>)) nil)
($test (subclassp (class <end-of-stream>) (class <integer>)) nil)
($test (subclassp (class <end-of-stream>) (class <serious-condition>)) t)
($test (subclassp (class <end-of-stream>) (class <error>)) t)
($test (subclassp (class <end-of-stream>) (class <arithmetic-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <division-by-zero>)) nil)
($test (subclassp (class <end-of-stream>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <end-of-stream>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <end-of-stream>) (class <control-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <parse-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <program-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <domain-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <undefined-entity>)) nil)
($test (subclassp (class <end-of-stream>) (class <unbound-variable>)) nil)
($test (subclassp (class <end-of-stream>) (class <undefined-function>)) nil)
($test (subclassp (class <end-of-stream>) (class <simple-error>)) nil)
($test (subclassp (class <end-of-stream>) (class <stream-error>)) t)
($test (subclassp (class <end-of-stream>) (class <end-of-stream>)) nil)
($test (subclassp (class <end-of-stream>) (class <storage-exhausted>)) nil)
($test (subclassp (class <end-of-stream>) (class <standard-class>)) nil)
($test (subclassp (class <end-of-stream>) (class <standard-object>)) nil)
($test (subclassp (class <end-of-stream>) (class <stream>)) nil)
;; <storage-exhausted>
($test (subclassp (class <storage-exhausted>) (class <object>)) t)
($test (subclassp (class <storage-exhausted>) (class <basic-array>)) nil)
($test (subclassp (class <storage-exhausted>) (class <basic-array*>)) nil)
($test (subclassp (class <storage-exhausted>) (class <general-array*>)) nil)
($test (subclassp (class <storage-exhausted>) (class <basic-vector>)) nil)
($test (subclassp (class <storage-exhausted>) (class <general-vector>)) nil)
($test (subclassp (class <storage-exhausted>) (class <string>)) nil)
($test (subclassp (class <storage-exhausted>) (class <built-in-class>)) nil)
($test (subclassp (class <storage-exhausted>) (class <character>)) nil)
($test (subclassp (class <storage-exhausted>) (class <function>)) nil)
($test (subclassp (class <storage-exhausted>) (class <generic-function>)) nil)
($test (subclassp (class <storage-exhausted>) (class <standard-generic-function>)) nil)
($test (subclassp (class <storage-exhausted>) (class <list>)) nil)
($test (subclassp (class <storage-exhausted>) (class <cons>)) nil)
($test (subclassp (class <storage-exhausted>) (class <null>)) nil)
($test (subclassp (class <storage-exhausted>) (class <symbol>)) nil)
($test (subclassp (class <storage-exhausted>) (class <number>)) nil)
($test (subclassp (class <storage-exhausted>) (class <float>)) nil)
($test (subclassp (class <storage-exhausted>) (class <integer>)) nil)
($test (subclassp (class <storage-exhausted>) (class <serious-condition>)) t)
($test (subclassp (class <storage-exhausted>) (class <error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <arithmetic-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <division-by-zero>)) nil)
($test (subclassp (class <storage-exhausted>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <storage-exhausted>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <storage-exhausted>) (class <control-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <parse-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <program-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <domain-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <undefined-entity>)) nil)
($test (subclassp (class <storage-exhausted>) (class <unbound-variable>)) nil)
($test (subclassp (class <storage-exhausted>) (class <undefined-function>)) nil)
($test (subclassp (class <storage-exhausted>) (class <simple-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <stream-error>)) nil)
($test (subclassp (class <storage-exhausted>) (class <end-of-stream>)) nil)
($test (subclassp (class <storage-exhausted>) (class <storage-exhausted>)) nil)
($test (subclassp (class <storage-exhausted>) (class <standard-class>)) nil)
($test (subclassp (class <storage-exhausted>) (class <standard-object>)) nil)
($test (subclassp (class <storage-exhausted>) (class <stream>)) nil)
;; <standard-class>
($test (subclassp (class <standard-class>) (class <object>)) t)
($test (subclassp (class <standard-class>) (class <basic-array>)) nil)
($test (subclassp (class <standard-class>) (class <basic-array*>)) nil)
($test (subclassp (class <standard-class>) (class <general-array*>)) nil)
($test (subclassp (class <standard-class>) (class <basic-vector>)) nil)
($test (subclassp (class <standard-class>) (class <general-vector>)) nil)
($test (subclassp (class <standard-class>) (class <string>)) nil)
($test (subclassp (class <standard-class>) (class <built-in-class>)) nil)
($test (subclassp (class <standard-class>) (class <character>)) nil)
($test (subclassp (class <standard-class>) (class <function>)) nil)
($test (subclassp (class <standard-class>) (class <generic-function>)) nil)
($test (subclassp (class <standard-class>) (class <standard-generic-function>)) nil)
($test (subclassp (class <standard-class>) (class <list>)) nil)
($test (subclassp (class <standard-class>) (class <cons>)) nil)
($test (subclassp (class <standard-class>) (class <null>)) nil)
($test (subclassp (class <standard-class>) (class <symbol>)) nil)
($test (subclassp (class <standard-class>) (class <number>)) nil)
($test (subclassp (class <standard-class>) (class <float>)) nil)
($test (subclassp (class <standard-class>) (class <integer>)) nil)
($test (subclassp (class <standard-class>) (class <serious-condition>)) nil)
($test (subclassp (class <standard-class>) (class <error>)) nil)
($test (subclassp (class <standard-class>) (class <arithmetic-error>)) nil)
($test (subclassp (class <standard-class>) (class <division-by-zero>)) nil)
($test (subclassp (class <standard-class>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <standard-class>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <standard-class>) (class <control-error>)) nil)
($test (subclassp (class <standard-class>) (class <parse-error>)) nil)
($test (subclassp (class <standard-class>) (class <program-error>)) nil)
($test (subclassp (class <standard-class>) (class <domain-error>)) nil)
($test (subclassp (class <standard-class>) (class <undefined-entity>)) nil)
($test (subclassp (class <standard-class>) (class <unbound-variable>)) nil)
($test (subclassp (class <standard-class>) (class <undefined-function>)) nil)
($test (subclassp (class <standard-class>) (class <simple-error>)) nil)
($test (subclassp (class <standard-class>) (class <stream-error>)) nil)
($test (subclassp (class <standard-class>) (class <end-of-stream>)) nil)
($test (subclassp (class <standard-class>) (class <storage-exhausted>)) nil)
($test (subclassp (class <standard-class>) (class <standard-class>)) nil)
($test (subclassp (class <standard-class>) (class <standard-object>)) nil)
($test (subclassp (class <standard-class>) (class <stream>)) nil)
;; <standard-object>
($test (subclassp (class <standard-object>) (class <object>)) t)
($test (subclassp (class <standard-object>) (class <basic-array>)) nil)
($test (subclassp (class <standard-object>) (class <basic-array*>)) nil)
($test (subclassp (class <standard-object>) (class <general-array*>)) nil)
($test (subclassp (class <standard-object>) (class <basic-vector>)) nil)
($test (subclassp (class <standard-object>) (class <general-vector>)) nil)
($test (subclassp (class <standard-object>) (class <string>)) nil)
($test (subclassp (class <standard-object>) (class <built-in-class>)) nil)
($test (subclassp (class <standard-object>) (class <character>)) nil)
($test (subclassp (class <standard-object>) (class <function>)) nil)
($test (subclassp (class <standard-object>) (class <generic-function>)) nil)
($test (subclassp (class <standard-object>) (class <standard-generic-function>)) nil)
($test (subclassp (class <standard-object>) (class <list>)) nil)
($test (subclassp (class <standard-object>) (class <cons>)) nil)
($test (subclassp (class <standard-object>) (class <null>)) nil)
($test (subclassp (class <standard-object>) (class <symbol>)) nil)
($test (subclassp (class <standard-object>) (class <number>)) nil)
($test (subclassp (class <standard-object>) (class <float>)) nil)
($test (subclassp (class <standard-object>) (class <integer>)) nil)
($test (subclassp (class <standard-object>) (class <serious-condition>)) nil)
($test (subclassp (class <standard-object>) (class <error>)) nil)
($test (subclassp (class <standard-object>) (class <arithmetic-error>)) nil)
($test (subclassp (class <standard-object>) (class <division-by-zero>)) nil)
($test (subclassp (class <standard-object>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <standard-object>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <standard-object>) (class <control-error>)) nil)
($test (subclassp (class <standard-object>) (class <parse-error>)) nil)
($test (subclassp (class <standard-object>) (class <program-error>)) nil)
($test (subclassp (class <standard-object>) (class <domain-error>)) nil)
($test (subclassp (class <standard-object>) (class <undefined-entity>)) nil)
($test (subclassp (class <standard-object>) (class <unbound-variable>)) nil)
($test (subclassp (class <standard-object>) (class <undefined-function>)) nil)
($test (subclassp (class <standard-object>) (class <simple-error>)) nil)
($test (subclassp (class <standard-object>) (class <stream-error>)) nil)
($test (subclassp (class <standard-object>) (class <end-of-stream>)) nil)
($test (subclassp (class <standard-object>) (class <storage-exhausted>)) nil)
($test (subclassp (class <standard-object>) (class <standard-class>)) nil)
($test (subclassp (class <standard-object>) (class <standard-object>)) nil)
($test (subclassp (class <standard-object>) (class <stream>)) nil)
;; <stream>
($test (subclassp (class <stream>) (class <object>)) t)
($test (subclassp (class <stream>) (class <basic-array>)) nil)
($test (subclassp (class <stream>) (class <basic-array*>)) nil)
($test (subclassp (class <stream>) (class <general-array*>)) nil)
($test (subclassp (class <stream>) (class <basic-vector>)) nil)
($test (subclassp (class <stream>) (class <general-vector>)) nil)
($test (subclassp (class <stream>) (class <string>)) nil)
($test (subclassp (class <stream>) (class <built-in-class>)) nil)
($test (subclassp (class <stream>) (class <character>)) nil)
($test (subclassp (class <stream>) (class <function>)) nil)
($test (subclassp (class <stream>) (class <generic-function>)) nil)
($test (subclassp (class <stream>) (class <standard-generic-function>)) nil)
($test (subclassp (class <stream>) (class <list>)) nil)
($test (subclassp (class <stream>) (class <cons>)) nil)
($test (subclassp (class <stream>) (class <null>)) nil)
($test (subclassp (class <stream>) (class <symbol>)) nil)
($test (subclassp (class <stream>) (class <number>)) nil)
($test (subclassp (class <stream>) (class <float>)) nil)
($test (subclassp (class <stream>) (class <integer>)) nil)
($test (subclassp (class <stream>) (class <serious-condition>)) nil)
($test (subclassp (class <stream>) (class <error>)) nil)
($test (subclassp (class <stream>) (class <arithmetic-error>)) nil)
($test (subclassp (class <stream>) (class <division-by-zero>)) nil)
($test (subclassp (class <stream>) (class <floating-point-overflow>)) nil)
($test (subclassp (class <stream>) (class <floating-point-underflow>)) nil)
($test (subclassp (class <stream>) (class <control-error>)) nil)
($test (subclassp (class <stream>) (class <parse-error>)) nil)
($test (subclassp (class <stream>) (class <program-error>)) nil)
($test (subclassp (class <stream>) (class <domain-error>)) nil)
($test (subclassp (class <stream>) (class <undefined-entity>)) nil)
($test (subclassp (class <stream>) (class <unbound-variable>)) nil)
($test (subclassp (class <stream>) (class <undefined-function>)) nil)
($test (subclassp (class <stream>) (class <simple-error>)) nil)
($test (subclassp (class <stream>) (class <stream-error>)) nil)
($test (subclassp (class <stream>) (class <end-of-stream>)) nil)
($test (subclassp (class <stream>) (class <storage-exhausted>)) nil)
($test (subclassp (class <stream>) (class <standard-class>)) nil)
($test (subclassp (class <stream>) (class <standard-object>)) nil)
($test (subclassp (class <stream>) (class <stream>)) nil)

;;
;; c11111 --+
;; c22222 --+-- c55555 --+
;; c33333 ---------------+
;; c44444 -----------+-- c66666
;;
($test (defclass c11111 () ()) c11111)
($test (defclass c22222 () ()) c22222)
($test (defclass c33333 () ()) c33333)
($test (defclass c44444 () ()) c44444)
($test (defclass c55555 (c11111 c22222) ()) c55555)
($test (defclass c66666 (c55555 c33333 c44444) ()) c66666)
($eval (defglobal c11111 (create (class c11111))))
($eval (defglobal c22222 (create (class c22222))))
($eval (defglobal c33333 (create (class c33333))))
($eval (defglobal c44444 (create (class c44444))))
($eval (defglobal c55555 (create (class c55555))))
($eval (defglobal c66666 (create (class c66666))))
;;
($test (subclassp (class c11111) (class <object>)) t)
($test (subclassp (class c11111) (class <standard-object>)) t)
($test (subclassp (class c11111) (class c11111)) nil)
($test (subclassp (class c11111) (class c22222)) nil)
($test (subclassp (class c11111) (class c33333)) nil)
($test (subclassp (class c11111) (class c44444)) nil)
($test (subclassp (class c11111) (class c55555)) nil)
($test (subclassp (class c11111) (class c66666)) nil)
;;
($test (subclassp (class c22222) (class <object>)) t)
($test (subclassp (class c22222) (class <standard-object>)) t)
($test (subclassp (class c22222) (class c11111)) nil)
($test (subclassp (class c22222) (class c22222)) nil)
($test (subclassp (class c22222) (class c33333)) nil)
($test (subclassp (class c22222) (class c44444)) nil)
($test (subclassp (class c22222) (class c55555)) nil)
($test (subclassp (class c22222) (class c66666)) nil)
;;
($test (subclassp (class c33333) (class <object>)) t)
($test (subclassp (class c33333) (class <standard-object>)) t)
($test (subclassp (class c33333) (class c11111)) nil)
($test (subclassp (class c33333) (class c22222)) nil)
($test (subclassp (class c33333) (class c33333)) nil)
($test (subclassp (class c33333) (class c44444)) nil)
($test (subclassp (class c33333) (class c55555)) nil)
($test (subclassp (class c33333) (class c66666)) nil)
;;
($test (subclassp (class c44444) (class <object>)) t)
($test (subclassp (class c44444) (class <standard-object>)) t)
($test (subclassp (class c44444) (class c11111)) nil)
($test (subclassp (class c44444) (class c22222)) nil)
($test (subclassp (class c44444) (class c33333)) nil)
($test (subclassp (class c44444) (class c44444)) nil)
($test (subclassp (class c44444) (class c55555)) nil)
($test (subclassp (class c44444) (class c66666)) nil)
;;
($test (subclassp (class c55555) (class <object>)) t)
($test (subclassp (class c55555) (class <standard-object>)) t)
($test (subclassp (class c55555) (class c11111)) t)
($test (subclassp (class c55555) (class c22222)) t)
($test (subclassp (class c55555) (class c33333)) nil)
($test (subclassp (class c55555) (class c44444)) nil)
($test (subclassp (class c55555) (class c55555)) nil)
($test (subclassp (class c55555) (class c66666)) nil)
;;
($test (subclassp (class c66666) (class <object>)) t)
($test (subclassp (class c66666) (class <standard-object>)) t)
($test (subclassp (class c66666) (class c11111)) t)
($test (subclassp (class c66666) (class c22222)) t)
($test (subclassp (class c66666) (class c33333)) t)
($test (subclassp (class c66666) (class c44444)) t)
($test (subclassp (class c66666) (class c55555)) t)
($test (subclassp (class c66666) (class c66666)) nil)

;;;------------------------------------------------------------
;;; [special operator]
;;;
;;;   (class class-name) --> <class>
;;;------------------------------------------------------------
($argc class 1 0 0)
($stype class ($symbol $null) :target)
;;
($error (class undef) <undefined-entity>)

