#
MACRO(checkGettext)
  IF(NOT GETTEXT_CHECKED)
    OPTION(GETTEXT "" ON)

    MESSAGE(STATUS "Checking for gettext")
    MESSAGE(STATUS "********************")
    ADD_LIBRARY(adm_gettext INTERFACE)
    FIND_PACKAGE(Intl)
    IF(Intl_FOUND)
      SET(HAVE_GETTEXT 1)
      IF(Intl_IS_BUILT_IN)
        MESSAGE(STATUS "libintl is built in")
      ELSE()
        MESSAGE(STATUS "Intl/Gettext version ${Intl_VERSION} found  ( lib = ${Intl_LIBRARIES} incl=${Intl_INCLUDE_DIRS})")
        If(MSVC)
          TARGET_LINK_LIBRARIES(adm_gettext INTERFACE Intl::Intl)
        ELSE()
          TARGET_LINK_LIBRARIES(adm_gettext INTERFACE ${Intl_LIBRARIES})
          TARGET_INCLUDE_DIRECTORIES(adm_gettext INTERFACE ${Intl_INCLUDE_DIRS})
        ENDIF()
      ENDIF()
    ELSE()
      MESSAGE(STATUS "Cannot find gettext/intl,trying harder")
      FIND_HEADER_AND_LIB(raw_INTL libintl.h intl)
      IF(raw_INTL_INCLUDE_DIR)
        MESSAGE(STATUS "Found as include=${raw_INTL_INCLUDE_DIR} , lib = intl (hardcoded)")
        TARGET_LINK_LIBRARIES(adm_gettext INTERFACE intl)
        TARGET_INCLUDE_DIRECTORIES(adm_gettext INTERFACE ${raw_INTL_INCLUDE_DIR})
        TARGET_LINK_DIRECTORIES(adm_gettext INTERFACE ${raw_INTL_LIBRARY_DIR})
      ENDIF()
      APPEND_SUMMARY_LIST("Miscellaneous" "gettext" "${HAVE_GETTEXT}")
    ENDIF()
    SET(GETTEXT_CHECKED 1)
  ENDIF()
ENDMACRO()
