/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.Optional;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.LegacyMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.SignalMessage;

public class PreKeySignalMessage
extends NativeHandleGuard.SimpleOwner
implements CiphertextMessage,
NativeHandleGuard.Owner {
    @Override
    protected void release(long nativeHandle) {
        Native.PreKeySignalMessage_Destroy(nativeHandle);
    }

    public PreKeySignalMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException, LegacyMessageException, InvalidKeyException {
        super(FilterExceptions.filterExceptions(InvalidMessageException.class, InvalidVersionException.class, LegacyMessageException.class, InvalidKeyException.class, () -> Native.PreKeySignalMessage_Deserialize(serialized)));
    }

    @CalledFromNative
    public PreKeySignalMessage(long nativeHandle) {
        super(nativeHandle);
    }

    public int getMessageVersion() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetVersion));
    }

    public IdentityKey getIdentityKey() {
        return new IdentityKey(FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetIdentityKey)));
    }

    public int getRegistrationId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetRegistrationId));
    }

    public Optional<Integer> getPreKeyId() {
        int pre_key = FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetPreKeyId));
        if (pre_key < 0) {
            return Optional.empty();
        }
        return Optional.of(pre_key);
    }

    public int getSignedPreKeyId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetSignedPreKeyId));
    }

    public ECPublicKey getBaseKey() {
        return new ECPublicKey(this.guardedMap(Native::PreKeySignalMessage_GetBaseKey));
    }

    public SignalMessage getWhisperMessage() {
        return new SignalMessage(this.guardedMap(Native::PreKeySignalMessage_GetSignalMessage));
    }

    @Override
    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeySignalMessage_GetSerialized));
    }

    @Override
    public int getType() {
        return 3;
    }
}

