/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InvalidObjectException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.asamk.signal.manager.storage.recipients.RecipientAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static ObjectMapper createStorageObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.PUBLIC_ONLY);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE});
        objectMapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        return objectMapper;
    }

    public static JsonNode getNotNullNode(JsonNode parent, String name) throws InvalidObjectException {
        JsonNode node = parent.get(name);
        if (node == null || node.isNull()) {
            throw new InvalidObjectException(String.format("Incorrect file format: expected parameter %s not found ", name));
        }
        return node;
    }

    public static RecipientAddress getRecipientAddressFromLegacyIdentifier(String identifier) {
        if (UuidUtil.isUuid((String)identifier)) {
            return new RecipientAddress(ServiceId.parseOrThrow((String)identifier));
        }
        return new RecipientAddress(Optional.empty(), Optional.of(identifier));
    }

    public static int getAccountIdType(ServiceIdType serviceIdType) {
        return switch (serviceIdType) {
            default -> throw new MatchException(null, null);
            case ServiceIdType.ACI -> 0;
            case ServiceIdType.PNI -> 1;
        };
    }

    public static <T> T executeQuerySingleRow(PreparedStatement statement, ResultSetMapper<T> mapper) throws SQLException {
        ResultSet resultSet = statement.executeQuery();
        if (!resultSet.next()) {
            throw new RuntimeException("Expected a row in result set, but none found.");
        }
        return mapper.apply(resultSet);
    }

    public static <T> Optional<T> executeQueryForOptional(PreparedStatement statement, ResultSetMapper<T> mapper) throws SQLException {
        ResultSet resultSet = statement.executeQuery();
        if (!resultSet.next()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(resultSet));
    }

    public static <T> Stream<T> executeQueryForStream(PreparedStatement statement, final ResultSetMapper<T> mapper) throws SQLException {
        final ResultSet resultSet = statement.executeQuery();
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                try {
                    if (!resultSet.next()) {
                        return false;
                    }
                    consumer.accept(mapper.apply(resultSet));
                    return true;
                }
                catch (SQLException e) {
                    logger.warn("Failed to read from database result", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }, false);
    }

    public static Long getIdMapper(ResultSet resultSet) throws SQLException {
        return resultSet.getLong("_id");
    }

    public static interface ResultSetMapper<T> {
        public T apply(ResultSet var1) throws SQLException;
    }
}

