/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.senderKeys;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.asamk.signal.manager.helper.RecipientAddressResolver;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.storage.senderKeys.SenderKeySharedStore;
import org.asamk.signal.manager.storage.senderKeys.SenderKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.push.ServiceId;

public class LegacySenderKeySharedStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacySenderKeySharedStore.class);

    public static void migrate(File file, RecipientResolver resolver, RecipientAddressResolver addressResolver, SenderKeyStore senderKeyStore) {
        ObjectMapper objectMapper = Utils.createStorageObjectMapper();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Storage storage = (Storage)objectMapper.readValue((InputStream)inputStream, Storage.class);
            HashMap<DistributionId, Set<SenderKeySharedStore.SenderKeySharedEntry>> sharedSenderKeys = new HashMap<DistributionId, Set<SenderKeySharedStore.SenderKeySharedEntry>>();
            for (Storage.SharedSenderKey senderKey : storage.sharedSenderKeys) {
                Optional<ServiceId> serviceId;
                RecipientId recipientId = resolver.resolveRecipient(senderKey.recipientId);
                if (recipientId == null || (serviceId = addressResolver.resolveRecipientAddress(recipientId).serviceId()).isEmpty()) continue;
                SenderKeySharedStore.SenderKeySharedEntry entry = new SenderKeySharedStore.SenderKeySharedEntry(serviceId.get().toString(), senderKey.deviceId);
                DistributionId distributionId = DistributionId.from((String)senderKey.distributionId);
                Set<SenderKeySharedStore.SenderKeySharedEntry> entries = sharedSenderKeys.get(distributionId);
                if (entries == null) {
                    entries = new HashSet<SenderKeySharedStore.SenderKeySharedEntry>();
                }
                entries.add(entry);
                sharedSenderKeys.put(distributionId, entries);
            }
            senderKeyStore.addLegacySenderKeysShared(sharedSenderKeys);
        }
        catch (IOException e) {
            logger.info("Failed to load shared sender key store, ignoring", (Throwable)e);
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            logger.info("Failed to load shared sender key store, ignoring", (Throwable)e);
        }
    }

    public record Storage(List<SharedSenderKey> sharedSenderKeys) {

        public record SharedSenderKey(long recipientId, int deviceId, String distributionId) {
        }
    }
}

