/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Identity;
import org.asamk.signal.manager.api.RecipientAddress;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.DateUtils;
import org.asamk.signal.util.Hex;
import org.asamk.signal.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListIdentitiesCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(ListIdentitiesCommand.class);

    @Override
    public String getName() {
        return "listIdentities";
    }

    private static void printIdentityFingerprint(PlainTextWriter writer, Identity theirId) {
        writer.println("{}: {} Added: {} Fingerprint: {} Safety Number: {}", theirId.recipient().getLegacyIdentifier(), theirId.trustLevel(), DateUtils.formatTimestamp(theirId.dateAddedTimestamp()), Hex.toString(theirId.fingerprint()), Util.formatSafetyNumber(theirId.safetyNumber()));
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("List all known identity keys and their trust status, fingerprint and safety number.");
        subparser.addArgument(new String[]{"-n", "--number"}).help("Only show identity keys for the given phone number.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String number = ns.getString("number");
        List identities = number == null ? m.getIdentities() : m.getIdentities(CommandUtil.getSingleRecipientIdentifier(number, m.getSelfNumber()));
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                for (Identity id2 : identities) {
                    ListIdentitiesCommand.printIdentityFingerprint(writer, id2);
                }
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonIdentity> jsonIdentities = identities.stream().map(id -> {
                    RecipientAddress address = id.recipient();
                    String safetyNumber = Util.formatSafetyNumber(id.safetyNumber());
                    byte[] scannableSafetyNumber = id.scannableSafetyNumber();
                    return new JsonIdentity(address.number().orElse(null), address.uuid().map(UUID::toString).orElse(null), Hex.toString(id.fingerprint()), safetyNumber, scannableSafetyNumber == null ? null : Base64.getEncoder().encodeToString(scannableSafetyNumber), id.trustLevel().name(), id.dateAddedTimestamp());
                }).toList();
                writer.write(jsonIdentities);
            }
        }
    }

    private record JsonIdentity(String number, String uuid, String fingerprint, String safetyNumber, String scannableSafetyNumber, String trustLevel, long addedTimestamp) {
    }
}

