/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import java.util.HashMap;
import org.asamk.signal.json.JsonError;
import org.asamk.signal.json.JsonMessageEnvelope;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.output.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReceiveMessageHandler
implements Manager.ReceiveMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsonReceiveMessageHandler.class);
    private final Manager m;
    private final JsonWriter jsonWriter;

    public JsonReceiveMessageHandler(Manager m, JsonWriter jsonWriter) {
        this.m = m;
        this.jsonWriter = jsonWriter;
    }

    public void handleMessage(MessageEnvelope envelope, Throwable exception) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put("account", this.m.getSelfNumber());
        if (exception != null) {
            object.put("exception", JsonError.from(exception));
        }
        if (envelope != null) {
            object.put("envelope", JsonMessageEnvelope.from(envelope, exception, this.m));
        }
        this.jsonWriter.write(object);
    }
}

