/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0\u001dJ\u001c\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\u0011\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\b\u0010+\u001a\u00020 H\u0016J\u0013\u0010,\u001a\u00020$2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010-\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/signal/core/util/ByteSize;", "", "bytes", "", "<init>", "(J)V", "getBytes", "()J", "inWholeBytes", "getInWholeBytes", "inWholeKibiBytes", "getInWholeKibiBytes", "inWholeMebiBytes", "getInWholeMebiBytes", "inWholeGibiBytes", "getInWholeGibiBytes", "inWholeTebiBytes", "getInWholeTebiBytes", "inKibiBytes", "", "getInKibiBytes", "()F", "inMebiBytes", "getInMebiBytes", "inGibiBytes", "getInGibiBytes", "inTebiBytes", "getInTebiBytes", "getLargestNonZeroValue", "Lkotlin/Pair;", "Lorg/signal/core/util/ByteSize$Size;", "toUnitString", "", "maxPlaces", "", "spaced", "", "compareTo", "other", "plus", "percentageOf", "minus", "times", "toString", "equals", "hashCode", "Size", "core-util-jvm"})
public final class ByteSize {
    private final long bytes;

    public ByteSize(long bytes) {
        this.bytes = bytes;
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final long getInWholeBytes() {
        return this.bytes;
    }

    public final long getInWholeKibiBytes() {
        return this.bytes / 1024L;
    }

    public final long getInWholeMebiBytes() {
        return this.getInWholeKibiBytes() / 1024L;
    }

    public final long getInWholeGibiBytes() {
        return this.getInWholeMebiBytes() / 1024L;
    }

    public final long getInWholeTebiBytes() {
        return this.getInWholeGibiBytes() / 1024L;
    }

    public final float getInKibiBytes() {
        return (float)this.bytes / 1024.0f;
    }

    public final float getInMebiBytes() {
        return this.getInKibiBytes() / 1024.0f;
    }

    public final float getInGibiBytes() {
        return this.getInMebiBytes() / 1024.0f;
    }

    public final float getInTebiBytes() {
        return this.getInGibiBytes() / 1024.0f;
    }

    @NotNull
    public final Pair<Float, Size> getLargestNonZeroValue() {
        return this.getInWholeTebiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInTebiBytes()), (Object)((Object)Size.TEBIBYTE)) : (this.getInWholeGibiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInGibiBytes()), (Object)((Object)Size.GIBIBYTE)) : (this.getInWholeMebiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInMebiBytes()), (Object)((Object)Size.MEBIBYTE)) : (this.getInWholeKibiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInKibiBytes()), (Object)((Object)Size.KIBIBYTE)) : TuplesKt.to((Object)Float.valueOf(this.getInWholeBytes()), (Object)((Object)Size.BYTE)))));
    }

    @JvmOverloads
    @NotNull
    public final String toUnitString(int maxPlaces, boolean spaced) {
        NumberFormat numberFormat;
        Pair<Float, Size> pair = this.getLargestNonZeroValue();
        float size = ((Number)pair.component1()).floatValue();
        Size unit = (Size)((Object)pair.component2());
        NumberFormat $this$toUnitString_u24lambda_u240 = numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        $this$toUnitString_u24lambda_u240.setMinimumFractionDigits(0);
        $this$toUnitString_u24lambda_u240.setMaximumFractionDigits(switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1, 2 -> 0;
            case 3 -> Math.min(1, maxPlaces);
            case 4, 5 -> Math.min(2, maxPlaces);
            default -> throw new NoWhenBranchMatchedException();
        });
        NumberFormat formatter = numberFormat;
        return formatter.format(Float.valueOf(size)) + (spaced ? " " : "") + unit.getLabel();
    }

    public static /* synthetic */ String toUnitString$default(ByteSize byteSize, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return byteSize.toUnitString(n, bl);
    }

    public final int compareTo(@NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.bytes, (long)other.bytes);
    }

    @NotNull
    public final ByteSize plus(@NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new ByteSize(this.getInWholeBytes() + other.getInWholeBytes());
    }

    public final float percentageOf(@NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)this.getInWholeBytes() / (float)other.getInWholeBytes();
    }

    @NotNull
    public final ByteSize minus(@NotNull ByteSize other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new ByteSize(this.getInWholeBytes() - other.getInWholeBytes());
    }

    @NotNull
    public final ByteSize times(long other) {
        return new ByteSize(this.getInWholeBytes() * other);
    }

    @NotNull
    public String toString() {
        return "ByteSize(" + this.toUnitString(4, false) + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.signal.core.util.ByteSize");
        ByteSize cfr_ignored_0 = (ByteSize)other;
        return this.bytes == ((ByteSize)other).bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }

    @JvmOverloads
    @NotNull
    public final String toUnitString(int maxPlaces) {
        return ByteSize.toUnitString$default(this, maxPlaces, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final String toUnitString() {
        return ByteSize.toUnitString$default(this, 0, false, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/signal/core/util/ByteSize$Size;", "", "label", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "BYTE", "KIBIBYTE", "MEBIBYTE", "GIBIBYTE", "TEBIBYTE", "core-util-jvm"})
    public static final class Size
    extends Enum<Size> {
        @NotNull
        private final String label;
        public static final /* enum */ Size BYTE = new Size("B");
        public static final /* enum */ Size KIBIBYTE = new Size("KB");
        public static final /* enum */ Size MEBIBYTE = new Size("MB");
        public static final /* enum */ Size GIBIBYTE = new Size("GB");
        public static final /* enum */ Size TEBIBYTE = new Size("TB");
        private static final /* synthetic */ Size[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Size(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static Size[] values() {
            return (Size[])$VALUES.clone();
        }

        public static Size valueOf(String value) {
            return Enum.valueOf(Size.class, value);
        }

        @NotNull
        public static EnumEntries<Size> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sizeArray = new Size[]{Size.BYTE, Size.KIBIBYTE, Size.MEBIBYTE, Size.GIBIBYTE, Size.TEBIBYTE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Size.values().length];
            try {
                nArray[Size.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.KIBIBYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.MEBIBYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.GIBIBYTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.TEBIBYTE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

