/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.util.HashMap;
import java.util.Map;

public enum ContentHint {
    DEFAULT(0),
    RESENDABLE(1),
    IMPLICIT(2);

    private static final Map<Integer, ContentHint> TYPE_MAP;
    private final int type;

    private ContentHint(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static ContentHint fromType(int type) {
        return TYPE_MAP.getOrDefault(type, DEFAULT);
    }

    static {
        TYPE_MAP = new HashMap<Integer, ContentHint>();
        for (ContentHint value : ContentHint.values()) {
            TYPE_MAP.put(value.getType(), value);
        }
    }
}

