/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.util.UUID;
import org.signal.libsignal.protocol.SignalProtocolAddress;
import org.signal.libsignal.protocol.groups.GroupSessionBuilder;
import org.signal.libsignal.protocol.message.SenderKeyDistributionMessage;
import org.whispersystems.signalservice.api.SignalSessionLock;

public class SignalGroupSessionBuilder {
    private final SignalSessionLock lock;
    private final GroupSessionBuilder builder;

    public SignalGroupSessionBuilder(SignalSessionLock lock, GroupSessionBuilder builder) {
        this.lock = lock;
        this.builder = builder;
    }

    public void process(SignalProtocolAddress sender, SenderKeyDistributionMessage senderKeyDistributionMessage) {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            this.builder.process(sender, senderKeyDistributionMessage);
        }
    }

    public SenderKeyDistributionMessage create(SignalProtocolAddress sender, UUID distributionId) {
        try (SignalSessionLock.Lock unused = this.lock.acquire();){
            SenderKeyDistributionMessage senderKeyDistributionMessage = this.builder.create(sender, distributionId);
            return senderKeyDistributionMessage;
        }
    }
}

