/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.push;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import org.signal.core.util.Base64;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.whispersystems.signalservice.internal.push.PreKeyEntity;

public class SignedPreKeyEntity
extends PreKeyEntity {
    @JsonProperty
    @JsonSerialize(using=ByteArraySerializer.class)
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    private byte[] signature;

    public SignedPreKeyEntity() {
    }

    public SignedPreKeyEntity(int keyId, ECPublicKey publicKey, byte[] signature) {
        super(keyId, publicKey);
        this.signature = signature;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    private static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Base64.decode((String)p.getValueAsString());
        }
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.encodeWithoutPadding((byte[])value));
        }
    }
}

