/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;
import okio.ByteString;
import org.signal.core.util.Base64;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class JsonUtil {
    private static final String TAG = JsonUtil.class.getSimpleName();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            Log.w((String)TAG, (Throwable)e);
            return "";
        }
    }

    @Nonnull
    public static ByteString toJsonByteString(@Nonnull Object object) {
        return ByteString.of((byte[])JsonUtil.toJson(object).getBytes());
    }

    public static <T> T fromJson(String json, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) throws IOException {
        return (T)objectMapper.readValue(json, typeRef);
    }

    public static <T> T fromJson(byte[] json, Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(json, clazz);
    }

    public static <T> T fromJsonResponse(String json, TypeReference<T> typeRef) throws MalformedResponseException {
        try {
            return JsonUtil.fromJson(json, typeRef);
        }
        catch (IOException e) {
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public static <T> T fromJsonResponse(String body, Class<T> clazz) throws MalformedResponseException {
        try {
            return JsonUtil.fromJson(body, clazz);
        }
        catch (IOException e) {
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    public static <T> T fromJsonResponse(byte[] body, Class<T> clazz) throws MalformedResponseException {
        try {
            return JsonUtil.fromJson(body, clazz);
        }
        catch (IOException e) {
            throw new MalformedResponseException("Unable to parse entity", e);
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule((Module)new KotlinModule.Builder().build());
    }

    public static class MasterKeyDeserializer
    extends JsonDeserializer<MasterKey> {
        public MasterKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new MasterKey(Base64.decode((String)p.getValueAsString()));
        }
    }

    public static class MasterKeySerializer
    extends JsonSerializer<MasterKey> {
        public void serialize(MasterKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.encodeWithPadding((byte[])value.serialize()));
        }
    }

    public static class ServiceIdDeserializer
    extends JsonDeserializer<ServiceId> {
        public ServiceId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return ServiceId.parseOrNull(p.getValueAsString());
        }
    }

    public static class ServiceIdSerializer
    extends JsonSerializer<ServiceId> {
        public void serialize(ServiceId value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }

    public static class AciDeserializer
    extends JsonDeserializer<ServiceId.ACI> {
        public ServiceId.ACI deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return ServiceId.ACI.parseOrNull(p.getValueAsString());
        }
    }

    public static class AciSerializer
    extends JsonSerializer<ServiceId.ACI> {
        public void serialize(ServiceId.ACI value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }

    public static class UuidDeserializer
    extends JsonDeserializer<UUID> {
        public UUID deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return UuidUtil.parseOrNull(p.getValueAsString());
        }
    }

    public static class UuidSerializer
    extends JsonSerializer<UUID> {
        public void serialize(UUID value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toString());
        }
    }

    public static class IdentityKeyDeserializer
    extends JsonDeserializer<IdentityKey> {
        public IdentityKey deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new IdentityKey(Base64.decode((String)p.getValueAsString()), 0);
            }
            catch (InvalidKeyException e) {
                throw new IOException(e);
            }
        }
    }

    public static class IdentityKeySerializer
    extends JsonSerializer<IdentityKey> {
        public void serialize(IdentityKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Base64.encodeWithoutPadding((byte[])value.serialize()));
        }
    }
}

