/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.util;

public final class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static byte[] xor(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new AssertionError((Object)"XOR length mismatch");
        }
        byte[] out = new byte[a.length];
        for (int i = a.length - 1; i >= 0; --i) {
            out[i] = (byte)(a[i] ^ b[i]);
        }
        return out;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] result2 = new byte[a.length + b.length];
        System.arraycopy(a, 0, result2, 0, a.length);
        System.arraycopy(b, 0, result2, a.length, b.length);
        return result2;
    }
}

