/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PrintAction
extends WorkbenchPartAction {
    public PrintAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected boolean calculateEnabled() {
        PrinterData[] printers = Printer.getPrinterList();
        return printers != null && printers.length > 0;
    }

    @Override
    protected void init() {
        super.init();
        this.setText(GEFMessages.PrintAction_Label);
        this.setToolTipText(GEFMessages.PrintAction_Tooltip);
        this.setId(ActionFactory.PRINT.getId());
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null) {
            PrintGraphicalViewerOperation op = new PrintGraphicalViewerOperation(new Printer(data), viewer);
            op.run(this.getWorkbenchPart().getTitle());
        }
    }
}

