/*******************************************************************************
    Copyright (c) 2025, NVIDIA CORPORATION. All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

*******************************************************************************/

#ifndef __CLCDC0QMD_H__
#define __CLCDC0QMD_H__

/*
** Queue Meta Data, Version 05_00
 */

#define NVCDC0_QMDV05_00_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(29:0)
#define NVCDC0_QMDV05_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(30:30)
#define NVCDC0_QMDV05_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVCDC0_QMDV05_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVCDC0_QMDV05_00_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(31:31)
#define NVCDC0_QMDV05_00_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(63:32)
#define NVCDC0_QMDV05_00_INNER_GET                                 MW(94:64)
#define NVCDC0_QMDV05_00_INNER_OVERFLOW                            MW(95:95)
#define NVCDC0_QMDV05_00_INNER_PUT                                 MW(126:96)
#define NVCDC0_QMDV05_00_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVCDC0_QMDV05_00_DEPENDENCE_COUNTER                        MW(143:128)
#define NVCDC0_QMDV05_00_QMD_GROUP_ID                              MW(149:144)
#define NVCDC0_QMDV05_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(150:150)
#define NVCDC0_QMDV05_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVCDC0_QMDV05_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVCDC0_QMDV05_00_QMD_TYPE                                  MW(153:151)
#define NVCDC0_QMDV05_00_QMD_TYPE_QUEUE                            0x00000000
#define NVCDC0_QMDV05_00_QMD_TYPE_GRID_NULL                        0x00000001
#define NVCDC0_QMDV05_00_QMD_TYPE_GRID_CTA                         0x00000002
#define NVCDC0_QMDV05_00_QMD_TYPE_GRID_GPC_CGA                     0x00000003
#define NVCDC0_QMDV05_00_QMD_TYPE_GRID_GPU_CGA                     0x00000004
#define NVCDC0_QMDV05_00_QMD_TYPE_GRID_GPU_GPC_CGA                 0x00000005
#define NVCDC0_QMDV05_00_NUM_SUB_TASKS_PER_TASK                    MW(157:154)
#define NVCDC0_QMDV05_00_REQUIRE_SCHEDULING_PCAS                   MW(158:158)
#define NVCDC0_QMDV05_00_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVCDC0_QMDV05_00_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVCDC0_QMDV05_00_TPC_DISABLE_MASK_VALID                    MW(159:159)
#define NVCDC0_QMDV05_00_TPC_DISABLE_MASK_VALID_FALSE              0x00000000
#define NVCDC0_QMDV05_00_TPC_DISABLE_MASK_VALID_TRUE               0x00000001
#define NVCDC0_QMDV05_00_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVCDC0_QMDV05_00_HW_ONLY_DEPENDENCE_COUNTER                MW(207:192)
#define NVCDC0_QMDV05_00_RESUME_SUB_TASK_ID                        MW(210:208)
#define NVCDC0_QMDV05_00_COMPLETED_SUB_TASK_MASK                   MW(218:211)
#define NVCDC0_QMDV05_00_GRID_WIDTH_RESUME                         MW(255:224)
#define NVCDC0_QMDV05_00_GRID_HEIGHT_RESUME                        MW(271:256)
#define NVCDC0_QMDV05_00_GRID_DEPTH_RESUME                         MW(287:272)
#define NVCDC0_QMDV05_00_RELEASE_ENABLE(i)                         MW((288+(i)*16):(288+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_ENABLE_FALSE                      0x00000000
#define NVCDC0_QMDV05_00_RELEASE_ENABLE_TRUE                       0x00000001
#define NVCDC0_QMDV05_00_RELEASE_STRUCTURE_SIZE(i)                 MW((290+(i)*16):(289+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVCDC0_QMDV05_00_RELEASE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVCDC0_QMDV05_00_RELEASE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVCDC0_QMDV05_00_RELEASE_MEMBAR_TYPE(i)                    MW((291+(i)*16):(291+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVCDC0_QMDV05_00_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_ENABLE(i)               MW((292+(i)*16):(292+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP(i)                   MW((295+(i)*16):(293+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_ADD              0x00000000
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_MIN              0x00000001
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_MAX              0x00000002
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_INC              0x00000003
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_DEC              0x00000004
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_AND              0x00000005
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_OR               0x00000006
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_OP_RED_XOR              0x00000007
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_FORMAT(i)               MW((297+(i)*16):(296+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_FORMAT_UNSIGNED         0x00000000
#define NVCDC0_QMDV05_00_RELEASE_REDUCTION_FORMAT_SIGNED           0x00000001
#define NVCDC0_QMDV05_00_RELEASE_TRAP_TYPE(i)                      MW((299+(i)*16):(298+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_TRAP_TYPE_TRAP_NONE               0x00000000
#define NVCDC0_QMDV05_00_RELEASE_TRAP_TYPE_TRAP_UNCONDITIONAL      0x00000001
#define NVCDC0_QMDV05_00_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL        0x00000002
#define NVCDC0_QMDV05_00_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL_EXT    0x00000003
#define NVCDC0_QMDV05_00_RELEASE_PAYLOAD64B(i)                     MW((300+(i)*16):(300+(i)*16))
#define NVCDC0_QMDV05_00_RELEASE_PAYLOAD64B_FALSE                  0x00000000
#define NVCDC0_QMDV05_00_RELEASE_PAYLOAD64B_TRUE                   0x00000001
#define NVCDC0_QMDV05_00_RELEASE_RESERVED_INFO(i)                  MW((303+(i)*16):(301+(i)*16))
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ENABLE                     MW(336:336)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ENABLE_FALSE               0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ENABLE_TRUE                0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ACTION                     MW(339:337)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE        0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_PREFETCH                   MW(340:340)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_PREFETCH_FALSE             0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_PREFETCH_TRUE              0x00000001
#define NVCDC0_QMDV05_00_SELF_COPY_ON_COMPLETION                   MW(341:341)
#define NVCDC0_QMDV05_00_SELF_COPY_ON_COMPLETION_FALSE             0x00000000
#define NVCDC0_QMDV05_00_SELF_COPY_ON_COMPLETION_TRUE              0x00000001
#define NVCDC0_QMDV05_00_DEMOTE_L2_EVICT_LAST                      MW(342:342)
#define NVCDC0_QMDV05_00_DEMOTE_L2_EVICT_LAST_FALSE                0x00000000
#define NVCDC0_QMDV05_00_DEMOTE_L2_EVICT_LAST_TRUE                 0x00000001
#define NVCDC0_QMDV05_00_DISABLE_AUTO_INVALIDATE                   MW(343:343)
#define NVCDC0_QMDV05_00_DISABLE_AUTO_INVALIDATE_FALSE             0x00000000
#define NVCDC0_QMDV05_00_DISABLE_AUTO_INVALIDATE_TRUE              0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ENABLE                     MW(344:344)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ENABLE_FALSE               0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ENABLE_TRUE                0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ACTION                     MW(347:345)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE        0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_PREFETCH                   MW(348:348)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_PREFETCH_FALSE             0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_PREFETCH_TRUE              0x00000001
#define NVCDC0_QMDV05_00_CORRELATION_ID_INTERNAL                   MW(349:349)
#define NVCDC0_QMDV05_00_CORRELATION_ID_INTERNAL_FALSE             0x00000000
#define NVCDC0_QMDV05_00_CORRELATION_ID_INTERNAL_TRUE              0x00000001
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TASK_CHASING_ENABLE            MW(350:350)
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TASK_CHASING_ENABLE_FALSE      0x00000000
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TASK_CHASING_ENABLE_TRUE       0x00000001
#define NVCDC0_QMDV05_00_SHARED_ALLOCATION_ENABLE                  MW(351:351)
#define NVCDC0_QMDV05_00_SHARED_ALLOCATION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV05_00_SHARED_ALLOCATION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV05_00_CORRELATION_ID                            MW(383:352)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD0_POINTER                    MW(415:384)
#define NVCDC0_QMDV05_00_DEPENDENT_QMD1_POINTER                    MW(447:416)
#define NVCDC0_QMDV05_00_SASS_VERSION                              MW(455:448)
#define NVCDC0_QMDV05_00_API_VISIBLE_CALL_LIMIT                    MW(456:456)
#define NVCDC0_QMDV05_00_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVCDC0_QMDV05_00_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVCDC0_QMDV05_00_SAMPLER_INDEX                             MW(457:457)
#define NVCDC0_QMDV05_00_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVCDC0_QMDV05_00_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVCDC0_QMDV05_00_CONSTANT_BANK_PREFETCH_PRE_MAX_SIZE_SHIFTED8 MW(463:458)
#define NVCDC0_QMDV05_00_QMD_MINOR_VERSION                         MW(467:464)
#define NVCDC0_QMDV05_00_QMD_MAJOR_VERSION                         MW(471:468)
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_HEADER_CACHE           MW(472:472)
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(473:473)
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_DATA_CACHE             MW(474:474)
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_DATA_CACHE              MW(475:475)
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV05_00_INVALIDATE_INSTRUCTION_CACHE              MW(476:476)
#define NVCDC0_QMDV05_00_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_CONSTANT_CACHE          MW(477:477)
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV05_00_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE MW(478:478)
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE MW(479:479)
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE0_ADDR_LOWER             MW(511:480)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE0_ADDR_UPPER             MW(536:512)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE0_PAYLOAD_LOWER          MW(575:544)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE0_PAYLOAD_UPPER          MW(607:576)
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(615:608)
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_ID                    MW(621:616)
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(622:622)
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(623:623)
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_00_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TYPE                           MW(625:624)
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVCDC0_QMDV05_00_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE   MW(626:626)
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_00_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_00_CTA_LAUNCH_QUEUE                          MW(627:627)
#define NVCDC0_QMDV05_00_FREE_CTA_SLOTS_EMPTY_SM                   MW(635:628)
#define NVCDC0_QMDV05_00_SYNC_DOMAIN_ID                            MW(637:636)
#define NVCDC0_QMDV05_00_PRE_EXIT_AT_LAST_CTA_LAUNCH               MW(638:638)
#define NVCDC0_QMDV05_00_PRE_EXIT_AT_LAST_CTA_LAUNCH_FALSE         0x00000000
#define NVCDC0_QMDV05_00_PRE_EXIT_AT_LAST_CTA_LAUNCH_TRUE          0x00000001
#define NVCDC0_QMDV05_00_ENABLE_PROGRAM_PRE_EXIT                   MW(639:639)
#define NVCDC0_QMDV05_00_ENABLE_PROGRAM_PRE_EXIT_FALSE             0x00000000
#define NVCDC0_QMDV05_00_ENABLE_PROGRAM_PRE_EXIT_TRUE              0x00000001
#define NVCDC0_QMDV05_00_ARRIVE_AT_LATCH_ID                        MW(671:640)
#define NVCDC0_QMDV05_00_WAIT_ON_LATCH_ID                          MW(703:672)
#define NVCDC0_QMDV05_00_OCCUPANCY_THRESHOLD_SHARED_MEM            MW(721:714)
#define NVCDC0_QMDV05_00_OCCUPANCY_MAX_SHARED_MEM                  MW(729:722)
#define NVCDC0_QMDV05_00_ARRIVE_AT_LATCH_VALID                     MW(730:730)
#define NVCDC0_QMDV05_00_ARRIVE_AT_LATCH_VALID_FALSE               0x00000000
#define NVCDC0_QMDV05_00_ARRIVE_AT_LATCH_VALID_TRUE                0x00000001
#define NVCDC0_QMDV05_00_WAIT_ON_LATCH_VALID                       MW(731:731)
#define NVCDC0_QMDV05_00_WAIT_ON_LATCH_VALID_FALSE                 0x00000000
#define NVCDC0_QMDV05_00_WAIT_ON_LATCH_VALID_TRUE                  0x00000001
#define NVCDC0_QMDV05_00_LATCH_RELEASE_INVALIDATE_ENABLE           MW(732:732)
#define NVCDC0_QMDV05_00_LATCH_RELEASE_INVALIDATE_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_00_LATCH_RELEASE_INVALIDATE_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_00_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE MW(733:733)
#define NVCDC0_QMDV05_00_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE_FALSE 0x00000000
#define NVCDC0_QMDV05_00_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE_TRUE 0x00000001
#define NVCDC0_QMDV05_00_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE           MW(734:734)
#define NVCDC0_QMDV05_00_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE_FALSE     0x00000000
#define NVCDC0_QMDV05_00_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE_TRUE      0x00000001
#define NVCDC0_QMDV05_00_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE       MW(735:735)
#define NVCDC0_QMDV05_00_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE_FALSE 0x00000000
#define NVCDC0_QMDV05_00_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE_TRUE  0x00000001
#define NVCDC0_QMDV05_00_OCCUPANCY_THRESHOLD_WARP                  MW(743:736)
#define NVCDC0_QMDV05_00_OCCUPANCY_MAX_WARP                        MW(751:744)
#define NVCDC0_QMDV05_00_OCCUPANCY_THRESHOLD_REGISTER              MW(759:752)
#define NVCDC0_QMDV05_00_OCCUPANCY_MAX_REGISTER                    MW(767:760)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE1_ADDR_LOWER             MW(799:768)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE1_ADDR_UPPER             MW(824:800)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE1_PAYLOAD_LOWER          MW(863:832)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE1_PAYLOAD_UPPER          MW(895:864)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE2_ADDR_LOWER             MW(927:896)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE2_ADDR_UPPER             MW(952:928)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE2_PAYLOAD_LOWER          MW(991:960)
#define NVCDC0_QMDV05_00_RELEASE_SEMAPHORE2_PAYLOAD_UPPER          MW(1023:992)
#define NVCDC0_QMDV05_00_PROGRAM_ADDRESS_LOWER_SHIFTED4            MW(1055:1024)
#define NVCDC0_QMDV05_00_PROGRAM_ADDRESS_UPPER_SHIFTED4            MW(1076:1056)
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_SIZE                     MW(1085:1077)
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_TYPE                     MW(1087:1086)
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH     0x00000000
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_TYPE_PREFTECH_POST       0x00000001
#define NVCDC0_QMDV05_00_CTA_THREAD_DIMENSION0                     MW(1103:1088)
#define NVCDC0_QMDV05_00_CTA_THREAD_DIMENSION1                     MW(1119:1104)
#define NVCDC0_QMDV05_00_CTA_THREAD_DIMENSION2                     MW(1127:1120)
#define NVCDC0_QMDV05_00_REGISTER_COUNT                            MW(1136:1128)
#define NVCDC0_QMDV05_00_BARRIER_COUNT                             MW(1141:1137)
#define NVCDC0_QMDV05_00_ICC_PREFETCH_SIZE                         MW(1147:1142)
#define NVCDC0_QMDV05_00_SHARED_MEMORY_SIZE_SHIFTED7               MW(1162:1152)
#define NVCDC0_QMDV05_00_MIN_SM_CONFIG_SHARED_MEM_SIZE             MW(1168:1163)
#define NVCDC0_QMDV05_00_MAX_SM_CONFIG_SHARED_MEM_SIZE             MW(1174:1169)
#define NVCDC0_QMDV05_00_TARGET_SM_CONFIG_SHARED_MEM_SIZE          MW(1180:1175)
#define NVCDC0_QMDV05_00_SHARED_MEM_BARRIER_INIT_ENABLE            MW(1181:1181)
#define NVCDC0_QMDV05_00_SHADER_LOCAL_MEMORY_LOW_SIZE_SHIFTED4     MW(1199:1184)
#define NVCDC0_QMDV05_00_SHADER_LOCAL_MEMORY_HIGH_SIZE_SHIFTED4    MW(1215:1200)
#define NVCDC0_QMDV05_00_VIRTUAL_RESOURCE_COUNT                    MW(1223:1216)
#define NVCDC0_QMDV05_00_GRID_WIDTH                                MW(1279:1248)
#define NVCDC0_QMDV05_00_GRID_HEIGHT                               MW(1295:1280)
#define NVCDC0_QMDV05_00_GRID_DEPTH                                MW(1327:1312)
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_ADDR_LOWER_SHIFTED6(i)    MW((1375+(i)*64):(1344+(i)*64))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_ADDR_UPPER_SHIFTED6(i)    MW((1394+(i)*64):(1376+(i)*64))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1407+(i)*64):(1395+(i)*64))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_VALID(i)                  MW((1856+(i)*4):(1856+(i)*4))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_PREFETCH(i)               MW((1858+(i)*4):(1857+(i)*4))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_PREFETCH_PREFETCH_NONE    0x00000000
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_PREFETCH_PREFETCH_PRE     0x00000001
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_PREFETCH_PREFETCH_POST    0x00000002
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_INVALIDATE(i)             MW((1859+(i)*4):(1859+(i)*4))
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVCDC0_QMDV05_00_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED       MW(1919:1888)
#define NVCDC0_QMDV05_00_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED       MW(1936:1920)
#define NVCDC0_QMDV05_00_GPC_CGA_WIDTH                             MW(2053:2048)
#define NVCDC0_QMDV05_00_GPC_CGA_HEIGHT                            MW(2061:2056)
#define NVCDC0_QMDV05_00_GPC_CGA_DEPTH                             MW(2069:2064)
#define NVCDC0_QMDV05_00_LARGE_GPC_CGA_WIDTH_MINUS_ONE             MW(2075:2072)
#define NVCDC0_QMDV05_00_LARGE_GPC_CGA_HEIGHT_MINUS_ONE            MW(2079:2076)
#define NVCDC0_QMDV05_00_CGA_CTA_DISTRIBUTION_MODE                 MW(2111:2111)
#define NVCDC0_QMDV05_00_CGA_CTA_DISTRIBUTION_MODE_LOAD_BALANCING  0x00000000
#define NVCDC0_QMDV05_00_CGA_CTA_DISTRIBUTION_MODE_MULTI_CAST      0x00000001
#define NVCDC0_QMDV05_00_GPU_CGA_WIDTH                             MW(2127:2112)
#define NVCDC0_QMDV05_00_GPU_CGA_HEIGHT                            MW(2143:2128)
#define NVCDC0_QMDV05_00_GPU_CGA_DEPTH                             MW(2159:2144)
#define NVCDC0_QMDV05_00_DEBUG_ID_LOWER                            MW(2207:2176)
#define NVCDC0_QMDV05_00_DEBUG_ID_UPPER                            MW(2239:2208)
#define NVCDC0_QMDV05_00_TPC_DISABLE_MASK(i)                       MW((2271+(i)*32):(2240+(i)*32))
#define NVCDC0_QMDV05_00_INCOMPLETE_BOX_BASE_WIDTH_RESUME          MW(2527:2496)
#define NVCDC0_QMDV05_00_INCOMPLETE_BOX_BASE_HEIGHT_RESUME         MW(2543:2528)
#define NVCDC0_QMDV05_00_INCOMPLETE_BOX_BASE_DEPTH_RESUME          MW(2559:2544)
#define NVCDC0_QMDV05_00_INCOMPLETE_BOX_OFFSET_WIDTH_RESUME        MW(2563:2560)
#define NVCDC0_QMDV05_00_INCOMPLETE_BOX_OFFSET_HEIGHT_RESUME       MW(2567:2564)
#define NVCDC0_QMDV05_00_QUEUE_ENTRIES_PER_CTA_LOG2                MW(2596:2592)
#define NVCDC0_QMDV05_00_HW_ONLY_INNER_GET                         MW(2654:2624)
#define NVCDC0_QMDV05_00_HW_ONLY_INNER_PUT                         MW(2686:2656)
#define NVCDC0_QMDV05_00_OUTER_PUT                                 MW(3038:3008)
#define NVCDC0_QMDV05_00_OUTER_OVERFLOW                            MW(3039:3039)
#define NVCDC0_QMDV05_00_OUTER_GET                                 MW(3070:3040)
#define NVCDC0_QMDV05_00_OUTER_STICKY_OVERFLOW                     MW(3071:3071)


/*
** Queue Meta Data, Version 05_00 (inferred arrays)
 */

#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ENABLE(i)                   MW((336+(i)*8):(336+(i)*8))
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ENABLE_FALSE                0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ENABLE_TRUE                 0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ACTION(i)                   MW((339+(i)*8):(337+(i)*8))
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ACTION_QMD_INCREMENT_PUT    0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ACTION_QMD_SCHEDULE         0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_PREFETCH(i)                 MW((340+(i)*8):(340+(i)*8))
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_PREFETCH_FALSE              0x00000000
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_PREFETCH_TRUE               0x00000001
#define NVCDC0_QMDV05_00_DEPENDENT_QMD_POINTER(i)                  MW((415+(i)*32):(384+(i)*32))


/*
** Queue Meta Data, Version 05_01
 */

#define NVCDC0_QMDV05_01_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(29:0)
#define NVCDC0_QMDV05_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(30:30)
#define NVCDC0_QMDV05_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVCDC0_QMDV05_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVCDC0_QMDV05_01_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(31:31)
#define NVCDC0_QMDV05_01_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(63:32)
#define NVCDC0_QMDV05_01_INNER_GET                                 MW(94:64)
#define NVCDC0_QMDV05_01_INNER_OVERFLOW                            MW(95:95)
#define NVCDC0_QMDV05_01_INNER_PUT                                 MW(126:96)
#define NVCDC0_QMDV05_01_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVCDC0_QMDV05_01_DEPENDENCE_COUNTER                        MW(143:128)
#define NVCDC0_QMDV05_01_QMD_GROUP_ID                              MW(149:144)
#define NVCDC0_QMDV05_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(150:150)
#define NVCDC0_QMDV05_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVCDC0_QMDV05_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVCDC0_QMDV05_01_QMD_TYPE                                  MW(153:151)
#define NVCDC0_QMDV05_01_QMD_TYPE_QUEUE                            0x00000000
#define NVCDC0_QMDV05_01_QMD_TYPE_GRID_NULL                        0x00000001
#define NVCDC0_QMDV05_01_QMD_TYPE_GRID_CTA                         0x00000002
#define NVCDC0_QMDV05_01_QMD_TYPE_GRID_GPC_CGA                     0x00000003
#define NVCDC0_QMDV05_01_QMD_TYPE_GRID_GPU_CGA                     0x00000004
#define NVCDC0_QMDV05_01_QMD_TYPE_GRID_GPU_GPC_CGA                 0x00000005
#define NVCDC0_QMDV05_01_NUM_SUB_TASKS_PER_TASK                    MW(157:154)
#define NVCDC0_QMDV05_01_REQUIRE_SCHEDULING_PCAS                   MW(158:158)
#define NVCDC0_QMDV05_01_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVCDC0_QMDV05_01_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVCDC0_QMDV05_01_TPC_DISABLE_MASK_VALID                    MW(159:159)
#define NVCDC0_QMDV05_01_TPC_DISABLE_MASK_VALID_FALSE              0x00000000
#define NVCDC0_QMDV05_01_TPC_DISABLE_MASK_VALID_TRUE               0x00000001
#define NVCDC0_QMDV05_01_CIRCULAR_QUEUE_SIZE                       MW(184:160)
#define NVCDC0_QMDV05_01_HW_ONLY_DEPENDENCE_COUNTER                MW(207:192)
#define NVCDC0_QMDV05_01_RESUME_SUB_TASK_ID                        MW(210:208)
#define NVCDC0_QMDV05_01_COMPLETED_SUB_TASK_MASK                   MW(218:211)
#define NVCDC0_QMDV05_01_GRID_WIDTH_RESUME                         MW(255:224)
#define NVCDC0_QMDV05_01_GRID_HEIGHT_RESUME                        MW(271:256)
#define NVCDC0_QMDV05_01_GRID_DEPTH_RESUME                         MW(287:272)
#define NVCDC0_QMDV05_01_RELEASE_ENABLE(i)                         MW((288+(i)*16):(288+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_ENABLE_FALSE                      0x00000000
#define NVCDC0_QMDV05_01_RELEASE_ENABLE_TRUE                       0x00000001
#define NVCDC0_QMDV05_01_RELEASE_STRUCTURE_SIZE(i)                 MW((290+(i)*16):(289+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVCDC0_QMDV05_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVCDC0_QMDV05_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVCDC0_QMDV05_01_RELEASE_MEMBAR_TYPE(i)                    MW((291+(i)*16):(291+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVCDC0_QMDV05_01_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_ENABLE(i)               MW((292+(i)*16):(292+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP(i)                   MW((295+(i)*16):(293+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_ADD              0x00000000
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_MIN              0x00000001
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_MAX              0x00000002
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_INC              0x00000003
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_DEC              0x00000004
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_AND              0x00000005
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_OR               0x00000006
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_OP_RED_XOR              0x00000007
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_FORMAT(i)               MW((297+(i)*16):(296+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_FORMAT_UNSIGNED         0x00000000
#define NVCDC0_QMDV05_01_RELEASE_REDUCTION_FORMAT_SIGNED           0x00000001
#define NVCDC0_QMDV05_01_RELEASE_TRAP_TYPE(i)                      MW((299+(i)*16):(298+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_TRAP_TYPE_TRAP_NONE               0x00000000
#define NVCDC0_QMDV05_01_RELEASE_TRAP_TYPE_TRAP_UNCONDITIONAL      0x00000001
#define NVCDC0_QMDV05_01_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL        0x00000002
#define NVCDC0_QMDV05_01_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL_EXT    0x00000003
#define NVCDC0_QMDV05_01_RELEASE_PAYLOAD64B(i)                     MW((300+(i)*16):(300+(i)*16))
#define NVCDC0_QMDV05_01_RELEASE_PAYLOAD64B_FALSE                  0x00000000
#define NVCDC0_QMDV05_01_RELEASE_PAYLOAD64B_TRUE                   0x00000001
#define NVCDC0_QMDV05_01_RELEASE_RESERVED_INFO(i)                  MW((303+(i)*16):(301+(i)*16))
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ENABLE                     MW(336:336)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ENABLE_FALSE               0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ENABLE_TRUE                0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ACTION                     MW(339:337)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE        0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_PREFETCH                   MW(340:340)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_PREFETCH_FALSE             0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_PREFETCH_TRUE              0x00000001
#define NVCDC0_QMDV05_01_SELF_COPY_ON_COMPLETION                   MW(341:341)
#define NVCDC0_QMDV05_01_SELF_COPY_ON_COMPLETION_FALSE             0x00000000
#define NVCDC0_QMDV05_01_SELF_COPY_ON_COMPLETION_TRUE              0x00000001
#define NVCDC0_QMDV05_01_DEMOTE_L2_EVICT_LAST                      MW(342:342)
#define NVCDC0_QMDV05_01_DEMOTE_L2_EVICT_LAST_FALSE                0x00000000
#define NVCDC0_QMDV05_01_DEMOTE_L2_EVICT_LAST_TRUE                 0x00000001
#define NVCDC0_QMDV05_01_DISABLE_AUTO_INVALIDATE                   MW(343:343)
#define NVCDC0_QMDV05_01_DISABLE_AUTO_INVALIDATE_FALSE             0x00000000
#define NVCDC0_QMDV05_01_DISABLE_AUTO_INVALIDATE_TRUE              0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ENABLE                     MW(344:344)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ENABLE_FALSE               0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ENABLE_TRUE                0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ACTION                     MW(347:345)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT   0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE        0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_PREFETCH                   MW(348:348)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_PREFETCH_FALSE             0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_PREFETCH_TRUE              0x00000001
#define NVCDC0_QMDV05_01_CORRELATION_ID_INTERNAL                   MW(349:349)
#define NVCDC0_QMDV05_01_CORRELATION_ID_INTERNAL_FALSE             0x00000000
#define NVCDC0_QMDV05_01_CORRELATION_ID_INTERNAL_TRUE              0x00000001
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TASK_CHASING_ENABLE            MW(350:350)
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TASK_CHASING_ENABLE_FALSE      0x00000000
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TASK_CHASING_ENABLE_TRUE       0x00000001
#define NVCDC0_QMDV05_01_SHARED_ALLOCATION_ENABLE                  MW(351:351)
#define NVCDC0_QMDV05_01_SHARED_ALLOCATION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV05_01_SHARED_ALLOCATION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV05_01_CORRELATION_ID                            MW(383:352)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD0_POINTER                    MW(415:384)
#define NVCDC0_QMDV05_01_DEPENDENT_QMD1_POINTER                    MW(447:416)
#define NVCDC0_QMDV05_01_SASS_VERSION                              MW(455:448)
#define NVCDC0_QMDV05_01_API_VISIBLE_CALL_LIMIT                    MW(456:456)
#define NVCDC0_QMDV05_01_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVCDC0_QMDV05_01_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVCDC0_QMDV05_01_SAMPLER_INDEX                             MW(457:457)
#define NVCDC0_QMDV05_01_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVCDC0_QMDV05_01_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVCDC0_QMDV05_01_CONSTANT_BANK_PREFETCH_PRE_MAX_SIZE_SHIFTED8 MW(463:458)
#define NVCDC0_QMDV05_01_QMD_MINOR_VERSION                         MW(467:464)
#define NVCDC0_QMDV05_01_QMD_MAJOR_VERSION                         MW(471:468)
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_HEADER_CACHE           MW(472:472)
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(473:473)
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_DATA_CACHE             MW(474:474)
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_DATA_CACHE              MW(475:475)
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV05_01_INVALIDATE_INSTRUCTION_CACHE              MW(476:476)
#define NVCDC0_QMDV05_01_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_CONSTANT_CACHE          MW(477:477)
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV05_01_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE MW(478:478)
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE MW(479:479)
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_01_RELEASE_SEMAPHORE0_ADDR_LOWER             MW(511:480)
#define NVCDC0_QMDV05_01_RELEASE_SEMAPHORE0_ADDR_UPPER             MW(536:512)
#define NVCDC0_QMDV05_01_RELEASE_SEMAPHORE0_PAYLOAD_LOWER          MW(575:544)
#define NVCDC0_QMDV05_01_RELEASE_SEMAPHORE0_PAYLOAD_UPPER          MW(607:576)
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(615:608)
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_ID                    MW(621:616)
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(622:622)
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(623:623)
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_01_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TYPE                           MW(625:624)
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVCDC0_QMDV05_01_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE   MW(626:626)
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV05_01_LATCH_ACQUIRE_INVALIDATE_CONSTANT_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV05_01_CTA_LAUNCH_QUEUE                          MW(627:627)
#define NVCDC0_QMDV05_01_FREE_CTA_SLOTS_EMPTY_SM                   MW(635:628)
#define NVCDC0_QMDV05_01_SYNC_DOMAIN_ID                            MW(637:636)
#define NVCDC0_QMDV05_01_PRE_EXIT_AT_LAST_CTA_LAUNCH               MW(638:638)
#define NVCDC0_QMDV05_01_PRE_EXIT_AT_LAST_CTA_LAUNCH_FALSE         0x00000000
#define NVCDC0_QMDV05_01_PRE_EXIT_AT_LAST_CTA_LAUNCH_TRUE          0x00000001
#define NVCDC0_QMDV05_01_ENABLE_PROGRAM_PRE_EXIT                   MW(639:639)
#define NVCDC0_QMDV05_01_ENABLE_PROGRAM_PRE_EXIT_FALSE             0x00000000
#define NVCDC0_QMDV05_01_ENABLE_PROGRAM_PRE_EXIT_TRUE              0x00000001
#define NVCDC0_QMDV05_01_ARRIVE_AT_LATCH_ID                        MW(671:640)
#define NVCDC0_QMDV05_01_WAIT_ON_LATCH_ID                          MW(703:672)
#define NVCDC0_QMDV05_01_OCCUPANCY_THRESHOLD_SHARED_MEM            MW(721:714)
#define NVCDC0_QMDV05_01_OCCUPANCY_MAX_SHARED_MEM                  MW(729:722)
#define NVCDC0_QMDV05_01_ARRIVE_AT_LATCH_VALID                     MW(730:730)
#define NVCDC0_QMDV05_01_ARRIVE_AT_LATCH_VALID_FALSE               0x00000000
#define NVCDC0_QMDV05_01_ARRIVE_AT_LATCH_VALID_TRUE                0x00000001
#define NVCDC0_QMDV05_01_WAIT_ON_LATCH_VALID                       MW(731:731)
#define NVCDC0_QMDV05_01_WAIT_ON_LATCH_VALID_FALSE                 0x00000000
#define NVCDC0_QMDV05_01_WAIT_ON_LATCH_VALID_TRUE                  0x00000001
#define NVCDC0_QMDV05_01_LATCH_RELEASE_INVALIDATE_ENABLE           MW(732:732)
#define NVCDC0_QMDV05_01_LATCH_RELEASE_INVALIDATE_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV05_01_LATCH_RELEASE_INVALIDATE_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV05_01_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE MW(733:733)
#define NVCDC0_QMDV05_01_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE_FALSE 0x00000000
#define NVCDC0_QMDV05_01_HOLD_CTA_LAUNCH_UNTIL_PARENT_LATCH_ACQUIRE_AND_CTA_COMPLETE_TRUE 0x00000001
#define NVCDC0_QMDV05_01_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE           MW(734:734)
#define NVCDC0_QMDV05_01_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE_FALSE     0x00000000
#define NVCDC0_QMDV05_01_HOLD_MEMBAR_UNTIL_LATCH_ACQUIRE_TRUE      0x00000001
#define NVCDC0_QMDV05_01_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE       MW(735:735)
#define NVCDC0_QMDV05_01_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE_FALSE 0x00000000
#define NVCDC0_QMDV05_01_PRIORITY_DEMOTE_UNTIL_LATCH_ACQUIRE_TRUE  0x00000001
#define NVCDC0_QMDV05_01_OCCUPANCY_THRESHOLD_WARP                  MW(743:736)
#define NVCDC0_QMDV05_01_OCCUPANCY_MAX_WARP                        MW(751:744)
#define NVCDC0_QMDV05_01_OCCUPANCY_THRESHOLD_REGISTER              MW(759:752)
#define NVCDC0_QMDV05_01_OCCUPANCY_MAX_REGISTER                    MW(767:760)
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_ADDRESS_LOWER_SHIFTED4(i) MW((799+(i)*416):(768+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_ADDRESS_UPPER_SHIFTED4(i) MW((820+(i)*416):(800+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_PREFETCH_SIZE(i)         MW((829+(i)*416):(821+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_PREFETCH_TYPE(i)         MW((831+(i)*416):(830+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH 0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_PROGRAM_PREFETCH_TYPE_PREFTECH_POST 0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CTA_THREAD_DIMENSION0(i)         MW((847+(i)*416):(832+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CTA_THREAD_DIMENSION1(i)         MW((863+(i)*416):(848+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CTA_THREAD_DIMENSION2(i)         MW((871+(i)*416):(864+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_REGISTER_COUNT(i)                MW((880+(i)*416):(872+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_BARRIER_COUNT(i)                 MW((885+(i)*416):(881+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_VALID(i)          MW((886+(i)*416):(886+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_VALID_FALSE       0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_VALID_TRUE        0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_PREFETCH(i)       MW((888+(i)*416):(887+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_PREFETCH_PREFETCH_NONE 0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_PREFETCH_PREFETCH_PRE 0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_PREFETCH_PREFETCH_POST 0x00000002
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_INVALIDATE(i)     MW((889+(i)*416):(889+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_INVALIDATE_FALSE  0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_INVALIDATE_TRUE   0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_ICC_PREFETCH_SIZE(i)             MW((895+(i)*416):(890+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_SHARED_MEMORY_SIZE_SHIFTED7(i)   MW((906+(i)*416):(896+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_MIN_SM_CONFIG_SHARED_MEM_SIZE(i) MW((912+(i)*416):(907+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_MAX_SM_CONFIG_SHARED_MEM_SIZE(i) MW((918+(i)*416):(913+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_TARGET_SM_CONFIG_SHARED_MEM_SIZE(i) MW((924+(i)*416):(919+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_SHARED_MEM_BARRIER_INIT_ENABLE(i) MW((925+(i)*416):(925+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_SHADER_LOCAL_MEMORY_LOW_SIZE_SHIFTED4(i) MW((943+(i)*416):(928+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_SHADER_LOCAL_MEMORY_HIGH_SIZE_SHIFTED4(i) MW((959+(i)*416):(944+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_ADDR_LOWER_SHIFTED6(i) MW((991+(i)*416):(960+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_ADDR_UPPER_SHIFTED6(i) MW((1010+(i)*416):(992+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK0_SIZE_SHIFTED4(i)  MW((1023+(i)*416):(1011+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_ADDR_LOWER_SHIFTED6(i) MW((1055+(i)*416):(1024+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_ADDR_UPPER_SHIFTED6(i) MW((1074+(i)*416):(1056+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_SIZE_SHIFTED4(i)  MW((1087+(i)*416):(1075+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_VALID(i)          MW((1088+(i)*416):(1088+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_VALID_FALSE       0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_VALID_TRUE        0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_PREFETCH(i)       MW((1090+(i)*416):(1089+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_PREFETCH_PREFETCH_NONE 0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_PREFETCH_PREFETCH_PRE 0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_PREFETCH_PREFETCH_POST 0x00000002
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_INVALIDATE(i)     MW((1091+(i)*416):(1091+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_INVALIDATE_FALSE  0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK1_INVALIDATE_TRUE   0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_VIRTUAL_RESOURCE_COUNT(i)        MW((1099+(i)*416):(1092+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_GRID_WIDTH(i)                    MW((1151+(i)*416):(1120+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_GRID_HEIGHT(i)                   MW((1167+(i)*416):(1152+(i)*416))
#define NVCDC0_QMDV05_01_SUB_TASK_GRID_DEPTH(i)                    MW((1183+(i)*416):(1168+(i)*416))


/*
** Queue Meta Data, Version 05_01 (inferred arrays)
 */

#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ENABLE(i)                   MW((336+(i)*8):(336+(i)*8))
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ENABLE_FALSE                0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ENABLE_TRUE                 0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ACTION(i)                   MW((339+(i)*8):(337+(i)*8))
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ACTION_QMD_INCREMENT_PUT    0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ACTION_QMD_SCHEDULE         0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_PREFETCH(i)                 MW((340+(i)*8):(340+(i)*8))
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_PREFETCH_FALSE              0x00000000
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_PREFETCH_TRUE               0x00000001
#define NVCDC0_QMDV05_01_DEPENDENT_QMD_POINTER(i)                  MW((415+(i)*32):(384+(i)*32))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_VALID(i,j)         MW((886+(i)*416+(j)*202):(886+(i)*416+(j)*202))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_VALID_FALSE        0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_VALID_TRUE         0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_PREFETCH(i,j)      MW((888+(i)*416+(j)*202):(887+(i)*416+(j)*202))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_PREFETCH_PREFETCH_NONE 0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_PREFETCH_PREFETCH_PRE 0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_PREFETCH_PREFETCH_POST 0x00000002
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_INVALIDATE(i,j)    MW((889+(i)*416+(j)*202):(889+(i)*416+(j)*202))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_INVALIDATE_FALSE   0x00000000
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_INVALIDATE_TRUE    0x00000001
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_ADDR_LOWER_SHIFTED6(i,j) MW((991+(i)*416+(j)*64):(960+(i)*416+(j)*64))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_ADDR_UPPER_SHIFTED6(i,j) MW((1010+(i)*416+(j)*64):(992+(i)*416+(j)*64))
#define NVCDC0_QMDV05_01_SUB_TASK_CONSTANT_BANK_SIZE_SHIFTED4(i,j) MW((1023+(i)*416+(j)*64):(1011+(i)*416+(j)*64))


/*
** Queue Meta Data, Version 04_01
 */

#define NVCDC0_QMDV04_01_DEPENDENCE_COUNTER                        MW(15:0)
#define NVCDC0_QMDV04_01_QMD_GROUP_ID                              MW(21:16)
#define NVCDC0_QMDV04_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST      MW(22:22)
#define NVCDC0_QMDV04_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE 0x00000000
#define NVCDC0_QMDV04_01_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE 0x00000001
#define NVCDC0_QMDV04_01_QMD_TYPE                                  MW(25:23)
#define NVCDC0_QMDV04_01_QMD_TYPE_QUEUE                            0x00000000
#define NVCDC0_QMDV04_01_QMD_TYPE_GRID_NULL                        0x00000001
#define NVCDC0_QMDV04_01_QMD_TYPE_GRID_CTA                         0x00000002
#define NVCDC0_QMDV04_01_QMD_TYPE_GRID_GPC_CGA                     0x00000003
#define NVCDC0_QMDV04_01_QMD_TYPE_GRID_GPU_CGA                     0x00000004
#define NVCDC0_QMDV04_01_QMD_TYPE_GRID_GPU_GPC_CGA                 0x00000005
#define NVCDC0_QMDV04_01_ARRIVE_AT_LATCH_VALID                     MW(28:28)
#define NVCDC0_QMDV04_01_WAIT_ON_LATCH_VALID                       MW(29:29)
#define NVCDC0_QMDV04_01_REQUIRE_SCHEDULING_PCAS                   MW(30:30)
#define NVCDC0_QMDV04_01_REQUIRE_SCHEDULING_PCAS_FALSE             0x00000000
#define NVCDC0_QMDV04_01_REQUIRE_SCHEDULING_PCAS_TRUE              0x00000001
#define NVCDC0_QMDV04_01_TPC_DISABLE_MASK_VALID                    MW(31:31)
#define NVCDC0_QMDV04_01_TPC_DISABLE_MASK_VALID_FALSE              0x00000000
#define NVCDC0_QMDV04_01_TPC_DISABLE_MASK_VALID_TRUE               0x00000001
#define NVCDC0_QMDV04_01_CIRCULAR_QUEUE_SIZE                       MW(56:32)
#define NVCDC0_QMDV04_01_INNER_GET                                 MW(94:64)
#define NVCDC0_QMDV04_01_INNER_OVERFLOW                            MW(95:95)
#define NVCDC0_QMDV04_01_INNER_PUT                                 MW(126:96)
#define NVCDC0_QMDV04_01_INNER_STICKY_OVERFLOW                     MW(127:127)
#define NVCDC0_QMDV04_01_HW_ONLY_INNER_GET                         MW(190:160)
#define NVCDC0_QMDV04_01_HW_ONLY_INNER_PUT                         MW(222:192)
#define NVCDC0_QMDV04_01_HW_ONLY_SPAN_LIST_HEAD_INDEX              MW(253:224)
#define NVCDC0_QMDV04_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID        MW(254:254)
#define NVCDC0_QMDV04_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE  0x00000000
#define NVCDC0_QMDV04_01_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE   0x00000001
#define NVCDC0_QMDV04_01_HW_ONLY_SKED_NEXT_QMD_POINTER             MW(287:256)
#define NVCDC0_QMDV04_01_HW_ONLY_DEPENDENCE_COUNTER                MW(303:288)
#define NVCDC0_QMDV04_01_HW_ONLY_REQUIRE_SCHEDULING_PCAS           MW(304:304)
#define NVCDC0_QMDV04_01_RELEASE_ENABLE(i)                         MW((320+(i)*16):(320+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_ENABLE_FALSE                      0x00000000
#define NVCDC0_QMDV04_01_RELEASE_ENABLE_TRUE                       0x00000001
#define NVCDC0_QMDV04_01_RELEASE_STRUCTURE_SIZE(i)                 MW((322+(i)*16):(321+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS 0x00000000
#define NVCDC0_QMDV04_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD 0x00000001
#define NVCDC0_QMDV04_01_RELEASE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS 0x00000002
#define NVCDC0_QMDV04_01_RELEASE_MEMBAR_TYPE(i)                    MW((323+(i)*16):(323+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_MEMBAR_TYPE_FE_NONE               0x00000000
#define NVCDC0_QMDV04_01_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR          0x00000001
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_ENABLE(i)               MW((324+(i)*16):(324+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP(i)                   MW((327+(i)*16):(325+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_ADD              0x00000000
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_MIN              0x00000001
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_MAX              0x00000002
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_INC              0x00000003
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_DEC              0x00000004
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_AND              0x00000005
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_OR               0x00000006
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_OP_RED_XOR              0x00000007
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_FORMAT(i)               MW((329+(i)*16):(328+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_FORMAT_UNSIGNED         0x00000000
#define NVCDC0_QMDV04_01_RELEASE_REDUCTION_FORMAT_SIGNED           0x00000001
#define NVCDC0_QMDV04_01_RELEASE_TRAP_TYPE(i)                      MW((331+(i)*16):(330+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_TRAP_TYPE_TRAP_NONE               0x00000000
#define NVCDC0_QMDV04_01_RELEASE_TRAP_TYPE_TRAP_UNCONDITIONAL      0x00000001
#define NVCDC0_QMDV04_01_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL        0x00000002
#define NVCDC0_QMDV04_01_RELEASE_TRAP_TYPE_TRAP_CONDITIONAL_EXT    0x00000003
#define NVCDC0_QMDV04_01_RELEASE_PAYLOAD64B(i)                     MW((332+(i)*16):(332+(i)*16))
#define NVCDC0_QMDV04_01_RELEASE_PAYLOAD64B_FALSE                  0x00000000
#define NVCDC0_QMDV04_01_RELEASE_PAYLOAD64B_TRUE                   0x00000001
#define NVCDC0_QMDV04_01_RELEASE_RESERVED_INFO(i)                  MW((335+(i)*16):(333+(i)*16))
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ENABLE(i)                   MW((368+(i)*5):(368+(i)*5))
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ENABLE_FALSE                0x00000000
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ENABLE_TRUE                 0x00000001
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ACTION(i)                   MW((371+(i)*5):(369+(i)*5))
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ACTION_QMD_INCREMENT_PUT    0x00000000
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ACTION_QMD_SCHEDULE         0x00000001
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ACTION_QMD_INVALIDATE_COPY_SCHEDULE 0x00000003
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_ACTION_QMD_DECREMENT_DEPENDENCE 0x00000004
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_PREFETCH(i)                 MW((372+(i)*5):(372+(i)*5))
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_PREFETCH_FALSE              0x00000000
#define NVCDC0_QMDV04_01_DEPENDENT_QMD_PREFETCH_TRUE               0x00000001
#define NVCDC0_QMDV04_01_SELF_COPY_ON_COMPLETION                   MW(378:378)
#define NVCDC0_QMDV04_01_SELF_COPY_ON_COMPLETION_FALSE             0x00000000
#define NVCDC0_QMDV04_01_SELF_COPY_ON_COMPLETION_TRUE              0x00000001
#define NVCDC0_QMDV04_01_DEMOTE_L2_EVICT_LAST                      MW(379:379)
#define NVCDC0_QMDV04_01_DEMOTE_L2_EVICT_LAST_FALSE                0x00000000
#define NVCDC0_QMDV04_01_DEMOTE_L2_EVICT_LAST_TRUE                 0x00000001
#define NVCDC0_QMDV04_01_DISABLE_AUTO_INVALIDATE                   MW(380:380)
#define NVCDC0_QMDV04_01_DISABLE_AUTO_INVALIDATE_FALSE             0x00000000
#define NVCDC0_QMDV04_01_DISABLE_AUTO_INVALIDATE_TRUE              0x00000001
#define NVCDC0_QMDV04_01_CORRELATION_ID_INTERNAL                   MW(381:381)
#define NVCDC0_QMDV04_01_CORRELATION_ID_INTERNAL_FALSE             0x00000000
#define NVCDC0_QMDV04_01_CORRELATION_ID_INTERNAL_TRUE              0x00000001
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TASK_CHASING_ENABLE            MW(382:382)
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TASK_CHASING_ENABLE_FALSE      0x00000000
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TASK_CHASING_ENABLE_TRUE       0x00000001
#define NVCDC0_QMDV04_01_CORRELATION_ID                            MW(415:384)
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_VALID(i)                  MW((416+(i)*4):(416+(i)*4))
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_VALID_FALSE               0x00000000
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_VALID_TRUE                0x00000001
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_PREFETCH(i)               MW((418+(i)*4):(417+(i)*4))
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_PREFETCH_PREFETCH_NONE    0x00000000
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_PREFETCH_PREFETCH_PRE     0x00000001
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_PREFETCH_PREFETCH_POST    0x00000002
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_INVALIDATE(i)             MW((419+(i)*4):(419+(i)*4))
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_INVALIDATE_FALSE          0x00000000
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_INVALIDATE_TRUE           0x00000001
#define NVCDC0_QMDV04_01_DEPENDENT_QMD0_POINTER                    MW(479:448)
#define NVCDC0_QMDV04_01_DEPENDENT_QMD1_POINTER                    MW(511:480)
#define NVCDC0_QMDV04_01_SHADER_LOCAL_MEMORY_LOW_SIZE              MW(535:512)
#define NVCDC0_QMDV04_01_SASS_VERSION                              MW(543:536)
#define NVCDC0_QMDV04_01_SHADER_LOCAL_MEMORY_HIGH_SIZE             MW(567:544)
#define NVCDC0_QMDV04_01_API_VISIBLE_CALL_LIMIT                    MW(568:568)
#define NVCDC0_QMDV04_01_API_VISIBLE_CALL_LIMIT__32                0x00000000
#define NVCDC0_QMDV04_01_API_VISIBLE_CALL_LIMIT_NO_CHECK           0x00000001
#define NVCDC0_QMDV04_01_SAMPLER_INDEX                             MW(569:569)
#define NVCDC0_QMDV04_01_SAMPLER_INDEX_INDEPENDENTLY               0x00000000
#define NVCDC0_QMDV04_01_SAMPLER_INDEX_VIA_HEADER_INDEX            0x00000001
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_PREFETCH_PRE_MAX_SIZE_SHIFTED8 MW(575:570)
#define NVCDC0_QMDV04_01_QMD_MINOR_VERSION                         MW(579:576)
#define NVCDC0_QMDV04_01_QMD_MAJOR_VERSION                         MW(583:580)
#define NVCDC0_QMDV04_01_SHARED_MEMORY_SIZE                        MW(601:584)
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_HEADER_CACHE           MW(602:602)
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE     0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE      0x00000001
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_SAMPLER_CACHE          MW(603:603)
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_DATA_CACHE             MW(604:604)
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_DATA_CACHE_FALSE       0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_TEXTURE_DATA_CACHE_TRUE        0x00000001
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_DATA_CACHE              MW(605:605)
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_DATA_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_DATA_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV04_01_INVALIDATE_INSTRUCTION_CACHE              MW(606:606)
#define NVCDC0_QMDV04_01_INVALIDATE_INSTRUCTION_CACHE_FALSE        0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_INSTRUCTION_CACHE_TRUE         0x00000001
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_CONSTANT_CACHE          MW(607:607)
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE    0x00000000
#define NVCDC0_QMDV04_01_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE     0x00000001
#define NVCDC0_QMDV04_01_MIN_SM_CONFIG_SHARED_MEM_SIZE             MW(613:608)
#define NVCDC0_QMDV04_01_MAX_SM_CONFIG_SHARED_MEM_SIZE             MW(619:614)
#define NVCDC0_QMDV04_01_TARGET_SM_CONFIG_SHARED_MEM_SIZE          MW(625:620)
#define NVCDC0_QMDV04_01_SHARED_ALLOCATION_ENABLE                  MW(626:626)
#define NVCDC0_QMDV04_01_SHARED_ALLOCATION_ENABLE_FALSE            0x00000000
#define NVCDC0_QMDV04_01_SHARED_ALLOCATION_ENABLE_TRUE             0x00000001
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE0_ADDR_LOWER             MW(671:640)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE0_ADDR_UPPER             MW(696:672)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE0_PAYLOAD_LOWER          MW(735:704)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE0_PAYLOAD_UPPER          MW(767:736)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE1_ADDR_LOWER             MW(799:768)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE1_ADDR_UPPER             MW(824:800)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE1_PAYLOAD_LOWER          MW(863:832)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE1_PAYLOAD_UPPER          MW(895:864)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE2_ADDR_LOWER             MW(927:896)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE2_ADDR_UPPER             MW(952:928)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE2_PAYLOAD_LOWER          MW(991:960)
#define NVCDC0_QMDV04_01_RELEASE_SEMAPHORE2_PAYLOAD_UPPER          MW(1023:992)
#define NVCDC0_QMDV04_01_GRID_WIDTH                                MW(1055:1024)
#define NVCDC0_QMDV04_01_GRID_HEIGHT                               MW(1071:1056)
#define NVCDC0_QMDV04_01_GRID_DEPTH                                MW(1103:1088)
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE       MW(1127:1120)
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_ID                    MW(1133:1128)
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_INCR_ENABLE           MW(1134:1134)
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_DECR_ENABLE           MW(1135:1135)
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE     0x00000000
#define NVCDC0_QMDV04_01_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE      0x00000001
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TYPE                           MW(1137:1136)
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TYPE_L1_NONE                   0x00000000
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TYPE_L1_SYSMEMBAR              0x00000001
#define NVCDC0_QMDV04_01_CWD_MEMBAR_TYPE_L1_MEMBAR                 0x00000003
#define NVCDC0_QMDV04_01_SEQUENTIALLY_RUN_CTAS                     MW(1138:1138)
#define NVCDC0_QMDV04_01_SEQUENTIALLY_RUN_CTAS_FALSE               0x00000000
#define NVCDC0_QMDV04_01_SEQUENTIALLY_RUN_CTAS_TRUE                0x00000001
#define NVCDC0_QMDV04_01_CTA_LAUNCH_QUEUE                          MW(1139:1139)
#define NVCDC0_QMDV04_01_FREE_CTA_SLOTS_EMPTY_SM                   MW(1147:1140)
#define NVCDC0_QMDV04_01_SYNC_DOMAIN_ID                            MW(1149:1148)
#define NVCDC0_QMDV04_01_PRE_EXIT_AT_LAST_CTA_LAUNCH               MW(1150:1150)
#define NVCDC0_QMDV04_01_PRE_EXIT_AT_LAST_CTA_LAUNCH_FALSE         0x00000000
#define NVCDC0_QMDV04_01_PRE_EXIT_AT_LAST_CTA_LAUNCH_TRUE          0x00000001
#define NVCDC0_QMDV04_01_ENABLE_PROGRAM_PRE_EXIT                   MW(1151:1151)
#define NVCDC0_QMDV04_01_ENABLE_PROGRAM_PRE_EXIT_FALSE             0x00000000
#define NVCDC0_QMDV04_01_ENABLE_PROGRAM_PRE_EXIT_TRUE              0x00000001
#define NVCDC0_QMDV04_01_CTA_THREAD_DIMENSION0                     MW(1167:1152)
#define NVCDC0_QMDV04_01_CTA_THREAD_DIMENSION1                     MW(1183:1168)
#define NVCDC0_QMDV04_01_CTA_THREAD_DIMENSION2                     MW(1191:1184)
#define NVCDC0_QMDV04_01_VIRTUAL_RESOURCE_COUNT                    MW(1199:1192)
#define NVCDC0_QMDV04_01_REGISTER_COUNT                            MW(1208:1200)
#define NVCDC0_QMDV04_01_SHARED_MEM_BARRIER_INIT_ENABLE            MW(1210:1210)
#define NVCDC0_QMDV04_01_BARRIER_COUNT                             MW(1215:1211)
#define NVCDC0_QMDV04_01_PROGRAM_ADDRESS_LOWER                     MW(1247:1216)
#define NVCDC0_QMDV04_01_PROGRAM_ADDRESS_UPPER                     MW(1272:1248)
#define NVCDC0_QMDV04_01_OCCUPANCY_THRESHOLD_WARP                  MW(1287:1280)
#define NVCDC0_QMDV04_01_OCCUPANCY_MAX_WARP                        MW(1295:1288)
#define NVCDC0_QMDV04_01_OCCUPANCY_THRESHOLD_REGISTER              MW(1303:1296)
#define NVCDC0_QMDV04_01_OCCUPANCY_MAX_REGISTER                    MW(1311:1304)
#define NVCDC0_QMDV04_01_OCCUPANCY_THRESHOLD_SHARED_MEM            MW(1319:1312)
#define NVCDC0_QMDV04_01_OCCUPANCY_MAX_SHARED_MEM                  MW(1327:1320)
#define NVCDC0_QMDV04_01_ICC_PREFETCH_SIZE                         MW(1333:1328)
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED       MW(1375:1344)
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED       MW(1392:1376)
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_SIZE                     MW(1401:1393)
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_TYPE                     MW(1403:1402)
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH     0x00000000
#define NVCDC0_QMDV04_01_PROGRAM_PREFETCH_TYPE_PREFTECH_POST       0x00000001
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE MW(1406:1406)
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_SHADER_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE MW(1407:1407)
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_FALSE 0x00000000
#define NVCDC0_QMDV04_01_LATCH_ACQUIRE_INVALIDATE_TEXTURE_DATA_CACHE_TRUE 0x00000001
#define NVCDC0_QMDV04_01_GRID_WIDTH_RESUME                         MW(1439:1408)
#define NVCDC0_QMDV04_01_GRID_HEIGHT_RESUME                        MW(1455:1440)
#define NVCDC0_QMDV04_01_GRID_DEPTH_RESUME                         MW(1471:1456)
#define NVCDC0_QMDV04_01_ARRIVE_AT_LATCH_ID                        MW(1503:1472)
#define NVCDC0_QMDV04_01_WAIT_ON_LATCH_ID                          MW(1535:1504)
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_ADDR_LOWER_SHIFTED6(i)    MW((1567+(i)*64):(1536+(i)*64))
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_ADDR_UPPER_SHIFTED6(i)    MW((1586+(i)*64):(1568+(i)*64))
#define NVCDC0_QMDV04_01_CONSTANT_BUFFER_SIZE_SHIFTED4(i)          MW((1599+(i)*64):(1587+(i)*64))
#define NVCDC0_QMDV04_01_COALESCE_WAITING_PERIOD                   MW(2135:2128)
#define NVCDC0_QMDV04_01_QUEUE_ENTRIES_PER_CTA_LOG2                MW(2140:2136)
#define NVCDC0_QMDV04_01_GPC_CGA_WIDTH                             MW(2149:2144)
#define NVCDC0_QMDV04_01_GPC_CGA_HEIGHT                            MW(2157:2152)
#define NVCDC0_QMDV04_01_GPC_CGA_DEPTH                             MW(2165:2160)
#define NVCDC0_QMDV04_01_LARGE_GPC_CGA_WIDTH_MINUS_ONE             MW(2171:2168)
#define NVCDC0_QMDV04_01_LARGE_GPC_CGA_HEIGHT_MINUS_ONE            MW(2175:2172)
#define NVCDC0_QMDV04_01_CGA_CTA_DISTRIBUTION_MODE                 MW(2207:2207)
#define NVCDC0_QMDV04_01_CGA_CTA_DISTRIBUTION_MODE_LOAD_BALANCING  0x00000000
#define NVCDC0_QMDV04_01_CGA_CTA_DISTRIBUTION_MODE_MULTI_CAST      0x00000001
#define NVCDC0_QMDV04_01_GPU_CGA_WIDTH                             MW(2223:2208)
#define NVCDC0_QMDV04_01_GPU_CGA_HEIGHT                            MW(2239:2224)
#define NVCDC0_QMDV04_01_GPU_CGA_DEPTH                             MW(2255:2240)
#define NVCDC0_QMDV04_01_DEBUG_ID_LOWER                            MW(2399:2368)
#define NVCDC0_QMDV04_01_DEBUG_ID_UPPER                            MW(2431:2400)
#define NVCDC0_QMDV04_01_TPC_DISABLE_MASK(i)                       MW((2463+(i)*32):(2432+(i)*32))
#define NVCDC0_QMDV04_01_INCOMPLETE_BOX_BASE_WIDTH_RESUME          MW(2591:2560)
#define NVCDC0_QMDV04_01_INCOMPLETE_BOX_BASE_HEIGHT_RESUME         MW(2607:2592)
#define NVCDC0_QMDV04_01_INCOMPLETE_BOX_BASE_DEPTH_RESUME          MW(2623:2608)
#define NVCDC0_QMDV04_01_INCOMPLETE_BOX_OFFSET_WIDTH_RESUME        MW(2627:2624)
#define NVCDC0_QMDV04_01_INCOMPLETE_BOX_OFFSET_HEIGHT_RESUME       MW(2631:2628)
#define NVCDC0_QMDV04_01_TPC_DISABLE_MASK_UPPER(i)                 MW((2719+(i)*32):(2688+(i)*32))
#define NVCDC0_QMDV04_01_OUTER_PUT                                 MW(3038:3008)
#define NVCDC0_QMDV04_01_OUTER_OVERFLOW                            MW(3039:3039)
#define NVCDC0_QMDV04_01_OUTER_GET                                 MW(3070:3040)
#define NVCDC0_QMDV04_01_OUTER_STICKY_OVERFLOW                     MW(3071:3071)



#endif // #ifndef __CLCDC0QMD_H__
