macro(ensure_props_set projectFile)
  if(NOT EXISTS "${projectFile}")
    set(RunCMake_TEST_FAILED "Project file ${projectFile} does not exist.")
    return()
  endif()

  set(FirstSettingFound FALSE)
  set(SecondSettingFound FALSE)

  file(STRINGS "${projectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "<TargetProperty1.*Debug.*>TargetProperty1ValueDebug</TargetProperty1>")
      if (FirstSettingFound)
        message("TargetProperty1 setting found twice")
        set(SecondSettingFound TRUE)
      else()
        message("TargetProperty1 setting found once")
        set(FirstSettingFound TRUE)
      endif()
    endif()
  endforeach()

  if (NOT FirstSettingFound)
    set(RunCMake_TEST_FAILED "TargetProperty1 setting not found at all")
    return()
  endif()

  if (NOT SecondSettingFound)
    set(RunCMake_TEST_FAILED "TargetProperty1 setting found once when it should be found twice")
    return()
  endif()
endmacro()

ensure_props_set("${RunCMake_TEST_BINARY_DIR}/foo.vcxproj")
