/*
 * Decompiled with CFR 0.152.
 */
package jflex.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import jflex.gui.GeneratorThread;
import jflex.gui.GridPanel;
import jflex.gui.OptionsDialog;
import jflex.logging.Out;

public final class MainFrame
extends Frame {
    private static final long serialVersionUID = 3296137982410640865L;
    private volatile boolean choosing;
    private String fileName = "";
    private String dirName = "";
    private Button quit;
    private Button generate;
    private Button specChoose;
    private Button dirChoose;
    private TextField spec;
    private TextField dir;
    private TextArea messages;
    private GeneratorThread thread;
    private OptionsDialog dialog;

    public MainFrame() {
        super("JFlex 1.9.1");
        this.buildContent();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.quit();
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private void buildContent() {
        this.setBackground(SystemColor.control);
        this.generate = new Button("Generate");
        this.quit = new Button("Quit");
        Button options = new Button("Options");
        this.dirChoose = new Button("Browse");
        this.dir = new TextField(10);
        this.specChoose = new Button("Browse");
        this.spec = new TextField(10);
        this.messages = new TextArea(10, 80);
        this.messages.setEditable(false);
        Font font = this.messages.getFont();
        if (font != null) {
            this.messages.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        } else {
            this.messages.setFont(new Font("Monospaced", 0, 12));
        }
        Out.setGUIMode(this.messages);
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.generate();
            }
        });
        options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showOptions();
            }
        });
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.quit();
            }
        });
        this.specChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.specChoose();
            }
        });
        this.dirChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dirChoose();
            }
        });
        this.spec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.fileName = MainFrame.this.spec.getText();
                MainFrame.this.generate();
            }
        });
        this.spec.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                MainFrame.this.fileName = MainFrame.this.spec.getText();
            }
        });
        this.dir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dirName = MainFrame.this.dir.getText();
                MainFrame.this.generate();
            }
        });
        this.dir.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                MainFrame.this.dirName = MainFrame.this.dir.getText();
            }
        });
        GridPanel north = new GridPanel(5, 4, 10, 10);
        north.setInsets(new Insets(10, 5, 5, 10));
        north.add(4, 0, this.quit);
        north.add(4, 1, this.generate);
        north.add(4, 2, options);
        north.add(0, 0, 7, new Label("Lexical specification:"));
        north.add(0, 1, 2, 1, this.spec);
        north.add(2, 1, this.specChoose);
        north.add(0, 2, 7, new Label("Output directory:"));
        north.add(0, 3, 2, 1, this.dir);
        north.add(2, 3, this.dirChoose);
        Panel center = new Panel(new BorderLayout());
        center.add("North", new Label("Messages:"));
        center.add("Center", this.messages);
        this.add("North", north);
        this.add("Center", center);
        this.setEnabledAll(false);
    }

    protected void showOptions() {
        if (this.dialog == null) {
            this.dialog = new OptionsDialog(this);
        }
        this.dialog.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.messages.getPreferredSize().width;
        return d;
    }

    private void setEnabledAll(boolean generating) {
        this.quit.setEnabled(!generating);
        this.generate.setEnabled(!generating);
        this.dirChoose.setEnabled(!generating);
        this.dir.setEnabled(!generating);
        this.specChoose.setEnabled(!generating);
        this.spec.setEnabled(!generating);
    }

    private void generate() {
        if (this.choosing) {
            return;
        }
        this.setEnabledAll(true);
        this.thread = new GeneratorThread(this, this.fileName, this.dirName);
        this.thread.start();
    }

    public void generationFinished(boolean success) {
        this.setEnabledAll(false);
        if (success) {
            this.messages.append(Out.NL + "Generation finished successfully." + Out.NL);
        } else {
            this.messages.append(Out.NL + "Generation aborted." + Out.NL);
        }
    }

    private void quit() {
        this.setVisible(false);
        System.exit(0);
    }

    private void dirChoose() {
        this.choosing = true;
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        FileDialog d = new FileDialog((Frame)this, "Choose directory", 0);
        d.setVisible(true);
        if (d.getDirectory() != null) {
            this.dir.setText(new File(d.getDirectory()).getAbsolutePath());
        }
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        this.choosing = false;
    }

    private void specChoose() {
        this.choosing = true;
        FileDialog d = new FileDialog((Frame)this, "Choose file", 0);
        d.setFile("*.flex");
        d.setVisible(true);
        if (d.getFile() != null) {
            this.fileName = d.getDirectory() + d.getFile();
            this.dir.setText(d.getDirectory());
            this.spec.setText(this.fileName);
        }
        this.choosing = false;
    }
}

