# Cantera 2.6.0

Published on May 1, 2022 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.6.0)

The Cantera development team is pleased to announce the availability of Cantera 2.6.0. There have been over 1400 commits to Cantera since the last version, 2.5.1, which was released in February 2021. We have closed or merged [162 pull requests](https://github.com/Cantera/cantera/pulls?q=is%3Apr+merged%3A2021-02-13..2022-05-01+is%3Aclosed) and closed [101 issues](https://github.com/Cantera/cantera/issues?page=4&q=is%3Aissue+closed%3A2021-02-13..2022-05-01+is%3Aclosed).

## New features, bug fixes, and other changes

### Highlights
- Major redesign of how reaction rates are handled internally to improve extensibility and enable new capabilities ([E#63](https://github.com/Cantera/enhancements/issues/63), [E#87](https://github.com/Cantera/enhancements/issues/87), [#982](https://github.com/Cantera/cantera/pull/982), [#995](https://github.com/Cantera/cantera/pull/995), [#1061](https://github.com/Cantera/cantera/pull/1061), [#1101](https://github.com/Cantera/cantera/pull/1101), [#1151](https://github.com/Cantera/cantera/pull/1151), [#1153](https://github.com/Cantera/cantera/pull/1153), [#1181](https://github.com/Cantera/cantera/pull/1181), [#1183](https://github.com/Cantera/cantera/pull/1183), [#1184](https://github.com/Cantera/cantera/pull/1184), [#1187](https://github.com/Cantera/cantera/pull/1187), [#1202](https://github.com/Cantera/cantera/pull/1202), [#1216](https://github.com/Cantera/cantera/pull/1216), [#1223](https://github.com/Cantera/cantera/pull/1223), [#1225](https://github.com/Cantera/cantera/pull/1225), [#1256](https://github.com/Cantera/cantera/pull/1256), [#1257](https://github.com/Cantera/cantera/pull/1257))
- Enable delegation of reactor implementation to user-provided Python classes ([`custom2.py`](https://github.com/Cantera/cantera/blob/2.6/interfaces/cython/cantera/examples/reactors/custom2.py), [#1003](https://github.com/Cantera/cantera/pull/1003))
- Enable serialization of Cantera objects to YAML ([`mechanism_reduction.py`](https://github.com/Cantera/cantera/blob/2.6/interfaces/cython/cantera/examples/kinetics/mechanism_reduction.py), [#984](https://github.com/Cantera/cantera/pull/984), [#1014](https://github.com/Cantera/cantera/pull/1014), [#1031](https://github.com/Cantera/cantera/pull/1031))
- Implement pickling of Python `Solution` objects ([#692](https://github.com/Cantera/cantera/pull/692))
- Add [PyPI](https://pypi.org/project/Cantera/) package for Cantera, installable with `pip` ([#1075](https://github.com/Cantera/cantera/pull/1075), [#1239](https://github.com/Cantera/cantera/pull/1239), [#1240](https://github.com/Cantera/cantera/pull/1240), [#1232](https://github.com/Cantera/cantera/pull/1232), [#1261](https://github.com/Cantera/cantera/pull/1261))
- Implement Peng-Robinson equation of state for real gases ([#1047](https://github.com/Cantera/cantera/pull/1047), [#1141](https://github.com/Cantera/cantera/pull/1141), [#1180](https://github.com/Cantera/cantera/pull/1180))
- Add Blowers-Masel reaction rate parameterization for gas phase and interface kinetics ([`blowers-masel.py`](https://github.com/Cantera/cantera/blob/2.6/interfaces/cython/cantera/examples/kinetics/blowers_masel.py), [#987](https://github.com/Cantera/cantera/pull/987))
- Add calculation of sparse, analytical Jacobians for gas kinetics ([`derivative_speed.cpp`](https://github.com/Cantera/cantera/blob/2.6/samples/cxx/jacobian/derivative_speed.cpp), [#1088](https://github.com/Cantera/cantera/pull/1088), [#1089](https://github.com/Cantera/cantera/pull/1089), [#1212](https://github.com/Cantera/cantera/pull/1212))
- Add new phase type and reaction rate parameterizations for plasmas with independent electron temperature ([#1099](https://github.com/Cantera/cantera/pull/1099), [#1166](https://github.com/Cantera/cantera/pull/1166), [#1190](https://github.com/Cantera/cantera/pull/1190))

### New features
- Simplify creation of interface phases and their adjacent bulk phases ([#1169](https://github.com/Cantera/cantera/pull/1169), [#1247](https://github.com/Cantera/cantera/pull/1247))
- Add Tsang "falloff" function [#1090](https://github.com/Cantera/cantera/pull/1090)
- Add option to allow unnormalized and/or negative mass/mole fractions in `SolutionArray` / 1D flame importers  [#1037](https://github.com/Cantera/cantera/pull/1037)
- Added access functions to polynomial fits of gas transport properties [#817](https://github.com/Cantera/cantera/pull/817), [#1077](https://github.com/Cantera/cantera/pull/1077)
- Add dilution options to equivalence ratio functions in Python [#1206](https://github.com/Cantera/cantera/pull/1206)
- Make rate coefficient and standard concentration units available in Python [#1076](https://github.com/Cantera/cantera/pull/1076)
- Add creation of Species from Python dict [#1179](https://github.com/Cantera/cantera/pull/1179)
- Add thermal conductivity to `DustyGas` in Python [#988](https://github.com/Cantera/cantera/pull/988)
- Add `set_mixture_fraction` method to `SolutionArray` [#1242](https://github.com/Cantera/cantera/pull/1242)
- Exposed some additional functions to the Fortran interface [#1154](https://github.com/Cantera/cantera/pull/1154)
- New C++ custom ODEs example [#922](https://github.com/Cantera/cantera/pull/922)
- Added a Python version of the Matlab lithium ion battery example [#1263](https://github.com/Cantera/cantera/pull/1263)
- Add support for Sundials 6.0 [#1162](https://github.com/Cantera/cantera/pull/1162)

### Changes to existing capabilities
- Use YAML for saving and loading 1D flame simulations, replacing the XML output format [#1112](https://github.com/Cantera/cantera/pull/1112), [#1140](https://github.com/Cantera/cantera/pull/1140)
- Use normal sign convention for reactor heat transfer [#1156](https://github.com/Cantera/cantera/pull/1156)
- Separate third-body concentration term from rate constant for three body reactions [#1084](https://github.com/Cantera/cantera/pull/1084)
- Translate C++ warnings to Python [#1201](https://github.com/Cantera/cantera/pull/1201)
- Refactor SCons option handling and automatically extract compilation options for website documentation [#1137](https://github.com/Cantera/cantera/pull/1137)
- Automatically use dependencies from and install into an active Conda environment [#1191](https://github.com/Cantera/cantera/pull/1191)
- Include header description in when converting from CTI to YAML [#1205](https://github.com/Cantera/cantera/pull/1205)
- Use of deprecated XML or CTI formats now actively issues warnings [#1159](https://github.com/Cantera/cantera/pull/1159)
- Support legacy `ruamel.yaml` loaders [#1060](https://github.com/Cantera/cantera/pull/1060)
- Update examples to use `h2o2.yaml` instead of GRI 3.0 [#1109](https://github.com/Cantera/cantera/pull/1109)
- Prevent inadvertent attribute assignment in `Quantity` [#1124](https://github.com/Cantera/cantera/pull/1124)
- Fix issues with composition strings and kinetics model of "None" in `cti2yaml` [#1127](https://github.com/Cantera/cantera/pull/1127)
- Deprecate shell setup scripts (`setup_cantera`) [#1189](https://github.com/Cantera/cantera/pull/1189)
- Replace deprecated `yaml.safe_load` / simplify paths [#1049](https://github.com/Cantera/cantera/pull/1049)
- Read YAML using C++ `newSolution` in Python / access root level data [#1129](https://github.com/Cantera/cantera/pull/1129)
- Improve YAML formatting of floating point values and multiline strings [#1133](https://github.com/Cantera/cantera/pull/1133)
- Automatically detect unspecified third-body collision partners [#1015](https://github.com/Cantera/cantera/pull/1015)
- Various compilation, build system, and test infrastructure updates [#979](https://github.com/Cantera/cantera/pull/979), [#994](https://github.com/Cantera/cantera/pull/994), [#1000](https://github.com/Cantera/cantera/pull/1000), [#1004](https://github.com/Cantera/cantera/pull/1004), [#1012](https://github.com/Cantera/cantera/pull/1012), [#1020](https://github.com/Cantera/cantera/pull/1020), [#1025](https://github.com/Cantera/cantera/pull/1025), [#1034](https://github.com/Cantera/cantera/pull/1034), [#1043](https://github.com/Cantera/cantera/pull/1043), [#1056](https://github.com/Cantera/cantera/pull/1056), [#1062](https://github.com/Cantera/cantera/pull/1062), [#1145](https://github.com/Cantera/cantera/pull/1145), [#1158](https://github.com/Cantera/cantera/pull/1158), [#1102](https://github.com/Cantera/cantera/pull/1102), [#1119](https://github.com/Cantera/cantera/pull/1119), [#1122](https://github.com/Cantera/cantera/pull/1122), [#1144](https://github.com/Cantera/cantera/pull/1144). [#1167](https://github.com/Cantera/cantera/pull/1167), [#1172](https://github.com/Cantera/cantera/pull/1172), [#1176](https://github.com/Cantera/cantera/pull/1176), [#1178](https://github.com/Cantera/cantera/pull/1178), [#1197](https://github.com/Cantera/cantera/pull/1197), [#1208](https://github.com/Cantera/cantera/pull/1208), [#1222](https://github.com/Cantera/cantera/pull/1222), [#1229](https://github.com/Cantera/cantera/pull/1229), [#1241](https://github.com/Cantera/cantera/pull/1241), [#1268](https://github.com/Cantera/cantera/pull/1268)
- Various documentation updates [#983](https://github.com/Cantera/cantera/pull/983), [#1002](https://github.com/Cantera/cantera/pull/1002), [#1022](https://github.com/Cantera/cantera/pull/1022), [#1032](https://github.com/Cantera/cantera/pull/1032), [#1045](https://github.com/Cantera/cantera/pull/1045), [#1065](https://github.com/Cantera/cantera/pull/1065), [#1121](https://github.com/Cantera/cantera/pull/1121), [#1142](https://github.com/Cantera/cantera/pull/1142), [#1152](https://github.com/Cantera/cantera/pull/1152), [#1196](https://github.com/Cantera/cantera/pull/1196), [#1200](https://github.com/Cantera/cantera/pull/1200), [#1227](https://github.com/Cantera/cantera/pull/1227), [#1231](https://github.com/Cantera/cantera/pull/1231), [#1234](https://github.com/Cantera/cantera/pull/1234), [#1249](https://github.com/Cantera/cantera/pull/1249), [#1255](https://github.com/Cantera/cantera/pull/1255), [#1264](https://github.com/Cantera/cantera/pull/1264)

### Bugs fixed
- Fix Redlich-Kwong partial molar properties [#1218](https://github.com/Cantera/cantera/pull/1218)
- Fix pressure dependence in `IdealSolidSolnPhase::getPartialMolarEnthalpies` [#1087](https://github.com/Cantera/cantera/pull/1087)
- Fix evaluation of delta-star polynomials [#1125](https://github.com/Cantera/cantera/pull/1125)
- Consistently use physical concentrations when calculating third body and falloff reaction rates, for both specifically enumerated efficiencies and generic third body colliders [#968](https://github.com/Cantera/cantera/pull/968)
- Add check for sticking coefficient more than 1 [#1038](https://github.com/Cantera/cantera/pull/1038)
- Fix typo in `equivalenceRatio.py` that resulted in printing wrong results [#1173](https://github.com/Cantera/cantera/pull/1173)
- Fix memory error when deallocating Python reaction rate wrappers [#1030](https://github.com/Cantera/cantera/pull/1030)
- Prevent segmentation fault when initializing standalone Reactor objects [#1063](https://github.com/Cantera/cantera/pull/1063)
- Fix extinction temperature definition in `diffusion_flame_extinction.py` example [#1066](https://github.com/Cantera/cantera/pull/1066)
- Fix handling of 'CK_Multi' transport model in flame simulations [#1069](https://github.com/Cantera/cantera/pull/1069)
- Fix issues with import of `SolutionArray` from CSV [#1074](https://github.com/Cantera/cantera/pull/1074)
- Fix `SolutionArray.append` [#1086](https://github.com/Cantera/cantera/pull/1086)
- Fix 1D solver errors when reporting singular Jacobian and use of non-default tolerances after automatic grid expansion [#1103](https://github.com/Cantera/cantera/pull/1103)
- Suppress output from `setEnergy.m` [#1106](https://github.com/Cantera/cantera/pull/1106)
- Fix using reactors with both surface and gas phase chemistry with YAML input [#981](https://github.com/Cantera/cantera/pull/981)
- Fix saving 1D output when `radiative_heat_loss` is enabled [#993](https://github.com/Cantera/cantera/pull/993)
- Fix CTI to YAML conversion for `transport='None'` [#997](https://github.com/Cantera/cantera/pull/997)
- Fix handling of CK mechanisms with '+M' in PLOG reaction equations [#1252](https://github.com/Cantera/cantera/pull/1252)
- Fix detection of skipped/undeclared species in three body reactions [#1027](https://github.com/Cantera/cantera/pull/1027)
- Fix invalid unchecked cast to `StFlow` [#1226](https://github.com/Cantera/cantera/pull/1226)
- Fix `SolutionArray` extra slice [#1204](https://github.com/Cantera/cantera/pull/1204)
- Check for valid component name when setting reactor advance limits [#1215](https://github.com/Cantera/cantera/pull/1215)
- Fix incorrect temperature bounds and missing entries in `NASA_condensed.yaml` [#1248](https://github.com/Cantera/cantera/pull/1248), [#1250](https://github.com/Cantera/cantera/pull/1250)
- Fix logic error in `CanteraTest.assertNear` [#1120](https://github.com/Cantera/cantera/pull/1120)
- Fix various compilation / installation issues [#980](https://github.com/Cantera/cantera/pull/980), [#1011](https://github.com/Cantera/cantera/pull/1011), [#1052](https://github.com/Cantera/cantera/pull/1052), [#1057](https://github.com/Cantera/cantera/pull/1057), [#1100](https://github.com/Cantera/cantera/pull/1100), [#1105](https://github.com/Cantera/cantera/pull/1105), [#1107](https://github.com/Cantera/cantera/pull/1107), [#1110](https://github.com/Cantera/cantera/pull/1110), [#1116](https://github.com/Cantera/cantera/pull/1116), [#1123](https://github.com/Cantera/cantera/pull/1123), [#1148](https://github.com/Cantera/cantera/pull/1148), [#1161](https://github.com/Cantera/cantera/pull/1161), [#1168](https://github.com/Cantera/cantera/pull/1168), [#1171](https://github.com/Cantera/cantera/pull/1171), [#1265](https://github.com/Cantera/cantera/pull/1265)

The complete list of changes can be found [here](https://github.com/Cantera/cantera/wiki/Cantera-2.6.0-Changelog).

## Installation

Instructions for installing Cantera 2.6 are available on the [Cantera website](https://github.com/Cantera/cantera-website/tree/v2.6.0/pages/install). Available options include Conda; pip; native installers for Windows and macOS; packages for Ubuntu, Fedora/Enterprise Linux, Gentoo, and FreeBSD; and compiling from source.

## Contributors
This release was made possible by the following contributors: [@anthony-walker](https://github.com/anthony-walker), [@band-a-prend](https://github.com/band-a-prend), [@BangShiuh](https://github.com/BangShiuh), [@blackrabbit17](https://github.com/blackrabbit17), [@bryanwweber](https://github.com/bryanwweber), [@12Chao](https://github.com/12Chao), [@chinahg](https://github.com/chinahg), [@DavidAkinpelu](https://github.com/DavidAkinpelu), [@d-e-t](https://github.com/d-e-t), [@decaluwe](https://github.com/decaluwe), [@dschmider-HSOG](https://github.com/Cantera/cantera/commits?author=dschmider-HSOG), [@g3bk47](https://github.com/g3bk47), [@gkogekar](https://github.com/gkogekar), [@ischoegl](https://github.com/ischoegl), [@jongyoonbae](https://github.com/jongyoonbae), [@lavdwall](https://github.com/lavdwall), [@leesharma](https://github.com/leesharma), [@mefuller](https://github.com/mefuller), [@paulblum](https://github.com/paulblum), [@santoshshanbhogue](https://github.com/santoshshanbhogue), [@speth](https://github.com/speth), [@stijn76](https://github.com/stijn76), [@tpg2114](https://github.com/tpg2114)
