/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import java.io.File;
import org.jetbrains.annotations.Nullable;

public class PerforceAbstractChange {
    public static final int ADD = 0;
    public static final int DELETE = 1;
    public static final int EDIT = 2;
    public static final int BRANCH = 3;
    public static final int INTEGRATE = 4;
    public static final int MOVE_ADD = 5;
    public static final int MOVE_DELETE = 6;
    public static final int UNKNOWN = -1;
    protected int myType = -1;
    private File myFile;

    @Nullable
    public final File getFile() {
        return this.myFile;
    }

    public void setFile(File file) {
        this.myFile = file;
    }

    public void setType(String type) {
        this.myType = PerforceAbstractChange.convertToType(type);
    }

    public static int convertToType(String type) {
        if ("add".equals(type)) {
            return 0;
        }
        if ("move/add".equals(type)) {
            return 5;
        }
        if ("delete".equals(type)) {
            return 1;
        }
        if ("move/delete".equals(type)) {
            return 6;
        }
        if ("edit".equals(type)) {
            return 2;
        }
        if ("branch".equals(type)) {
            return 3;
        }
        if ("integrate".equals(type)) {
            return 4;
        }
        return -1;
    }

    public final int getType() {
        return this.myType;
    }
}

