/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.BooleanReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.UTFStringParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.EventTypeDescriptor;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.ParserToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class EventTypeParser
implements IArrayElementParser<EventTypeDescriptor> {
    private final DataStructure[] dataStructures;

    public EventTypeParser(DataStructure[] dataStructures) {
        this.dataStructures = dataStructures;
    }

    @Override
    public EventTypeDescriptor readElement(ByteBufferWrapper data, Offset offset) throws InvalidJfrFileException {
        int id = NumberReaders.readInt(data, offset);
        String name = UTFStringParser.readString(data, offset);
        String description = UTFStringParser.readString(data, offset);
        String path = UTFStringParser.readString(data, offset);
        boolean hasStartTime = BooleanReader.readBoolean(data, offset);
        boolean hasThread = BooleanReader.readBoolean(data, offset);
        boolean canHaveStacktrace = BooleanReader.readBoolean(data, offset);
        boolean isRequestable = BooleanReader.readBoolean(data, offset);
        ValueDescriptor[] dataStructure = ParserToolkit.get(this.dataStructures, NumberReaders.readInt(data, offset)).getValueDescriptors();
        NumberReaders.readInt(data, offset);
        return new EventTypeDescriptor(id, name, hasStartTime, hasThread, canHaveStacktrace, isRequestable, dataStructure, description, path);
    }

    public EventTypeDescriptor[] createArray(int length) {
        return new EventTypeDescriptor[length];
    }
}

