/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.plugins.frontend.split.ui.pluginManager.action;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.marketplace.PrepareToUninstallResult;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.UiPluginManagerController;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/plugins/frontend/split/ui/pluginManager/action/UninstallPluginAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "pluginModelFacade", "Lcom/intellij/ide/plugins/newui/PluginModelFacade;", "pluginToUninstallModel", "Lcom/intellij/ide/plugins/newui/PluginUiModel;", "controller", "Lcom/intellij/ide/plugins/newui/UiPluginManagerController;", "text", "", "<init>", "(Lcom/intellij/ide/plugins/newui/PluginModelFacade;Lcom/intellij/ide/plugins/newui/PluginUiModel;Lcom/intellij/ide/plugins/newui/UiPluginManagerController;Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getUninstallDependentsMessage", "descriptor", "dependents", "", "bundledUpdate", "", "askToUninstall", "message", "intellij.platform.plugins.frontend.split"})
@ApiStatus.Internal
public abstract class UninstallPluginAction
extends AnAction {
    @NotNull
    private final PluginModelFacade pluginModelFacade;
    @NotNull
    private final PluginUiModel pluginToUninstallModel;
    @NotNull
    private final UiPluginManagerController controller;

    public UninstallPluginAction(@NotNull PluginModelFacade pluginModelFacade, @NotNull PluginUiModel pluginToUninstallModel, @NotNull UiPluginManagerController controller, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)pluginModelFacade, (String)"pluginModelFacade");
        Intrinsics.checkNotNullParameter((Object)pluginToUninstallModel, (String)"pluginToUninstallModel");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text);
        this.pluginModelFacade = pluginModelFacade;
        this.pluginToUninstallModel = pluginToUninstallModel;
        this.controller = controller;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean shouldUninstall;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List pluginIds = CollectionsKt.listOf((Object)this.pluginToUninstallModel.getPluginId());
        PrepareToUninstallResult prepareToUninstallResult = this.controller.prepareToUninstall(pluginIds);
        List list = (List)prepareToUninstallResult.getDependants().get(this.pluginToUninstallModel.getPluginId());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List dependents = list;
        boolean bundledUpdate = prepareToUninstallResult.isPluginBundled(this.pluginToUninstallModel.getPluginId());
        if (dependents.isEmpty()) {
            Object[] objectArray = new Object[]{this.pluginToUninstallModel.getName(), bundledUpdate ? 1 : 0};
            String string = IdeBundle.message((String)"prompt.uninstall.plugin", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            message = string;
            v2 = this.askToUninstall(message, bundledUpdate);
        } else {
            message = this.getUninstallDependentsMessage(this.pluginToUninstallModel, dependents, bundledUpdate);
            v2 = shouldUninstall = this.askToUninstall(message, bundledUpdate);
        }
        if (shouldUninstall) {
            this.pluginModelFacade.uninstallAndUpdateUi(this.pluginToUninstallModel, this.controller);
        }
    }

    private final String getUninstallDependentsMessage(PluginUiModel descriptor, List<String> dependents, boolean bundledUpdate) {
        String string = StringUtil.join((Collection)dependents, arg_0 -> UninstallPluginAction.getUninstallDependentsMessage$lambda$1(UninstallPluginAction::getUninstallDependentsMessage$lambda$0, arg_0), (String)"<br>");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String listOfDeps = string;
        Object[] objectArray = new Object[]{dependents.size(), descriptor.getName(), listOfDeps, bundledUpdate ? 1 : 0};
        String string2 = IdeBundle.message((String)"dialog.message.following.plugin.depend.on", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        String string3 = XmlStringUtil.wrapInHtml((CharSequence)message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrapInHtml(...)");
        return string3;
    }

    private final boolean askToUninstall(@NlsSafe String message, boolean bundledUpdate) {
        Object[] objectArray = new Object[]{bundledUpdate ? 1 : 0};
        String string = IdeBundle.message((String)"title.plugin.uninstall", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        return MessageDialogBuilder.Companion.yesNo(title, message).guessWindowAndAsk();
    }

    private static final String getUninstallDependentsMessage$lambda$0(String it) {
        return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + it;
    }

    private static final String getUninstallDependentsMessage$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

