# Security Policy

## Prologue

We take security very seriously. We ask everyone follows the  
[coordinated vulnerability disclosure model](https://en.wikipedia.org/wiki/Coordinated_vulnerability_disclosure), rather
than immediately making vulnerabilities public.

If you believe you have discovered a vulnerability please privately contact one of the 
[maintainers](https://github.com/orgs/go-webauthn/teams/maintainers) via the contact methods on their GitHub profile. Alternatively you may [Report a Security Vulnerability](https://github.com/go-webauthn/webauthn/security/advisories/new) privately using the [GitHub Security Advisory Reporting beta](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability). In
the future we will publish an official email for this purpose.

## Credit

Users who report bugs will at the discretion of the user be credited for the discovery.

## Process

1. User privately reports a potential vulnerability.
2. The [maintainers](https://github.com/orgs/go-webauthn/people) review the report and ascertain if additional information is required.
3. The [maintainers](https://github.com/orgs/go-webauthn/people) reproduce the bug.
4. The bug is patched, and if possible the user reporting the bug is given access to a fixed version or git patch.
5. The fix is confirmed to resolve the vulnerability.
6. The fix is released.
7. The [security advisory] is published sometime after users have had a chance to update.

[security advisory]: https://github.com/go-webauthn/webauthn/security/advisories
