/**
 * Test that FCV upgrade succeeds in the presence of bucket collections without timeseries options
 * Those inconsistent collections may be generated by implicit creation bugs (e.g. SERVER-87678).
 */

const testName = "fcv_upgrade_succeeds_with_buckets_without_timeseries_options";
const dbpath = MongoRunner.dataPath + testName;
const dbName = `db_${testName}`;
const bucketCollName = "system.buckets.coll";

function testUpgradeFromFCV(conn, fromFCV) {
    const db = conn.getDB(dbName);

    // Downgrade to fromFCV version
    assert.commandWorked(db.adminCommand({setFeatureCompatibilityVersion: fromFCV, confirm: true}));

    // Create a normal collection
    assert.commandWorked(db.createCollection('normalColl'));

    // Create bucket collection without timeseries options
    assert.commandWorked(db.createCollection(bucketCollName));

    assert.commandWorked(db[bucketCollName].insertOne({doc: 1}));

    // Upgrade succeeds even though we have an invalid bucket collection
    assert.commandWorked(
        db.adminCommand({setFeatureCompatibilityVersion: latestFCV, confirm: true}));

    assert.eq(1, db[bucketCollName].countDocuments({}));
    db[bucketCollName].drop();
}

function testAllTopologies(fromFCV) {
    {
        jsTest.log("Testing upgrade with standalone");
        let conn = MongoRunner.runMongod({dbpath: dbpath});

        testUpgradeFromFCV(conn, fromFCV);

        MongoRunner.stopMongod(conn);
    }

    {
        jsTest.log("Testing upgrade with replicaset");
        const rst = new ReplSetTest({nodes: 2});
        rst.startSet();
        rst.initiate();

        testUpgradeFromFCV(rst.getPrimary(), fromFCV);
        rst.stopSet();
    }

    {
        jsTest.log("Testing upgrade with sharded cluster");
        const st = new ShardingTest({shards: 2});

        testUpgradeFromFCV(st.s, fromFCV);

        st.stop();
    }
}

testAllTopologies(lastContinuousFCV);
testAllTopologies(lastLTSFCV);
