/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public final class DitaClass {
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern VALID_DITA_CLASS = Pattern.compile("(\\+|-)\\s+(topic|map)/\\S+\\s+([\\S[^/]]+/\\S+\\s+)*");
    private static final Map<String, DitaClass> cache = new ConcurrentHashMap<String, DitaClass>();
    public final String matcher;
    public final String localName;
    private final String stringValue;
    private boolean validDitaClass = false;

    @VisibleForTesting
    DitaClass(String cls) {
        String[] tokens = WHITESPACE.split(cls);
        String last = tokens[tokens.length - 1];
        this.matcher = " " + last + " ";
        this.localName = last.substring(last.indexOf(47) + 1);
        StringBuilder sb = new StringBuilder();
        for (String s : tokens) {
            sb.append(s).append(' ');
        }
        this.stringValue = sb.toString();
        this.validDitaClass = VALID_DITA_CLASS.matcher(this.stringValue).matches();
    }

    public static DitaClass getInstance(String cls) {
        if (cls == null) {
            return null;
        }
        return cache.computeIfAbsent(WHITESPACE.matcher(cls).replaceAll(" "), DitaClass::new);
    }

    public static DitaClass getInstance(Attributes atts) {
        if (atts == null) {
            return null;
        }
        return DitaClass.getInstance(atts.getValue("class"));
    }

    public static DitaClass getInstance(Element elem) {
        if (elem == null) {
            return null;
        }
        Attr attr = elem.getAttributeNode("class");
        if (attr == null) {
            return null;
        }
        return DitaClass.getInstance(attr.getNodeValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.stringValue.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DitaClass other = (DitaClass)obj;
        return this.stringValue.equals(other.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public boolean matches(DitaClass cls) {
        return cls != null && cls.toString().contains(this.matcher);
    }

    public boolean matches(String classString) {
        return classString != null && classString.contains(this.matcher);
    }

    public boolean matches(Attributes atts) {
        return this.matches(atts.getValue("class"));
    }

    public boolean matches(Node node) {
        if (node.getNodeType() == 1) {
            return this.matches(((Element)node).getAttribute("class"));
        }
        return false;
    }

    public boolean matches(XdmNode node) {
        if (node.getNodeKind() == XdmNodeKind.ELEMENT) {
            return this.matches(node.attribute("class"));
        }
        return false;
    }

    public Predicate<XdmNode> matcher() {
        return item -> item.getNodeKind() == XdmNodeKind.ELEMENT && this.matches(item.attribute("class"));
    }

    public boolean isValid() {
        return this.validDitaClass;
    }
}

