// Code generated by go-swagger; DO NOT EDIT.

package product_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// NewProductServiceEstimateCostParams creates a new ProductServiceEstimateCostParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewProductServiceEstimateCostParams() *ProductServiceEstimateCostParams {
	return &ProductServiceEstimateCostParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewProductServiceEstimateCostParamsWithTimeout creates a new ProductServiceEstimateCostParams object
// with the ability to set a timeout on a request.
func NewProductServiceEstimateCostParamsWithTimeout(timeout time.Duration) *ProductServiceEstimateCostParams {
	return &ProductServiceEstimateCostParams{
		timeout: timeout,
	}
}

// NewProductServiceEstimateCostParamsWithContext creates a new ProductServiceEstimateCostParams object
// with the ability to set a context for a request.
func NewProductServiceEstimateCostParamsWithContext(ctx context.Context) *ProductServiceEstimateCostParams {
	return &ProductServiceEstimateCostParams{
		Context: ctx,
	}
}

// NewProductServiceEstimateCostParamsWithHTTPClient creates a new ProductServiceEstimateCostParams object
// with the ability to set a custom HTTPClient for a request.
func NewProductServiceEstimateCostParamsWithHTTPClient(client *http.Client) *ProductServiceEstimateCostParams {
	return &ProductServiceEstimateCostParams{
		HTTPClient: client,
	}
}

/*
ProductServiceEstimateCostParams contains all the parameters to send to the API endpoint

	for the product service estimate cost operation.

	Typically these are written to a http.Request.
*/
type ProductServiceEstimateCostParams struct {

	// Body.
	Body *models.ProductServiceEstimateCostBody

	/* OrganizationID.

	   organization_id is the organization ID used to scope the request for the package.
	*/
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the product service estimate cost params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProductServiceEstimateCostParams) WithDefaults() *ProductServiceEstimateCostParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the product service estimate cost params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ProductServiceEstimateCostParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) WithTimeout(timeout time.Duration) *ProductServiceEstimateCostParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) WithContext(ctx context.Context) *ProductServiceEstimateCostParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) WithHTTPClient(client *http.Client) *ProductServiceEstimateCostParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) WithBody(body *models.ProductServiceEstimateCostBody) *ProductServiceEstimateCostParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) SetBody(body *models.ProductServiceEstimateCostBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) WithOrganizationID(organizationID string) *ProductServiceEstimateCostParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the product service estimate cost params
func (o *ProductServiceEstimateCostParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *ProductServiceEstimateCostParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
