// Code generated by go-swagger; DO NOT EDIT.

package consul_telemetry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-consul-telemetry-gateway/preview/2023-04-14/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetServiceTopologyReader is a Reader for the GetServiceTopology structure.
type GetServiceTopologyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetServiceTopologyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetServiceTopologyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewGetServiceTopologyInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewGetServiceTopologyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetServiceTopologyOK creates a GetServiceTopologyOK with default headers values
func NewGetServiceTopologyOK() *GetServiceTopologyOK {
	return &GetServiceTopologyOK{}
}

/*
GetServiceTopologyOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetServiceTopologyOK struct {
	Payload *models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyResponse
}

// IsSuccess returns true when this get service topology o k response has a 2xx status code
func (o *GetServiceTopologyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get service topology o k response has a 3xx status code
func (o *GetServiceTopologyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get service topology o k response has a 4xx status code
func (o *GetServiceTopologyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get service topology o k response has a 5xx status code
func (o *GetServiceTopologyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get service topology o k response a status code equal to that given
func (o *GetServiceTopologyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get service topology o k response
func (o *GetServiceTopologyOK) Code() int {
	return 200
}

func (o *GetServiceTopologyOK) Error() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] getServiceTopologyOK  %+v", 200, o.Payload)
}

func (o *GetServiceTopologyOK) String() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] getServiceTopologyOK  %+v", 200, o.Payload)
}

func (o *GetServiceTopologyOK) GetPayload() *models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyResponse {
	return o.Payload
}

func (o *GetServiceTopologyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetServiceTopologyInternalServerError creates a GetServiceTopologyInternalServerError with default headers values
func NewGetServiceTopologyInternalServerError() *GetServiceTopologyInternalServerError {
	return &GetServiceTopologyInternalServerError{}
}

/*
GetServiceTopologyInternalServerError describes a response with status code 500, with default header values.

An unexpected internal server error response.
*/
type GetServiceTopologyInternalServerError struct {
	Payload *models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyStatus
}

// IsSuccess returns true when this get service topology internal server error response has a 2xx status code
func (o *GetServiceTopologyInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get service topology internal server error response has a 3xx status code
func (o *GetServiceTopologyInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get service topology internal server error response has a 4xx status code
func (o *GetServiceTopologyInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get service topology internal server error response has a 5xx status code
func (o *GetServiceTopologyInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get service topology internal server error response a status code equal to that given
func (o *GetServiceTopologyInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get service topology internal server error response
func (o *GetServiceTopologyInternalServerError) Code() int {
	return 500
}

func (o *GetServiceTopologyInternalServerError) Error() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] getServiceTopologyInternalServerError  %+v", 500, o.Payload)
}

func (o *GetServiceTopologyInternalServerError) String() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] getServiceTopologyInternalServerError  %+v", 500, o.Payload)
}

func (o *GetServiceTopologyInternalServerError) GetPayload() *models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyStatus {
	return o.Payload
}

func (o *GetServiceTopologyInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulTelemetry20230414GetServiceTopologyStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetServiceTopologyDefault creates a GetServiceTopologyDefault with default headers values
func NewGetServiceTopologyDefault(code int) *GetServiceTopologyDefault {
	return &GetServiceTopologyDefault{
		_statusCode: code,
	}
}

/*
GetServiceTopologyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetServiceTopologyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get service topology default response has a 2xx status code
func (o *GetServiceTopologyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get service topology default response has a 3xx status code
func (o *GetServiceTopologyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get service topology default response has a 4xx status code
func (o *GetServiceTopologyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get service topology default response has a 5xx status code
func (o *GetServiceTopologyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get service topology default response a status code equal to that given
func (o *GetServiceTopologyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get service topology default response
func (o *GetServiceTopologyDefault) Code() int {
	return o._statusCode
}

func (o *GetServiceTopologyDefault) Error() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] GetServiceTopology default  %+v", o._statusCode, o.Payload)
}

func (o *GetServiceTopologyDefault) String() string {
	return fmt.Sprintf("[GET /ctgw/2023-04-14/organizations/{location.organization_id}/projects/{location.project_id}/topologies/service][%d] GetServiceTopology default  %+v", o._statusCode, o.Payload)
}

func (o *GetServiceTopologyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetServiceTopologyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
