// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse hashicorp cloud global network manager 20220215 list cluster servers response
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.ListClusterServersResponse
type HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse struct {

	// id is the user settable GNM cluster name
	ID string `json:"id,omitempty"`

	// location is the location of the cluster with an optional provider and region
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// Server is the configuration and TLS status of each consul server in a cluster
	Server []*HashicorpCloudGlobalNetworkManager20220215Server `json:"server"`
}

// Validate validates this hashicorp cloud global network manager 20220215 list cluster servers response
func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	for i := 0; i < len(m.Server); i++ {
		if swag.IsZero(m.Server[i]) { // not required
			continue
		}

		if m.Server[i] != nil {
			if err := m.Server[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("server" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("server" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 list cluster servers response based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServer(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) contextValidateServer(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Server); i++ {

		if m.Server[i] != nil {

			if swag.IsZero(m.Server[i]) { // not required
				return nil
			}

			if err := m.Server[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("server" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("server" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215ListClusterServersResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
