// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
)

// NewGroupsServiceUpdateGroup2Params creates a new GroupsServiceUpdateGroup2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupsServiceUpdateGroup2Params() *GroupsServiceUpdateGroup2Params {
	return &GroupsServiceUpdateGroup2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupsServiceUpdateGroup2ParamsWithTimeout creates a new GroupsServiceUpdateGroup2Params object
// with the ability to set a timeout on a request.
func NewGroupsServiceUpdateGroup2ParamsWithTimeout(timeout time.Duration) *GroupsServiceUpdateGroup2Params {
	return &GroupsServiceUpdateGroup2Params{
		timeout: timeout,
	}
}

// NewGroupsServiceUpdateGroup2ParamsWithContext creates a new GroupsServiceUpdateGroup2Params object
// with the ability to set a context for a request.
func NewGroupsServiceUpdateGroup2ParamsWithContext(ctx context.Context) *GroupsServiceUpdateGroup2Params {
	return &GroupsServiceUpdateGroup2Params{
		Context: ctx,
	}
}

// NewGroupsServiceUpdateGroup2ParamsWithHTTPClient creates a new GroupsServiceUpdateGroup2Params object
// with the ability to set a custom HTTPClient for a request.
func NewGroupsServiceUpdateGroup2ParamsWithHTTPClient(client *http.Client) *GroupsServiceUpdateGroup2Params {
	return &GroupsServiceUpdateGroup2Params{
		HTTPClient: client,
	}
}

/*
GroupsServiceUpdateGroup2Params contains all the parameters to send to the API endpoint

	for the groups service update group2 operation.

	Typically these are written to a http.Request.
*/
type GroupsServiceUpdateGroup2Params struct {

	/* Group.

	   group is the group being updated.
	*/
	Group *models.HashicorpCloudIamGroup

	/* ResourceName.

	     resource_name is the resource name of the group.
	iam/organization/<org_id>/group/<group_id>
	*/
	ResourceName string

	/* UpdateMask.

	   update_mask is the list of group fields being updated.
	*/
	UpdateMask *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the groups service update group2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceUpdateGroup2Params) WithDefaults() *GroupsServiceUpdateGroup2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the groups service update group2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceUpdateGroup2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithTimeout(timeout time.Duration) *GroupsServiceUpdateGroup2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithContext(ctx context.Context) *GroupsServiceUpdateGroup2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithHTTPClient(client *http.Client) *GroupsServiceUpdateGroup2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroup adds the group to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithGroup(group *models.HashicorpCloudIamGroup) *GroupsServiceUpdateGroup2Params {
	o.SetGroup(group)
	return o
}

// SetGroup adds the group to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetGroup(group *models.HashicorpCloudIamGroup) {
	o.Group = group
}

// WithResourceName adds the resourceName to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithResourceName(resourceName string) *GroupsServiceUpdateGroup2Params {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetResourceName(resourceName string) {
	o.ResourceName = resourceName
}

// WithUpdateMask adds the updateMask to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) WithUpdateMask(updateMask *string) *GroupsServiceUpdateGroup2Params {
	o.SetUpdateMask(updateMask)
	return o
}

// SetUpdateMask adds the updateMask to the groups service update group2 params
func (o *GroupsServiceUpdateGroup2Params) SetUpdateMask(updateMask *string) {
	o.UpdateMask = updateMask
}

// WriteToRequest writes these params to a swagger request
func (o *GroupsServiceUpdateGroup2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Group != nil {
		if err := r.SetBodyParam(o.Group); err != nil {
			return err
		}
	}

	// path param resource_name
	if err := r.SetPathParam("resource_name", o.ResourceName); err != nil {
		return err
	}

	if o.UpdateMask != nil {

		// query param update_mask
		var qrUpdateMask string

		if o.UpdateMask != nil {
			qrUpdateMask = *o.UpdateMask
		}
		qUpdateMask := qrUpdateMask
		if qUpdateMask != "" {

			if err := r.SetQueryParam("update_mask", qUpdateMask); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
