// Code generated by go-swagger; DO NOT EDIT.

package invitations_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// InvitationsServiceDeleteOrganizationInvitationReader is a Reader for the InvitationsServiceDeleteOrganizationInvitation structure.
type InvitationsServiceDeleteOrganizationInvitationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InvitationsServiceDeleteOrganizationInvitationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInvitationsServiceDeleteOrganizationInvitationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInvitationsServiceDeleteOrganizationInvitationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInvitationsServiceDeleteOrganizationInvitationOK creates a InvitationsServiceDeleteOrganizationInvitationOK with default headers values
func NewInvitationsServiceDeleteOrganizationInvitationOK() *InvitationsServiceDeleteOrganizationInvitationOK {
	return &InvitationsServiceDeleteOrganizationInvitationOK{}
}

/*
InvitationsServiceDeleteOrganizationInvitationOK describes a response with status code 200, with default header values.

A successful response.
*/
type InvitationsServiceDeleteOrganizationInvitationOK struct {
	Payload models.HashicorpCloudIamDeleteOrganizationInvitationResponse
}

// IsSuccess returns true when this invitations service delete organization invitation o k response has a 2xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this invitations service delete organization invitation o k response has a 3xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this invitations service delete organization invitation o k response has a 4xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this invitations service delete organization invitation o k response has a 5xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this invitations service delete organization invitation o k response a status code equal to that given
func (o *InvitationsServiceDeleteOrganizationInvitationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the invitations service delete organization invitation o k response
func (o *InvitationsServiceDeleteOrganizationInvitationOK) Code() int {
	return 200
}

func (o *InvitationsServiceDeleteOrganizationInvitationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/invitations/{invitation_id}][%d] invitationsServiceDeleteOrganizationInvitationOK %s", 200, payload)
}

func (o *InvitationsServiceDeleteOrganizationInvitationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/invitations/{invitation_id}][%d] invitationsServiceDeleteOrganizationInvitationOK %s", 200, payload)
}

func (o *InvitationsServiceDeleteOrganizationInvitationOK) GetPayload() models.HashicorpCloudIamDeleteOrganizationInvitationResponse {
	return o.Payload
}

func (o *InvitationsServiceDeleteOrganizationInvitationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInvitationsServiceDeleteOrganizationInvitationDefault creates a InvitationsServiceDeleteOrganizationInvitationDefault with default headers values
func NewInvitationsServiceDeleteOrganizationInvitationDefault(code int) *InvitationsServiceDeleteOrganizationInvitationDefault {
	return &InvitationsServiceDeleteOrganizationInvitationDefault{
		_statusCode: code,
	}
}

/*
InvitationsServiceDeleteOrganizationInvitationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type InvitationsServiceDeleteOrganizationInvitationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this invitations service delete organization invitation default response has a 2xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this invitations service delete organization invitation default response has a 3xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this invitations service delete organization invitation default response has a 4xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this invitations service delete organization invitation default response has a 5xx status code
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this invitations service delete organization invitation default response a status code equal to that given
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the invitations service delete organization invitation default response
func (o *InvitationsServiceDeleteOrganizationInvitationDefault) Code() int {
	return o._statusCode
}

func (o *InvitationsServiceDeleteOrganizationInvitationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/invitations/{invitation_id}][%d] InvitationsService_DeleteOrganizationInvitation default %s", o._statusCode, payload)
}

func (o *InvitationsServiceDeleteOrganizationInvitationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/invitations/{invitation_id}][%d] InvitationsService_DeleteOrganizationInvitation default %s", o._statusCode, payload)
}

func (o *InvitationsServiceDeleteOrganizationInvitationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *InvitationsServiceDeleteOrganizationInvitationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
