// Code generated by go-swagger; DO NOT EDIT.

package profile_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new profile service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new profile service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new profile service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for profile service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ProfileServiceConfirmMFAEnrollment(params *ProfileServiceConfirmMFAEnrollmentParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceConfirmMFAEnrollmentOK, error)

	ProfileServiceDisableMFA(params *ProfileServiceDisableMFAParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceDisableMFAOK, error)

	ProfileServiceEnableMFA(params *ProfileServiceEnableMFAParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceEnableMFAOK, error)

	ProfileServiceGetMFAStatus(params *ProfileServiceGetMFAStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceGetMFAStatusOK, error)

	ProfileServiceResetPassword(params *ProfileServiceResetPasswordParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceResetPasswordOK, error)

	ProfileServiceSendVerificationEmail(params *ProfileServiceSendVerificationEmailParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceSendVerificationEmailOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ProfileServiceConfirmMFAEnrollment confirms m f a enrollment is used to perform the first authentication with a newly setup m f a t o t p which then confirms the user s setup and activates the new m f a enrollment
*/
func (a *Client) ProfileServiceConfirmMFAEnrollment(params *ProfileServiceConfirmMFAEnrollmentParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceConfirmMFAEnrollmentOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceConfirmMFAEnrollmentParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_ConfirmMFAEnrollment",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/me/confirm-mfa-enrollment",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceConfirmMFAEnrollmentReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceConfirmMFAEnrollmentOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceConfirmMFAEnrollmentDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProfileServiceDisableMFA profile service disable m f a API
*/
func (a *Client) ProfileServiceDisableMFA(params *ProfileServiceDisableMFAParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceDisableMFAOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceDisableMFAParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_DisableMFA",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/me/disable-mfa",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceDisableMFAReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceDisableMFAOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceDisableMFADefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProfileServiceEnableMFA enables m f a triggers the process of enabling m f a for a given user
*/
func (a *Client) ProfileServiceEnableMFA(params *ProfileServiceEnableMFAParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceEnableMFAOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceEnableMFAParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_EnableMFA",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/me/enable-mfa",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceEnableMFAReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceEnableMFAOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceEnableMFADefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProfileServiceGetMFAStatus gets m f a status returns the m f a status of the current user
*/
func (a *Client) ProfileServiceGetMFAStatus(params *ProfileServiceGetMFAStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceGetMFAStatusOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceGetMFAStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_GetMFAStatus",
		Method:             "GET",
		PathPattern:        "/iam/2019-12-10/me/mfa-status",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceGetMFAStatusReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceGetMFAStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceGetMFAStatusDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProfileServiceResetPassword resets password resets a password for an email password user
*/
func (a *Client) ProfileServiceResetPassword(params *ProfileServiceResetPasswordParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceResetPasswordOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceResetPasswordParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_ResetPassword",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/me/reset-password",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceResetPasswordReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceResetPasswordOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceResetPasswordDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ProfileServiceSendVerificationEmail sends verification email triggers a new verification email to be sent to calling user s email address
*/
func (a *Client) ProfileServiceSendVerificationEmail(params *ProfileServiceSendVerificationEmailParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ProfileServiceSendVerificationEmailOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewProfileServiceSendVerificationEmailParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ProfileService_SendVerificationEmail",
		Method:             "POST",
		PathPattern:        "/iam/2019-12-10/me/send-verification-email",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ProfileServiceSendVerificationEmailReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ProfileServiceSendVerificationEmailOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ProfileServiceSendVerificationEmailDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
