// Code generated by go-swagger; DO NOT EDIT.

package profile_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProfileServiceGetMFAStatusReader is a Reader for the ProfileServiceGetMFAStatus structure.
type ProfileServiceGetMFAStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProfileServiceGetMFAStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProfileServiceGetMFAStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProfileServiceGetMFAStatusDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProfileServiceGetMFAStatusOK creates a ProfileServiceGetMFAStatusOK with default headers values
func NewProfileServiceGetMFAStatusOK() *ProfileServiceGetMFAStatusOK {
	return &ProfileServiceGetMFAStatusOK{}
}

/*
ProfileServiceGetMFAStatusOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProfileServiceGetMFAStatusOK struct {
	Payload *models.HashicorpCloudIamGetMFAStatusResponse
}

// IsSuccess returns true when this profile service get m f a status o k response has a 2xx status code
func (o *ProfileServiceGetMFAStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this profile service get m f a status o k response has a 3xx status code
func (o *ProfileServiceGetMFAStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this profile service get m f a status o k response has a 4xx status code
func (o *ProfileServiceGetMFAStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this profile service get m f a status o k response has a 5xx status code
func (o *ProfileServiceGetMFAStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this profile service get m f a status o k response a status code equal to that given
func (o *ProfileServiceGetMFAStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the profile service get m f a status o k response
func (o *ProfileServiceGetMFAStatusOK) Code() int {
	return 200
}

func (o *ProfileServiceGetMFAStatusOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/me/mfa-status][%d] profileServiceGetMFAStatusOK %s", 200, payload)
}

func (o *ProfileServiceGetMFAStatusOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/me/mfa-status][%d] profileServiceGetMFAStatusOK %s", 200, payload)
}

func (o *ProfileServiceGetMFAStatusOK) GetPayload() *models.HashicorpCloudIamGetMFAStatusResponse {
	return o.Payload
}

func (o *ProfileServiceGetMFAStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetMFAStatusResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProfileServiceGetMFAStatusDefault creates a ProfileServiceGetMFAStatusDefault with default headers values
func NewProfileServiceGetMFAStatusDefault(code int) *ProfileServiceGetMFAStatusDefault {
	return &ProfileServiceGetMFAStatusDefault{
		_statusCode: code,
	}
}

/*
ProfileServiceGetMFAStatusDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProfileServiceGetMFAStatusDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this profile service get m f a status default response has a 2xx status code
func (o *ProfileServiceGetMFAStatusDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this profile service get m f a status default response has a 3xx status code
func (o *ProfileServiceGetMFAStatusDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this profile service get m f a status default response has a 4xx status code
func (o *ProfileServiceGetMFAStatusDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this profile service get m f a status default response has a 5xx status code
func (o *ProfileServiceGetMFAStatusDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this profile service get m f a status default response a status code equal to that given
func (o *ProfileServiceGetMFAStatusDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the profile service get m f a status default response
func (o *ProfileServiceGetMFAStatusDefault) Code() int {
	return o._statusCode
}

func (o *ProfileServiceGetMFAStatusDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/me/mfa-status][%d] ProfileService_GetMFAStatus default %s", o._statusCode, payload)
}

func (o *ProfileServiceGetMFAStatusDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/me/mfa-status][%d] ProfileService_GetMFAStatus default %s", o._statusCode, payload)
}

func (o *ProfileServiceGetMFAStatusDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProfileServiceGetMFAStatusDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
