// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// NewStreamingServiceTestDestinationParams creates a new StreamingServiceTestDestinationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewStreamingServiceTestDestinationParams() *StreamingServiceTestDestinationParams {
	return &StreamingServiceTestDestinationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewStreamingServiceTestDestinationParamsWithTimeout creates a new StreamingServiceTestDestinationParams object
// with the ability to set a timeout on a request.
func NewStreamingServiceTestDestinationParamsWithTimeout(timeout time.Duration) *StreamingServiceTestDestinationParams {
	return &StreamingServiceTestDestinationParams{
		timeout: timeout,
	}
}

// NewStreamingServiceTestDestinationParamsWithContext creates a new StreamingServiceTestDestinationParams object
// with the ability to set a context for a request.
func NewStreamingServiceTestDestinationParamsWithContext(ctx context.Context) *StreamingServiceTestDestinationParams {
	return &StreamingServiceTestDestinationParams{
		Context: ctx,
	}
}

// NewStreamingServiceTestDestinationParamsWithHTTPClient creates a new StreamingServiceTestDestinationParams object
// with the ability to set a custom HTTPClient for a request.
func NewStreamingServiceTestDestinationParamsWithHTTPClient(client *http.Client) *StreamingServiceTestDestinationParams {
	return &StreamingServiceTestDestinationParams{
		HTTPClient: client,
	}
}

/*
StreamingServiceTestDestinationParams contains all the parameters to send to the API endpoint

	for the streaming service test destination operation.

	Typically these are written to a http.Request.
*/
type StreamingServiceTestDestinationParams struct {

	// Body.
	Body *models.LogService20210330TestDestinationRequest

	// OrganizationID.
	OrganizationID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the streaming service test destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StreamingServiceTestDestinationParams) WithDefaults() *StreamingServiceTestDestinationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the streaming service test destination params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *StreamingServiceTestDestinationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) WithTimeout(timeout time.Duration) *StreamingServiceTestDestinationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) WithContext(ctx context.Context) *StreamingServiceTestDestinationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) WithHTTPClient(client *http.Client) *StreamingServiceTestDestinationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) WithBody(body *models.LogService20210330TestDestinationRequest) *StreamingServiceTestDestinationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) SetBody(body *models.LogService20210330TestDestinationRequest) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) WithOrganizationID(organizationID string) *StreamingServiceTestDestinationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the streaming service test destination params
func (o *StreamingServiceTestDestinationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WriteToRequest writes these params to a swagger request
func (o *StreamingServiceTestDestinationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
