// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330AuthenticationInfo AuthenticationInfo contains information about the person or process who
// caused a control-plane event.
//
// swagger:model log_service_20210330AuthenticationInfo
type LogService20210330AuthenticationInfo struct {

	// principal is the authenticated principal as returned by
	// iam.GetCurrentPrincipal(). This can be a user, service, or an internal
	// operator principal.
	Principal *CloudiamPrincipal `json:"principal,omitempty"`

	// service_principal_delegation_chain store the chain of assumed principals
	// leading up to the current principal. The order of principals will be in the
	// order the identities were assumed.
	ServicePrincipalDelegationChain []*LogService20210330ServicePrincipalDelegationInfo `json:"service_principal_delegation_chain"`
}

// Validate validates this log service 20210330 authentication info
func (m *LogService20210330AuthenticationInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePrincipal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServicePrincipalDelegationChain(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330AuthenticationInfo) validatePrincipal(formats strfmt.Registry) error {
	if swag.IsZero(m.Principal) { // not required
		return nil
	}

	if m.Principal != nil {
		if err := m.Principal.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("principal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("principal")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330AuthenticationInfo) validateServicePrincipalDelegationChain(formats strfmt.Registry) error {
	if swag.IsZero(m.ServicePrincipalDelegationChain) { // not required
		return nil
	}

	for i := 0; i < len(m.ServicePrincipalDelegationChain); i++ {
		if swag.IsZero(m.ServicePrincipalDelegationChain[i]) { // not required
			continue
		}

		if m.ServicePrincipalDelegationChain[i] != nil {
			if err := m.ServicePrincipalDelegationChain[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_principal_delegation_chain" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("service_principal_delegation_chain" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this log service 20210330 authentication info based on the context it is used
func (m *LogService20210330AuthenticationInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePrincipal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServicePrincipalDelegationChain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330AuthenticationInfo) contextValidatePrincipal(ctx context.Context, formats strfmt.Registry) error {

	if m.Principal != nil {

		if swag.IsZero(m.Principal) { // not required
			return nil
		}

		if err := m.Principal.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("principal")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("principal")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330AuthenticationInfo) contextValidateServicePrincipalDelegationChain(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ServicePrincipalDelegationChain); i++ {

		if m.ServicePrincipalDelegationChain[i] != nil {

			if swag.IsZero(m.ServicePrincipalDelegationChain[i]) { // not required
				return nil
			}

			if err := m.ServicePrincipalDelegationChain[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_principal_delegation_chain" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("service_principal_delegation_chain" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330AuthenticationInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330AuthenticationInfo) UnmarshalBinary(b []byte) error {
	var res LogService20210330AuthenticationInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
