// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330CreateStreamingDestinationRequest CreateStreamingDestinationRequest represents the request to create a new destination record.
//
// swagger:model log_service_20210330CreateStreamingDestinationRequest
type LogService20210330CreateStreamingDestinationRequest struct {

	// cloudwatchlogs_provider represents a cloudwatch provider.
	CloudwatchlogsProvider *LogService20210330CloudwatchLogsProvider `json:"cloudwatchlogs_provider,omitempty"`

	// datadog_provider represents a datadog provider.
	DatadogProvider *LogService20210330DatadogProvider `json:"datadog_provider,omitempty"`

	// destination_name represents the human readable name of a destination
	DestinationName string `json:"destination_name,omitempty"`

	// location is the location (orgID - projectID) the streaming destination will belong to.
	Location *CloudlocationLocation `json:"location,omitempty"`

	// config is the object that stores information about the destination. URL, Authentication, etc...
	// source_channel denotes where the create request was made from. For example terraform or the hcp ui.
	SourceChannel string `json:"source_channel,omitempty"`

	// splunk_cloud_provider represents a splunk provider.
	SplunkCloudProvider *LogService20210330SplunkCloudProvider `json:"splunk_cloud_provider,omitempty"`
}

// Validate validates this log service 20210330 create streaming destination request
func (m *LogService20210330CreateStreamingDestinationRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudwatchlogsProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatadogProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSplunkCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) validateCloudwatchlogsProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudwatchlogsProvider) { // not required
		return nil
	}

	if m.CloudwatchlogsProvider != nil {
		if err := m.CloudwatchlogsProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) validateDatadogProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.DatadogProvider) { // not required
		return nil
	}

	if m.DatadogProvider != nil {
		if err := m.DatadogProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) validateSplunkCloudProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.SplunkCloudProvider) { // not required
		return nil
	}

	if m.SplunkCloudProvider != nil {
		if err := m.SplunkCloudProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 create streaming destination request based on the context it is used
func (m *LogService20210330CreateStreamingDestinationRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudwatchlogsProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatadogProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplunkCloudProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) contextValidateCloudwatchlogsProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudwatchlogsProvider != nil {

		if swag.IsZero(m.CloudwatchlogsProvider) { // not required
			return nil
		}

		if err := m.CloudwatchlogsProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) contextValidateDatadogProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.DatadogProvider != nil {

		if swag.IsZero(m.DatadogProvider) { // not required
			return nil
		}

		if err := m.DatadogProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330CreateStreamingDestinationRequest) contextValidateSplunkCloudProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.SplunkCloudProvider != nil {

		if swag.IsZero(m.SplunkCloudProvider) { // not required
			return nil
		}

		if err := m.SplunkCloudProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330CreateStreamingDestinationRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330CreateStreamingDestinationRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330CreateStreamingDestinationRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
