// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudPackerBucketAncestry The parent-child relationship between two image buckets.
//
// swagger:model hashicorp.cloud.packer.BucketAncestry
type HashicorpCloudPackerBucketAncestry struct {

	// The child image bucket and the iteration in that image bucket that relates to the parent.
	Child *HashicorpCloudPackerBucketAncestryChild `json:"child,omitempty"`

	// The parent image bucket and iteration that relates to the child image bucket's latest iteration.
	Parent *HashicorpCloudPackerBucketAncestryParent `json:"parent,omitempty"`

	// The status of the relationship between the parent and child buckets.
	Status *HashicorpCloudPackerBucketAncestryStatus `json:"status,omitempty"`
}

// Validate validates this hashicorp cloud packer bucket ancestry
func (m *HashicorpCloudPackerBucketAncestry) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) validateChild(formats strfmt.Registry) error {
	if swag.IsZero(m.Child) { // not required
		return nil
	}

	if m.Child != nil {
		if err := m.Child.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("child")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("child")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) validateParent(formats strfmt.Registry) error {
	if swag.IsZero(m.Parent) { // not required
		return nil
	}

	if m.Parent != nil {
		if err := m.Parent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer bucket ancestry based on the context it is used
func (m *HashicorpCloudPackerBucketAncestry) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) contextValidateChild(ctx context.Context, formats strfmt.Registry) error {

	if m.Child != nil {

		if swag.IsZero(m.Child) { // not required
			return nil
		}

		if err := m.Child.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("child")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("child")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) contextValidateParent(ctx context.Context, formats strfmt.Registry) error {

	if m.Parent != nil {

		if swag.IsZero(m.Parent) { // not required
			return nil
		}

		if err := m.Parent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parent")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPackerBucketAncestry) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {

		if swag.IsZero(m.Status) { // not required
			return nil
		}

		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPackerBucketAncestry) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPackerBucketAncestry) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPackerBucketAncestry
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
