// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// UpdateBoxReader is a Reader for the UpdateBox structure.
type UpdateBoxReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateBoxReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateBoxOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateBoxDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateBoxOK creates a UpdateBoxOK with default headers values
func NewUpdateBoxOK() *UpdateBoxOK {
	return &UpdateBoxOK{}
}

/*
UpdateBoxOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateBoxOK struct {
	Payload *models.HashicorpCloudVagrant20220930UpdateBoxResponse
}

// IsSuccess returns true when this update box o k response has a 2xx status code
func (o *UpdateBoxOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update box o k response has a 3xx status code
func (o *UpdateBoxOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update box o k response has a 4xx status code
func (o *UpdateBoxOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update box o k response has a 5xx status code
func (o *UpdateBoxOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update box o k response a status code equal to that given
func (o *UpdateBoxOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update box o k response
func (o *UpdateBoxOK) Code() int {
	return 200
}

func (o *UpdateBoxOK) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}][%d] updateBoxOK  %+v", 200, o.Payload)
}

func (o *UpdateBoxOK) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}][%d] updateBoxOK  %+v", 200, o.Payload)
}

func (o *UpdateBoxOK) GetPayload() *models.HashicorpCloudVagrant20220930UpdateBoxResponse {
	return o.Payload
}

func (o *UpdateBoxOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930UpdateBoxResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateBoxDefault creates a UpdateBoxDefault with default headers values
func NewUpdateBoxDefault(code int) *UpdateBoxDefault {
	return &UpdateBoxDefault{
		_statusCode: code,
	}
}

/*
UpdateBoxDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateBoxDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this update box default response has a 2xx status code
func (o *UpdateBoxDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update box default response has a 3xx status code
func (o *UpdateBoxDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update box default response has a 4xx status code
func (o *UpdateBoxDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update box default response has a 5xx status code
func (o *UpdateBoxDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update box default response a status code equal to that given
func (o *UpdateBoxDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update box default response
func (o *UpdateBoxDefault) Code() int {
	return o._statusCode
}

func (o *UpdateBoxDefault) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}][%d] UpdateBox default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateBoxDefault) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}][%d] UpdateBox default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateBoxDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *UpdateBoxDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
