// Code generated by go-swagger; DO NOT EDIT.

package vault_link_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-link-service/preview/2022-11-07/models"
)

// GetLinkedClusterReader is a Reader for the GetLinkedCluster structure.
type GetLinkedClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetLinkedClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetLinkedClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetLinkedClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetLinkedClusterOK creates a GetLinkedClusterOK with default headers values
func NewGetLinkedClusterOK() *GetLinkedClusterOK {
	return &GetLinkedClusterOK{}
}

/*
GetLinkedClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetLinkedClusterOK struct {
	Payload *models.HashicorpCloudVaultLink20221107GetLinkedClusterResponse
}

// IsSuccess returns true when this get linked cluster o k response has a 2xx status code
func (o *GetLinkedClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get linked cluster o k response has a 3xx status code
func (o *GetLinkedClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get linked cluster o k response has a 4xx status code
func (o *GetLinkedClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get linked cluster o k response has a 5xx status code
func (o *GetLinkedClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get linked cluster o k response a status code equal to that given
func (o *GetLinkedClusterOK) IsCode(code int) bool {
	return code == 200
}

func (o *GetLinkedClusterOK) Error() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/link/clusters/{cluster_id}][%d] getLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *GetLinkedClusterOK) String() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/link/clusters/{cluster_id}][%d] getLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *GetLinkedClusterOK) GetPayload() *models.HashicorpCloudVaultLink20221107GetLinkedClusterResponse {
	return o.Payload
}

func (o *GetLinkedClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVaultLink20221107GetLinkedClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetLinkedClusterDefault creates a GetLinkedClusterDefault with default headers values
func NewGetLinkedClusterDefault(code int) *GetLinkedClusterDefault {
	return &GetLinkedClusterDefault{
		_statusCode: code,
	}
}

/*
GetLinkedClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetLinkedClusterDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the get linked cluster default response
func (o *GetLinkedClusterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this get linked cluster default response has a 2xx status code
func (o *GetLinkedClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get linked cluster default response has a 3xx status code
func (o *GetLinkedClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get linked cluster default response has a 4xx status code
func (o *GetLinkedClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get linked cluster default response has a 5xx status code
func (o *GetLinkedClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get linked cluster default response a status code equal to that given
func (o *GetLinkedClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *GetLinkedClusterDefault) Error() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/link/clusters/{cluster_id}][%d] GetLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *GetLinkedClusterDefault) String() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/link/clusters/{cluster_id}][%d] GetLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *GetLinkedClusterDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetLinkedClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
