// Code generated by go-swagger; DO NOT EDIT.

package tenant_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListOrganizationTenantsParams creates a new ListOrganizationTenantsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListOrganizationTenantsParams() *ListOrganizationTenantsParams {
	return &ListOrganizationTenantsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListOrganizationTenantsParamsWithTimeout creates a new ListOrganizationTenantsParams object
// with the ability to set a timeout on a request.
func NewListOrganizationTenantsParamsWithTimeout(timeout time.Duration) *ListOrganizationTenantsParams {
	return &ListOrganizationTenantsParams{
		timeout: timeout,
	}
}

// NewListOrganizationTenantsParamsWithContext creates a new ListOrganizationTenantsParams object
// with the ability to set a context for a request.
func NewListOrganizationTenantsParamsWithContext(ctx context.Context) *ListOrganizationTenantsParams {
	return &ListOrganizationTenantsParams{
		Context: ctx,
	}
}

// NewListOrganizationTenantsParamsWithHTTPClient creates a new ListOrganizationTenantsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListOrganizationTenantsParamsWithHTTPClient(client *http.Client) *ListOrganizationTenantsParams {
	return &ListOrganizationTenantsParams{
		HTTPClient: client,
	}
}

/*
ListOrganizationTenantsParams contains all the parameters to send to the API endpoint

	for the list organization tenants operation.

	Typically these are written to a http.Request.
*/
type ListOrganizationTenantsParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list organization tenants params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListOrganizationTenantsParams) WithDefaults() *ListOrganizationTenantsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list organization tenants params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListOrganizationTenantsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithTimeout(timeout time.Duration) *ListOrganizationTenantsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithContext(ctx context.Context) *ListOrganizationTenantsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithHTTPClient(client *http.Client) *ListOrganizationTenantsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithLocationOrganizationID(locationOrganizationID string) *ListOrganizationTenantsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithLocationProjectID(locationProjectID string) *ListOrganizationTenantsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithLocationRegionProvider(locationRegionProvider *string) *ListOrganizationTenantsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list organization tenants params
func (o *ListOrganizationTenantsParams) WithLocationRegionRegion(locationRegionRegion *string) *ListOrganizationTenantsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list organization tenants params
func (o *ListOrganizationTenantsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *ListOrganizationTenantsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
