// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CreateHcpTerraformSyncIntegrationReader is a Reader for the CreateHcpTerraformSyncIntegration structure.
type CreateHcpTerraformSyncIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateHcpTerraformSyncIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateHcpTerraformSyncIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateHcpTerraformSyncIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateHcpTerraformSyncIntegrationOK creates a CreateHcpTerraformSyncIntegrationOK with default headers values
func NewCreateHcpTerraformSyncIntegrationOK() *CreateHcpTerraformSyncIntegrationOK {
	return &CreateHcpTerraformSyncIntegrationOK{}
}

/*
CreateHcpTerraformSyncIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateHcpTerraformSyncIntegrationOK struct {
	Payload *models.Secrets20230613CreateSyncIntegrationResponse
}

// IsSuccess returns true when this create hcp terraform sync integration o k response has a 2xx status code
func (o *CreateHcpTerraformSyncIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create hcp terraform sync integration o k response has a 3xx status code
func (o *CreateHcpTerraformSyncIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create hcp terraform sync integration o k response has a 4xx status code
func (o *CreateHcpTerraformSyncIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create hcp terraform sync integration o k response has a 5xx status code
func (o *CreateHcpTerraformSyncIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create hcp terraform sync integration o k response a status code equal to that given
func (o *CreateHcpTerraformSyncIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create hcp terraform sync integration o k response
func (o *CreateHcpTerraformSyncIntegrationOK) Code() int {
	return 200
}

func (o *CreateHcpTerraformSyncIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform][%d] createHcpTerraformSyncIntegrationOK %s", 200, payload)
}

func (o *CreateHcpTerraformSyncIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform][%d] createHcpTerraformSyncIntegrationOK %s", 200, payload)
}

func (o *CreateHcpTerraformSyncIntegrationOK) GetPayload() *models.Secrets20230613CreateSyncIntegrationResponse {
	return o.Payload
}

func (o *CreateHcpTerraformSyncIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613CreateSyncIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateHcpTerraformSyncIntegrationDefault creates a CreateHcpTerraformSyncIntegrationDefault with default headers values
func NewCreateHcpTerraformSyncIntegrationDefault(code int) *CreateHcpTerraformSyncIntegrationDefault {
	return &CreateHcpTerraformSyncIntegrationDefault{
		_statusCode: code,
	}
}

/*
CreateHcpTerraformSyncIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateHcpTerraformSyncIntegrationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create hcp terraform sync integration default response has a 2xx status code
func (o *CreateHcpTerraformSyncIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create hcp terraform sync integration default response has a 3xx status code
func (o *CreateHcpTerraformSyncIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create hcp terraform sync integration default response has a 4xx status code
func (o *CreateHcpTerraformSyncIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create hcp terraform sync integration default response has a 5xx status code
func (o *CreateHcpTerraformSyncIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create hcp terraform sync integration default response a status code equal to that given
func (o *CreateHcpTerraformSyncIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create hcp terraform sync integration default response
func (o *CreateHcpTerraformSyncIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *CreateHcpTerraformSyncIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform][%d] CreateHcpTerraformSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateHcpTerraformSyncIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform][%d] CreateHcpTerraformSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateHcpTerraformSyncIntegrationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateHcpTerraformSyncIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateHcpTerraformSyncIntegrationBody create hcp terraform sync integration body
swagger:model CreateHcpTerraformSyncIntegrationBody
*/
type CreateHcpTerraformSyncIntegrationBody struct {

	// hcp terraform connection details
	HcpTerraformConnectionDetails *models.Secrets20230613HcpTerraformConnectionDetailsRequest `json:"hcp_terraform_connection_details,omitempty"`

	// location
	Location *CreateHcpTerraformSyncIntegrationParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this create hcp terraform sync integration body
func (o *CreateHcpTerraformSyncIntegrationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHcpTerraformConnectionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateHcpTerraformSyncIntegrationBody) validateHcpTerraformConnectionDetails(formats strfmt.Registry) error {
	if swag.IsZero(o.HcpTerraformConnectionDetails) { // not required
		return nil
	}

	if o.HcpTerraformConnectionDetails != nil {
		if err := o.HcpTerraformConnectionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "hcp_terraform_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "hcp_terraform_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateHcpTerraformSyncIntegrationBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create hcp terraform sync integration body based on the context it is used
func (o *CreateHcpTerraformSyncIntegrationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHcpTerraformConnectionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateHcpTerraformSyncIntegrationBody) contextValidateHcpTerraformConnectionDetails(ctx context.Context, formats strfmt.Registry) error {

	if o.HcpTerraformConnectionDetails != nil {

		if swag.IsZero(o.HcpTerraformConnectionDetails) { // not required
			return nil
		}

		if err := o.HcpTerraformConnectionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "hcp_terraform_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "hcp_terraform_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateHcpTerraformSyncIntegrationBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateHcpTerraformSyncIntegrationBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateHcpTerraformSyncIntegrationBody) UnmarshalBinary(b []byte) error {
	var res CreateHcpTerraformSyncIntegrationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateHcpTerraformSyncIntegrationParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateHcpTerraformSyncIntegrationParamsBodyLocation
*/
type CreateHcpTerraformSyncIntegrationParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create hcp terraform sync integration params body location
func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create hcp terraform sync integration params body location based on the context it is used
func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateHcpTerraformSyncIntegrationParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateHcpTerraformSyncIntegrationParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
