// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// GetAppReader is a Reader for the GetApp structure.
type GetAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAppOK creates a GetAppOK with default headers values
func NewGetAppOK() *GetAppOK {
	return &GetAppOK{}
}

/*
GetAppOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAppOK struct {
	Payload *models.Secrets20230613GetAppResponse
}

// IsSuccess returns true when this get app o k response has a 2xx status code
func (o *GetAppOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get app o k response has a 3xx status code
func (o *GetAppOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get app o k response has a 4xx status code
func (o *GetAppOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get app o k response has a 5xx status code
func (o *GetAppOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get app o k response a status code equal to that given
func (o *GetAppOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get app o k response
func (o *GetAppOK) Code() int {
	return 200
}

func (o *GetAppOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] getAppOK %s", 200, payload)
}

func (o *GetAppOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] getAppOK %s", 200, payload)
}

func (o *GetAppOK) GetPayload() *models.Secrets20230613GetAppResponse {
	return o.Payload
}

func (o *GetAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613GetAppResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAppDefault creates a GetAppDefault with default headers values
func NewGetAppDefault(code int) *GetAppDefault {
	return &GetAppDefault{
		_statusCode: code,
	}
}

/*
GetAppDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAppDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this get app default response has a 2xx status code
func (o *GetAppDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get app default response has a 3xx status code
func (o *GetAppDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get app default response has a 4xx status code
func (o *GetAppDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get app default response has a 5xx status code
func (o *GetAppDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get app default response a status code equal to that given
func (o *GetAppDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get app default response
func (o *GetAppDefault) Code() int {
	return o._statusCode
}

func (o *GetAppDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] GetApp default %s", o._statusCode, payload)
}

func (o *GetAppDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}][%d] GetApp default %s", o._statusCode, payload)
}

func (o *GetAppDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *GetAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
