// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// ListSyncIntegrationsReader is a Reader for the ListSyncIntegrations structure.
type ListSyncIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListSyncIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListSyncIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListSyncIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListSyncIntegrationsOK creates a ListSyncIntegrationsOK with default headers values
func NewListSyncIntegrationsOK() *ListSyncIntegrationsOK {
	return &ListSyncIntegrationsOK{}
}

/*
ListSyncIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListSyncIntegrationsOK struct {
	Payload *models.Secrets20230613ListSyncIntegrationsResponse
}

// IsSuccess returns true when this list sync integrations o k response has a 2xx status code
func (o *ListSyncIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list sync integrations o k response has a 3xx status code
func (o *ListSyncIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list sync integrations o k response has a 4xx status code
func (o *ListSyncIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list sync integrations o k response has a 5xx status code
func (o *ListSyncIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list sync integrations o k response a status code equal to that given
func (o *ListSyncIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list sync integrations o k response
func (o *ListSyncIntegrationsOK) Code() int {
	return 200
}

func (o *ListSyncIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations][%d] listSyncIntegrationsOK %s", 200, payload)
}

func (o *ListSyncIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations][%d] listSyncIntegrationsOK %s", 200, payload)
}

func (o *ListSyncIntegrationsOK) GetPayload() *models.Secrets20230613ListSyncIntegrationsResponse {
	return o.Payload
}

func (o *ListSyncIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613ListSyncIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListSyncIntegrationsDefault creates a ListSyncIntegrationsDefault with default headers values
func NewListSyncIntegrationsDefault(code int) *ListSyncIntegrationsDefault {
	return &ListSyncIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListSyncIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListSyncIntegrationsDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this list sync integrations default response has a 2xx status code
func (o *ListSyncIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list sync integrations default response has a 3xx status code
func (o *ListSyncIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list sync integrations default response has a 4xx status code
func (o *ListSyncIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list sync integrations default response has a 5xx status code
func (o *ListSyncIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list sync integrations default response a status code equal to that given
func (o *ListSyncIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list sync integrations default response
func (o *ListSyncIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListSyncIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations][%d] ListSyncIntegrations default %s", o._statusCode, payload)
}

func (o *ListSyncIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations][%d] ListSyncIntegrations default %s", o._statusCode, payload)
}

func (o *ListSyncIntegrationsDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *ListSyncIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
