// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListAzureIntegrationsReader is a Reader for the ListAzureIntegrations structure.
type ListAzureIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListAzureIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListAzureIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListAzureIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListAzureIntegrationsOK creates a ListAzureIntegrationsOK with default headers values
func NewListAzureIntegrationsOK() *ListAzureIntegrationsOK {
	return &ListAzureIntegrationsOK{}
}

/*
ListAzureIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListAzureIntegrationsOK struct {
	Payload *models.Secrets20231128ListAzureIntegrationsResponse
}

// IsSuccess returns true when this list azure integrations o k response has a 2xx status code
func (o *ListAzureIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list azure integrations o k response has a 3xx status code
func (o *ListAzureIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list azure integrations o k response has a 4xx status code
func (o *ListAzureIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list azure integrations o k response has a 5xx status code
func (o *ListAzureIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list azure integrations o k response a status code equal to that given
func (o *ListAzureIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list azure integrations o k response
func (o *ListAzureIntegrationsOK) Code() int {
	return 200
}

func (o *ListAzureIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config][%d] listAzureIntegrationsOK %s", 200, payload)
}

func (o *ListAzureIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config][%d] listAzureIntegrationsOK %s", 200, payload)
}

func (o *ListAzureIntegrationsOK) GetPayload() *models.Secrets20231128ListAzureIntegrationsResponse {
	return o.Payload
}

func (o *ListAzureIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListAzureIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAzureIntegrationsDefault creates a ListAzureIntegrationsDefault with default headers values
func NewListAzureIntegrationsDefault(code int) *ListAzureIntegrationsDefault {
	return &ListAzureIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListAzureIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListAzureIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list azure integrations default response has a 2xx status code
func (o *ListAzureIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list azure integrations default response has a 3xx status code
func (o *ListAzureIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list azure integrations default response has a 4xx status code
func (o *ListAzureIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list azure integrations default response has a 5xx status code
func (o *ListAzureIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list azure integrations default response a status code equal to that given
func (o *ListAzureIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list azure integrations default response
func (o *ListAzureIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListAzureIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config][%d] ListAzureIntegrations default %s", o._statusCode, payload)
}

func (o *ListAzureIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config][%d] ListAzureIntegrations default %s", o._statusCode, payload)
}

func (o *ListAzureIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListAzureIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
