// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewUnsealParams creates a new UnsealParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUnsealParams() *UnsealParams {
	return &UnsealParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUnsealParamsWithTimeout creates a new UnsealParams object
// with the ability to set a timeout on a request.
func NewUnsealParamsWithTimeout(timeout time.Duration) *UnsealParams {
	return &UnsealParams{
		timeout: timeout,
	}
}

// NewUnsealParamsWithContext creates a new UnsealParams object
// with the ability to set a context for a request.
func NewUnsealParamsWithContext(ctx context.Context) *UnsealParams {
	return &UnsealParams{
		Context: ctx,
	}
}

// NewUnsealParamsWithHTTPClient creates a new UnsealParams object
// with the ability to set a custom HTTPClient for a request.
func NewUnsealParamsWithHTTPClient(client *http.Client) *UnsealParams {
	return &UnsealParams{
		HTTPClient: client,
	}
}

/*
UnsealParams contains all the parameters to send to the API endpoint

	for the unseal operation.

	Typically these are written to a http.Request.
*/
type UnsealParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125UnsealRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the unseal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnsealParams) WithDefaults() *UnsealParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the unseal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UnsealParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the unseal params
func (o *UnsealParams) WithTimeout(timeout time.Duration) *UnsealParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the unseal params
func (o *UnsealParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the unseal params
func (o *UnsealParams) WithContext(ctx context.Context) *UnsealParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the unseal params
func (o *UnsealParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the unseal params
func (o *UnsealParams) WithHTTPClient(client *http.Client) *UnsealParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the unseal params
func (o *UnsealParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the unseal params
func (o *UnsealParams) WithBody(body *models.HashicorpCloudVault20201125UnsealRequest) *UnsealParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the unseal params
func (o *UnsealParams) SetBody(body *models.HashicorpCloudVault20201125UnsealRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the unseal params
func (o *UnsealParams) WithClusterID(clusterID string) *UnsealParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the unseal params
func (o *UnsealParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the unseal params
func (o *UnsealParams) WithLocationOrganizationID(locationOrganizationID string) *UnsealParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the unseal params
func (o *UnsealParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the unseal params
func (o *UnsealParams) WithLocationProjectID(locationProjectID string) *UnsealParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the unseal params
func (o *UnsealParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *UnsealParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
