// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceCheckTFCOrganizationReader is a Reader for the WaypointServiceCheckTFCOrganization structure.
type WaypointServiceCheckTFCOrganizationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCheckTFCOrganizationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCheckTFCOrganizationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCheckTFCOrganizationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCheckTFCOrganizationOK creates a WaypointServiceCheckTFCOrganizationOK with default headers values
func NewWaypointServiceCheckTFCOrganizationOK() *WaypointServiceCheckTFCOrganizationOK {
	return &WaypointServiceCheckTFCOrganizationOK{}
}

/*
WaypointServiceCheckTFCOrganizationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCheckTFCOrganizationOK struct {
	Payload *models.HashicorpCloudWaypointCheckTFCOrganizationResponse
}

// IsSuccess returns true when this waypoint service check t f c organization o k response has a 2xx status code
func (o *WaypointServiceCheckTFCOrganizationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service check t f c organization o k response has a 3xx status code
func (o *WaypointServiceCheckTFCOrganizationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service check t f c organization o k response has a 4xx status code
func (o *WaypointServiceCheckTFCOrganizationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service check t f c organization o k response has a 5xx status code
func (o *WaypointServiceCheckTFCOrganizationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service check t f c organization o k response a status code equal to that given
func (o *WaypointServiceCheckTFCOrganizationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service check t f c organization o k response
func (o *WaypointServiceCheckTFCOrganizationOK) Code() int {
	return 200
}

func (o *WaypointServiceCheckTFCOrganizationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig/check-organization][%d] waypointServiceCheckTFCOrganizationOK %s", 200, payload)
}

func (o *WaypointServiceCheckTFCOrganizationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig/check-organization][%d] waypointServiceCheckTFCOrganizationOK %s", 200, payload)
}

func (o *WaypointServiceCheckTFCOrganizationOK) GetPayload() *models.HashicorpCloudWaypointCheckTFCOrganizationResponse {
	return o.Payload
}

func (o *WaypointServiceCheckTFCOrganizationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCheckTFCOrganizationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCheckTFCOrganizationDefault creates a WaypointServiceCheckTFCOrganizationDefault with default headers values
func NewWaypointServiceCheckTFCOrganizationDefault(code int) *WaypointServiceCheckTFCOrganizationDefault {
	return &WaypointServiceCheckTFCOrganizationDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCheckTFCOrganizationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCheckTFCOrganizationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service check t f c organization default response has a 2xx status code
func (o *WaypointServiceCheckTFCOrganizationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service check t f c organization default response has a 3xx status code
func (o *WaypointServiceCheckTFCOrganizationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service check t f c organization default response has a 4xx status code
func (o *WaypointServiceCheckTFCOrganizationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service check t f c organization default response has a 5xx status code
func (o *WaypointServiceCheckTFCOrganizationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service check t f c organization default response a status code equal to that given
func (o *WaypointServiceCheckTFCOrganizationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service check t f c organization default response
func (o *WaypointServiceCheckTFCOrganizationDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCheckTFCOrganizationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig/check-organization][%d] WaypointService_CheckTFCOrganization default %s", o._statusCode, payload)
}

func (o *WaypointServiceCheckTFCOrganizationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcconfig/check-organization][%d] WaypointService_CheckTFCOrganization default %s", o._statusCode, payload)
}

func (o *WaypointServiceCheckTFCOrganizationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCheckTFCOrganizationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
