// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceDeleteNamespaceReader is a Reader for the WaypointServiceDeleteNamespace structure.
type WaypointServiceDeleteNamespaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteNamespaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteNamespaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteNamespaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteNamespaceOK creates a WaypointServiceDeleteNamespaceOK with default headers values
func NewWaypointServiceDeleteNamespaceOK() *WaypointServiceDeleteNamespaceOK {
	return &WaypointServiceDeleteNamespaceOK{}
}

/*
WaypointServiceDeleteNamespaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteNamespaceOK struct {
	Payload models.HashicorpCloudWaypointDeleteNamespaceResponse
}

// IsSuccess returns true when this waypoint service delete namespace o k response has a 2xx status code
func (o *WaypointServiceDeleteNamespaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete namespace o k response has a 3xx status code
func (o *WaypointServiceDeleteNamespaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete namespace o k response has a 4xx status code
func (o *WaypointServiceDeleteNamespaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete namespace o k response has a 5xx status code
func (o *WaypointServiceDeleteNamespaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete namespace o k response a status code equal to that given
func (o *WaypointServiceDeleteNamespaceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete namespace o k response
func (o *WaypointServiceDeleteNamespaceOK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteNamespaceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces/{namespace.id}][%d] waypointServiceDeleteNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceDeleteNamespaceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces/{namespace.id}][%d] waypointServiceDeleteNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceDeleteNamespaceOK) GetPayload() models.HashicorpCloudWaypointDeleteNamespaceResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteNamespaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteNamespaceDefault creates a WaypointServiceDeleteNamespaceDefault with default headers values
func NewWaypointServiceDeleteNamespaceDefault(code int) *WaypointServiceDeleteNamespaceDefault {
	return &WaypointServiceDeleteNamespaceDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteNamespaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteNamespaceDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete namespace default response has a 2xx status code
func (o *WaypointServiceDeleteNamespaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete namespace default response has a 3xx status code
func (o *WaypointServiceDeleteNamespaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete namespace default response has a 4xx status code
func (o *WaypointServiceDeleteNamespaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete namespace default response has a 5xx status code
func (o *WaypointServiceDeleteNamespaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete namespace default response a status code equal to that given
func (o *WaypointServiceDeleteNamespaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete namespace default response
func (o *WaypointServiceDeleteNamespaceDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteNamespaceDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces/{namespace.id}][%d] WaypointService_DeleteNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteNamespaceDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/organizations/{location.organization_id}/projects/{location.project_id}/namespaces/{namespace.id}][%d] WaypointService_DeleteNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteNamespaceDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteNamespaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
