// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetAddOnDefinitionReader is a Reader for the WaypointServiceGetAddOnDefinition structure.
type WaypointServiceGetAddOnDefinitionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetAddOnDefinitionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetAddOnDefinitionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetAddOnDefinitionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetAddOnDefinitionOK creates a WaypointServiceGetAddOnDefinitionOK with default headers values
func NewWaypointServiceGetAddOnDefinitionOK() *WaypointServiceGetAddOnDefinitionOK {
	return &WaypointServiceGetAddOnDefinitionOK{}
}

/*
WaypointServiceGetAddOnDefinitionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetAddOnDefinitionOK struct {
	Payload *models.HashicorpCloudWaypointGetAddOnDefinitionResponse
}

// IsSuccess returns true when this waypoint service get add on definition o k response has a 2xx status code
func (o *WaypointServiceGetAddOnDefinitionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get add on definition o k response has a 3xx status code
func (o *WaypointServiceGetAddOnDefinitionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get add on definition o k response has a 4xx status code
func (o *WaypointServiceGetAddOnDefinitionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get add on definition o k response has a 5xx status code
func (o *WaypointServiceGetAddOnDefinitionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get add on definition o k response a status code equal to that given
func (o *WaypointServiceGetAddOnDefinitionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get add on definition o k response
func (o *WaypointServiceGetAddOnDefinitionOK) Code() int {
	return 200
}

func (o *WaypointServiceGetAddOnDefinitionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}][%d] waypointServiceGetAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceGetAddOnDefinitionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}][%d] waypointServiceGetAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceGetAddOnDefinitionOK) GetPayload() *models.HashicorpCloudWaypointGetAddOnDefinitionResponse {
	return o.Payload
}

func (o *WaypointServiceGetAddOnDefinitionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetAddOnDefinitionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetAddOnDefinitionDefault creates a WaypointServiceGetAddOnDefinitionDefault with default headers values
func NewWaypointServiceGetAddOnDefinitionDefault(code int) *WaypointServiceGetAddOnDefinitionDefault {
	return &WaypointServiceGetAddOnDefinitionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceGetAddOnDefinitionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetAddOnDefinitionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get add on definition default response has a 2xx status code
func (o *WaypointServiceGetAddOnDefinitionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get add on definition default response has a 3xx status code
func (o *WaypointServiceGetAddOnDefinitionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get add on definition default response has a 4xx status code
func (o *WaypointServiceGetAddOnDefinitionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get add on definition default response has a 5xx status code
func (o *WaypointServiceGetAddOnDefinitionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get add on definition default response a status code equal to that given
func (o *WaypointServiceGetAddOnDefinitionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get add on definition default response
func (o *WaypointServiceGetAddOnDefinitionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetAddOnDefinitionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}][%d] WaypointService_GetAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetAddOnDefinitionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{add_on_definition.id}][%d] WaypointService_GetAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetAddOnDefinitionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetAddOnDefinitionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
