// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUIListAddOnDefinitionsReader is a Reader for the WaypointServiceUIListAddOnDefinitions structure.
type WaypointServiceUIListAddOnDefinitionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUIListAddOnDefinitionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUIListAddOnDefinitionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUIListAddOnDefinitionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUIListAddOnDefinitionsOK creates a WaypointServiceUIListAddOnDefinitionsOK with default headers values
func NewWaypointServiceUIListAddOnDefinitionsOK() *WaypointServiceUIListAddOnDefinitionsOK {
	return &WaypointServiceUIListAddOnDefinitionsOK{}
}

/*
WaypointServiceUIListAddOnDefinitionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUIListAddOnDefinitionsOK struct {
	Payload *models.HashicorpCloudWaypointUIListAddOnDefinitionsResponse
}

// IsSuccess returns true when this waypoint service Ui list add on definitions o k response has a 2xx status code
func (o *WaypointServiceUIListAddOnDefinitionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service Ui list add on definitions o k response has a 3xx status code
func (o *WaypointServiceUIListAddOnDefinitionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service Ui list add on definitions o k response has a 4xx status code
func (o *WaypointServiceUIListAddOnDefinitionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service Ui list add on definitions o k response has a 5xx status code
func (o *WaypointServiceUIListAddOnDefinitionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service Ui list add on definitions o k response a status code equal to that given
func (o *WaypointServiceUIListAddOnDefinitionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service Ui list add on definitions o k response
func (o *WaypointServiceUIListAddOnDefinitionsOK) Code() int {
	return 200
}

func (o *WaypointServiceUIListAddOnDefinitionsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/add-on-definitions][%d] waypointServiceUiListAddOnDefinitionsOK %s", 200, payload)
}

func (o *WaypointServiceUIListAddOnDefinitionsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/add-on-definitions][%d] waypointServiceUiListAddOnDefinitionsOK %s", 200, payload)
}

func (o *WaypointServiceUIListAddOnDefinitionsOK) GetPayload() *models.HashicorpCloudWaypointUIListAddOnDefinitionsResponse {
	return o.Payload
}

func (o *WaypointServiceUIListAddOnDefinitionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUIListAddOnDefinitionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUIListAddOnDefinitionsDefault creates a WaypointServiceUIListAddOnDefinitionsDefault with default headers values
func NewWaypointServiceUIListAddOnDefinitionsDefault(code int) *WaypointServiceUIListAddOnDefinitionsDefault {
	return &WaypointServiceUIListAddOnDefinitionsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUIListAddOnDefinitionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUIListAddOnDefinitionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service UI list add on definitions default response has a 2xx status code
func (o *WaypointServiceUIListAddOnDefinitionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service UI list add on definitions default response has a 3xx status code
func (o *WaypointServiceUIListAddOnDefinitionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service UI list add on definitions default response has a 4xx status code
func (o *WaypointServiceUIListAddOnDefinitionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service UI list add on definitions default response has a 5xx status code
func (o *WaypointServiceUIListAddOnDefinitionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service UI list add on definitions default response a status code equal to that given
func (o *WaypointServiceUIListAddOnDefinitionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service UI list add on definitions default response
func (o *WaypointServiceUIListAddOnDefinitionsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUIListAddOnDefinitionsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/add-on-definitions][%d] WaypointService_UI_ListAddOnDefinitions default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIListAddOnDefinitionsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/add-on-definitions][%d] WaypointService_UI_ListAddOnDefinitions default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIListAddOnDefinitionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUIListAddOnDefinitionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
