// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceUILoadProductBannerReader is a Reader for the WaypointServiceUILoadProductBanner structure.
type WaypointServiceUILoadProductBannerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUILoadProductBannerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUILoadProductBannerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUILoadProductBannerDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUILoadProductBannerOK creates a WaypointServiceUILoadProductBannerOK with default headers values
func NewWaypointServiceUILoadProductBannerOK() *WaypointServiceUILoadProductBannerOK {
	return &WaypointServiceUILoadProductBannerOK{}
}

/*
WaypointServiceUILoadProductBannerOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUILoadProductBannerOK struct {
	Payload *models.HashicorpCloudWaypointUILoadProductBannerResponse
}

// IsSuccess returns true when this waypoint service Ui load product banner o k response has a 2xx status code
func (o *WaypointServiceUILoadProductBannerOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service Ui load product banner o k response has a 3xx status code
func (o *WaypointServiceUILoadProductBannerOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service Ui load product banner o k response has a 4xx status code
func (o *WaypointServiceUILoadProductBannerOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service Ui load product banner o k response has a 5xx status code
func (o *WaypointServiceUILoadProductBannerOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service Ui load product banner o k response a status code equal to that given
func (o *WaypointServiceUILoadProductBannerOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service Ui load product banner o k response
func (o *WaypointServiceUILoadProductBannerOK) Code() int {
	return 200
}

func (o *WaypointServiceUILoadProductBannerOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/product-banner][%d] waypointServiceUiLoadProductBannerOK %s", 200, payload)
}

func (o *WaypointServiceUILoadProductBannerOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/product-banner][%d] waypointServiceUiLoadProductBannerOK %s", 200, payload)
}

func (o *WaypointServiceUILoadProductBannerOK) GetPayload() *models.HashicorpCloudWaypointUILoadProductBannerResponse {
	return o.Payload
}

func (o *WaypointServiceUILoadProductBannerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUILoadProductBannerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUILoadProductBannerDefault creates a WaypointServiceUILoadProductBannerDefault with default headers values
func NewWaypointServiceUILoadProductBannerDefault(code int) *WaypointServiceUILoadProductBannerDefault {
	return &WaypointServiceUILoadProductBannerDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUILoadProductBannerDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUILoadProductBannerDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service UI load product banner default response has a 2xx status code
func (o *WaypointServiceUILoadProductBannerDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service UI load product banner default response has a 3xx status code
func (o *WaypointServiceUILoadProductBannerDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service UI load product banner default response has a 4xx status code
func (o *WaypointServiceUILoadProductBannerDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service UI load product banner default response has a 5xx status code
func (o *WaypointServiceUILoadProductBannerDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service UI load product banner default response a status code equal to that given
func (o *WaypointServiceUILoadProductBannerDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service UI load product banner default response
func (o *WaypointServiceUILoadProductBannerDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUILoadProductBannerDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/product-banner][%d] WaypointService_UI_LoadProductBanner default %s", o._statusCode, payload)
}

func (o *WaypointServiceUILoadProductBannerDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/product-banner][%d] WaypointService_UI_LoadProductBanner default %s", o._statusCode, payload)
}

func (o *WaypointServiceUILoadProductBannerDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUILoadProductBannerDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
