// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// NewWaypointServiceUpdateAgentGroupParams creates a new WaypointServiceUpdateAgentGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceUpdateAgentGroupParams() *WaypointServiceUpdateAgentGroupParams {
	return &WaypointServiceUpdateAgentGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceUpdateAgentGroupParamsWithTimeout creates a new WaypointServiceUpdateAgentGroupParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceUpdateAgentGroupParamsWithTimeout(timeout time.Duration) *WaypointServiceUpdateAgentGroupParams {
	return &WaypointServiceUpdateAgentGroupParams{
		timeout: timeout,
	}
}

// NewWaypointServiceUpdateAgentGroupParamsWithContext creates a new WaypointServiceUpdateAgentGroupParams object
// with the ability to set a context for a request.
func NewWaypointServiceUpdateAgentGroupParamsWithContext(ctx context.Context) *WaypointServiceUpdateAgentGroupParams {
	return &WaypointServiceUpdateAgentGroupParams{
		Context: ctx,
	}
}

// NewWaypointServiceUpdateAgentGroupParamsWithHTTPClient creates a new WaypointServiceUpdateAgentGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceUpdateAgentGroupParamsWithHTTPClient(client *http.Client) *WaypointServiceUpdateAgentGroupParams {
	return &WaypointServiceUpdateAgentGroupParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceUpdateAgentGroupParams contains all the parameters to send to the API endpoint

	for the waypoint service update agent group operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceUpdateAgentGroupParams struct {

	// Body.
	Body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAgentGroupBody

	/* Name.

	     The name of the group to update
	We don’t allow groups to be renamed so this is a stable identifier.
	*/
	Name string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service update agent group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpdateAgentGroupParams) WithDefaults() *WaypointServiceUpdateAgentGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service update agent group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUpdateAgentGroupParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithTimeout(timeout time.Duration) *WaypointServiceUpdateAgentGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithContext(ctx context.Context) *WaypointServiceUpdateAgentGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithHTTPClient(client *http.Client) *WaypointServiceUpdateAgentGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAgentGroupBody) *WaypointServiceUpdateAgentGroupParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetBody(body *models.HashicorpCloudWaypointV20241122WaypointServiceUpdateAgentGroupBody) {
	o.Body = body
}

// WithName adds the name to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithName(name string) *WaypointServiceUpdateAgentGroupParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetName(name string) {
	o.Name = name
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceUpdateAgentGroupParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceUpdateAgentGroupParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service update agent group params
func (o *WaypointServiceUpdateAgentGroupParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceUpdateAgentGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
