// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceUpdateApplyReader is a Reader for the BoundaryServiceUpdateApply structure.
type BoundaryServiceUpdateApplyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceUpdateApplyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceUpdateApplyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceUpdateApplyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceUpdateApplyOK creates a BoundaryServiceUpdateApplyOK with default headers values
func NewBoundaryServiceUpdateApplyOK() *BoundaryServiceUpdateApplyOK {
	return &BoundaryServiceUpdateApplyOK{}
}

/*
BoundaryServiceUpdateApplyOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceUpdateApplyOK struct {
	Payload models.HashicorpCloudBoundary20211221UpdateApplyResponse
}

// IsSuccess returns true when this boundary service update apply o k response has a 2xx status code
func (o *BoundaryServiceUpdateApplyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service update apply o k response has a 3xx status code
func (o *BoundaryServiceUpdateApplyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service update apply o k response has a 4xx status code
func (o *BoundaryServiceUpdateApplyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service update apply o k response has a 5xx status code
func (o *BoundaryServiceUpdateApplyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service update apply o k response a status code equal to that given
func (o *BoundaryServiceUpdateApplyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service update apply o k response
func (o *BoundaryServiceUpdateApplyOK) Code() int {
	return 200
}

func (o *BoundaryServiceUpdateApplyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/update][%d] boundaryServiceUpdateApplyOK %s", 200, payload)
}

func (o *BoundaryServiceUpdateApplyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/update][%d] boundaryServiceUpdateApplyOK %s", 200, payload)
}

func (o *BoundaryServiceUpdateApplyOK) GetPayload() models.HashicorpCloudBoundary20211221UpdateApplyResponse {
	return o.Payload
}

func (o *BoundaryServiceUpdateApplyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceUpdateApplyDefault creates a BoundaryServiceUpdateApplyDefault with default headers values
func NewBoundaryServiceUpdateApplyDefault(code int) *BoundaryServiceUpdateApplyDefault {
	return &BoundaryServiceUpdateApplyDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceUpdateApplyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceUpdateApplyDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service update apply default response has a 2xx status code
func (o *BoundaryServiceUpdateApplyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service update apply default response has a 3xx status code
func (o *BoundaryServiceUpdateApplyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service update apply default response has a 4xx status code
func (o *BoundaryServiceUpdateApplyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service update apply default response has a 5xx status code
func (o *BoundaryServiceUpdateApplyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service update apply default response a status code equal to that given
func (o *BoundaryServiceUpdateApplyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service update apply default response
func (o *BoundaryServiceUpdateApplyDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceUpdateApplyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/update][%d] BoundaryService_UpdateApply default %s", o._statusCode, payload)
}

func (o *BoundaryServiceUpdateApplyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/update][%d] BoundaryService_UpdateApply default %s", o._statusCode, payload)
}

func (o *BoundaryServiceUpdateApplyDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceUpdateApplyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
